/*
 * Decompiled with CFR 0.152.
 */
package tvdataservice;

import devplugin.Channel;
import devplugin.ChannelDayProgram;
import devplugin.Date;
import devplugin.Program;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import tvdataservice.MutableProgram;
import util.program.ProgramUtilities;

public class MutableChannelDayProgram
implements ChannelDayProgram {
    private static final Logger mLog = Logger.getLogger(MutableChannelDayProgram.class.getName());
    private Date mDate;
    private Channel mChannel;
    private ArrayList<Program> mProgramList;
    private boolean mLastProgramHadEndOnUpdate;
    private boolean mWasChangedByPlugin;

    public MutableChannelDayProgram(Date date, Channel channel) {
        this.mDate = date;
        this.mChannel = channel;
        this.mLastProgramHadEndOnUpdate = false;
        this.mWasChangedByPlugin = false;
        this.mProgramList = new ArrayList();
    }

    @Override
    public Channel getChannel() {
        return this.mChannel;
    }

    @Override
    public Date getDate() {
        return this.mDate;
    }

    @Override
    public Program getProgram(String progID) {
        Program[] programs = this.getPrograms(progID, true);
        if (programs != null && programs.length > 0) {
            return programs[0];
        }
        return null;
    }

    @Override
    public Program[] getPrograms(String progID) {
        return this.getPrograms(progID, false);
    }

    private Program[] getPrograms(String progID, boolean onlyFirst) {
        progID = ProgramUtilities.getTimeZoneCorrectedProgramId(progID);
        int strLen = progID.length();
        int idlength = 1;
        for (int i = 0; i < strLen; ++i) {
            if (progID.charAt(i) != '_') continue;
            ++idlength;
        }
        ArrayList<Program> foundPrograms = new ArrayList<Program>();
        for (Program prog : this.mProgramList) {
            String[] temp;
            Object id = prog.getID();
            if (idlength > 4) {
                if (progID.compareTo((String)id) != 0) continue;
                if (onlyFirst) {
                    return new Program[]{prog};
                }
                foundPrograms.add(prog);
                continue;
            }
            if (idlength < 4) {
                temp = ((String)id).split("_");
                id = temp[temp.length - 2] + "_" + temp[temp.length - 1];
                continue;
            }
            if (idlength != 4) continue;
            temp = ((String)id).split("_");
            id = temp[0] + "_" + temp[1] + "_" + temp[temp.length - 2] + "_" + temp[temp.length - 1];
        }
        if (!foundPrograms.isEmpty()) {
            return foundPrograms.toArray(new Program[foundPrograms.size()]);
        }
        return null;
    }

    @Override
    public int getProgramCount() {
        return this.mProgramList.size();
    }

    @Override
    public Program getProgramAt(int index) {
        return this.mProgramList.get(index);
    }

    public void addProgram(Program program) {
        int addIdx;
        if (!program.getChannel().equals(this.mChannel)) {
            mLog.severe("Trying to add program of channel " + program.getChannel().getName() + " to day program of channel " + this.mChannel.getName());
            return;
        }
        int time = program.getStartTime();
        for (addIdx = this.mProgramList.size(); addIdx > 0; --addIdx) {
            Program cmp = this.mProgramList.get(addIdx - 1);
            int cmpTime = cmp.getStartTime();
            if (program.getDate().compareTo(cmp.getDate()) > 0 || program.getDate().compareTo(cmp.getDate()) >= 0 && cmpTime <= time) break;
        }
        this.mProgramList.add(addIdx, program);
    }

    public void removeAllPrograms() {
        this.mProgramList.clear();
    }

    @Override
    public Iterator<Program> getPrograms() {
        return this.mProgramList.iterator();
    }

    @Override
    public boolean isComplete() {
        int size = this.mProgramList.size();
        if (size == 0) {
            return false;
        }
        Program lastProgram = this.mProgramList.get(size - 1);
        int endTime = lastProgram.getHours() * 60 + lastProgram.getMinutes() + lastProgram.getLength();
        return endTime >= 1380;
    }

    public void setLastProgramHadEndOnUpdate(boolean value) {
        this.mLastProgramHadEndOnUpdate = value;
    }

    @Override
    public boolean getLastProgramHadEndOnUpdate() {
        return this.mLastProgramHadEndOnUpdate;
    }

    public void setWasChangedByPlugin() {
        this.mWasChangedByPlugin = true;
    }

    public boolean getAndResetChangedByPluginState() {
        boolean temp = this.mWasChangedByPlugin;
        this.mWasChangedByPlugin = false;
        return temp;
    }

    public boolean equals(ChannelDayProgram dayProgram) {
        if (this.getProgramCount() != dayProgram.getProgramCount()) {
            return false;
        }
        if (!this.getChannel().equals(dayProgram.getChannel())) {
            return false;
        }
        for (int i = 0; i < this.getProgramCount(); ++i) {
            Program program = this.getProgramAt(i);
            Program otherProgram = dayProgram.getProgramAt(i);
            if (program instanceof MutableProgram && otherProgram instanceof MutableProgram) {
                if (((MutableProgram)program).equalsAllFields((MutableProgram)otherProgram)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public int getIndexForTime(int minutes) {
        for (int i = 0; i < this.mProgramList.size(); ++i) {
            Program p = this.mProgramList.get(i);
            if (p.getStartTime() > minutes) {
                return i - 1;
            }
            if (p.getStartTime() != minutes) continue;
            return i;
        }
        if (this.mProgramList.size() > 0 && this.mProgramList.get(0).getStartTime() < minutes) {
            return 0;
        }
        return -1;
    }
}

