/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import util.io.DownloadHandler;
import util.io.DownloadJob;
import util.io.IOUtilities;

public class DownloadManager {
    private static final Logger mLog = Logger.getLogger(DownloadManager.class.getName());
    private int mConcurrentDownloads;
    private LinkedList<DownloadJob> mJobList;
    private AtomicInteger mActiveThreadCount;
    private Thread mWaitingThread;

    public DownloadManager() {
        this(10);
    }

    public DownloadManager(int concurrentDownloads) {
        this.mConcurrentDownloads = concurrentDownloads;
        this.mJobList = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownloadJob(String serverUrl, String fileName, DownloadHandler handler) {
        LinkedList<DownloadJob> linkedList = this.mJobList;
        synchronized (linkedList) {
            this.mJobList.add(new DownloadJob(serverUrl, fileName, handler));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllDownloadJobs() {
        LinkedList<DownloadJob> linkedList = this.mJobList;
        synchronized (linkedList) {
            this.mJobList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDownloadJobCount() {
        LinkedList<DownloadJob> linkedList = this.mJobList;
        synchronized (linkedList) {
            return this.mJobList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDownload() {
        boolean isFinished;
        this.mActiveThreadCount = new AtomicInteger(0);
        if (this.mConcurrentDownloads < 1) {
            this.mConcurrentDownloads = 1;
        }
        this.mWaitingThread = Thread.currentThread();
        if (this.mConcurrentDownloads > 5) {
            System.setProperty("http.maxConnections", Integer.toString(this.mConcurrentDownloads));
        } else {
            System.setProperty("http.maxConnections", "5");
        }
        for (int i = 0; i < this.mConcurrentDownloads; ++i) {
            Thread downloadThread = new Thread("Download manager"){

                @Override
                public void run() {
                    DownloadManager.this.downloadThreadRun();
                }
            };
            downloadThread.start();
        }
        do {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LinkedList<DownloadJob> linkedList = this.mJobList;
            synchronized (linkedList) {
                isFinished = this.mJobList.isEmpty() && this.mActiveThreadCount.get() == 0;
            }
        } while (!isFinished);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadThreadRun() {
        this.mActiveThreadCount.getAndIncrement();
        boolean isFinished = false;
        do {
            DownloadJob job = null;
            LinkedList<DownloadJob> linkedList = this.mJobList;
            synchronized (linkedList) {
                if (this.mJobList.isEmpty()) {
                    isFinished = true;
                } else {
                    job = this.mJobList.removeFirst();
                }
            }
            if (job == null) continue;
            String url = job.getServerUrl() + (job.getServerUrl().endsWith("/") ? "" : "/") + job.getFileName();
            mLog.info("Loading " + url + "...");
            InputStream stream = null;
            try {
                stream = IOUtilities.getStream(new URL(url));
            }
            catch (Throwable thr) {
                if (this.isFileNotFound(thr)) {
                    try {
                        job.getDownloadHandler().handleFileNotFound(job.getFileName());
                    }
                    catch (Throwable thr2) {
                        mLog.log(Level.WARNING, "File not found " + url, thr2);
                    }
                }
                mLog.log(Level.WARNING, "Error getting file " + url, thr);
            }
            if (stream == null) continue;
            try {
                job.getDownloadHandler().handleDownload(job, stream);
                stream.close();
            }
            catch (Throwable thr) {
                mLog.log(Level.WARNING, "Error downloading " + url, thr);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable thr) {}
                }
            }
        } while (!isFinished);
        this.mActiveThreadCount.getAndDecrement();
        this.mWaitingThread.interrupt();
    }

    private boolean isFileNotFound(Throwable thr) {
        while (thr != null) {
            if (thr instanceof FileNotFoundException) {
                return true;
            }
            thr = thr.getCause();
        }
        return false;
    }
}

