/*
 * Decompiled with CFR 0.152.
 */
package util.programkeyevent;

import devplugin.ContextMenuIf;
import devplugin.Program;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import tvbrowser.core.Settings;
import util.programkeyevent.ProgramKeyAndContextMenuListener;
import util.programmouseevent.ProgramMouseEventHandler;
import util.settings.ContextMenuMouseActionSetting;

public class ProgramKeyEventHandler
extends KeyAdapter {
    public static final int LEFT_SINGLE_KEY = 76;
    public static final int LEFT_DOUBLE_KEY = 68;
    public static final int MIDDLE_SINGLE_KEY = 77;
    public static final int MIDDLE_DOUBLE_KEY = 85;
    private ProgramKeyAndContextMenuListener mContextMenuListener;
    private ContextMenuIf mOwner;

    public ProgramKeyEventHandler(ProgramKeyAndContextMenuListener listener, ContextMenuIf owner) {
        this.mContextMenuListener = listener;
        this.mOwner = owner;
    }

    private void handleKeyEventFor(ContextMenuMouseActionSetting[] mouseActionSettings, KeyEvent e, Program program) {
        for (ContextMenuMouseActionSetting setting : mouseActionSettings) {
            if (setting.getModifiersEx() != e.getModifiersEx()) continue;
            if (setting.getContextMenuIf() == this.mOwner) break;
            ProgramMouseEventHandler.handleAction(program, setting.getContextMenuIf().getContextMenuActions(program), setting.getContextMenuActionId());
            break;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 76 || e.getKeyCode() == 77 || e.getKeyCode() == 68 || e.getKeyCode() == 85 || (e.getKeyCode() == 525 || e.getKeyCode() == 82) && e.getModifiersEx() == 0) {
            Program program = this.mContextMenuListener.getProgramForKeyEvent(e);
            if (program != null) {
                if (e.getKeyCode() == 525 || e.getKeyCode() == 82) {
                    this.mContextMenuListener.showContextMenu(program);
                } else if (e.getKeyCode() == 76) {
                    this.handleKeyEventFor(Settings.Mouse.LEFT_SINGLE_CLICK_IF_ARRAY.getContextMenuMouseActionArray(), e, program);
                } else if (e.getKeyCode() == 77) {
                    this.handleKeyEventFor(Settings.Mouse.MIDDLE_SINGLE_CLICK_IF_ARRAY.getContextMenuMouseActionArray(), e, program);
                } else if (e.getKeyCode() == 68) {
                    this.handleKeyEventFor(Settings.Mouse.LEFT_DOUBLE_CLICK_IF_ARRAY.getContextMenuMouseActionArray(), e, program);
                } else if (e.getKeyCode() == 85) {
                    this.handleKeyEventFor(Settings.Mouse.MIDDLE_DOUBLE_CLICK_IF_ARRAY.getContextMenuMouseActionArray(), e, program);
                }
            }
            this.mContextMenuListener.keyEventActionFinished();
            e.consume();
        }
    }
}

