/*
 * Decompiled with CFR 0.152.
 */
package util.programmouseevent;

import devplugin.ContextMenuIf;
import devplugin.Plugin;
import devplugin.Program;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import util.programmouseevent.ProgramMouseAndContextMenuListener;
import util.programmouseevent.ProgramMouseEventHandler;

public class AutoScrollerAndClickKeyHandler {
    private JComponent mScrollComponent;
    private ProgramAutoScrollListener mProgramAutoScrollListener;
    private Thread mClickThread;
    private Point mDraggingPoint;
    private Point mDraggingPointOnScreen;
    private long mLastDragTime;
    private int mLastDragDeltaX;
    private int mLastDragDeltaY;
    private Point mAutoScroll;
    private Thread mAutoScrollThread;
    private ProgramMouseEventHandler mProgramMouseEventHandler;

    public AutoScrollerAndClickKeyHandler(JComponent scrollComponent, final ProgramAutoScrollListener listener) {
        this.mScrollComponent = scrollComponent;
        this.mProgramAutoScrollListener = listener;
        this.mProgramMouseEventHandler = new ProgramMouseEventHandler(listener, null){

            @Override
            public void mousePressed(MouseEvent evt) {
                AutoScrollerAndClickKeyHandler.this.handleMousePressed(evt);
                if (listener.isClickAndContextMenuHandlingEnabled()) {
                    super.mousePressed(evt);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                AutoScrollerAndClickKeyHandler.this.handleMouseReleased(evt);
                if (listener.isClickAndContextMenuHandlingEnabled()) {
                    super.mouseReleased(evt);
                }
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                Program program = listener.getProgramAt(evt.getX(), evt.getY());
                if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 1 && evt.isShiftDown() && !evt.isControlDown() && !evt.isAltDown()) {
                    if (program != null) {
                        if (!listener.isSelectedItemAt(evt.getX(), evt.getY())) {
                            listener.selectItemAt(evt.getX(), evt.getY());
                        } else {
                            listener.deSelectItem();
                        }
                    }
                } else if (listener.isClickAndContextMenuHandlingEnabled()) {
                    super.mouseClicked(evt);
                }
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                listener.handleMouseExited(evt);
                AutoScrollerAndClickKeyHandler.this.handleMouseExited(evt);
            }
        };
        this.mScrollComponent.addMouseListener(this.mProgramMouseEventHandler);
        this.mScrollComponent.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                AutoScrollerAndClickKeyHandler.this.handleMouseDragged(evt);
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                AutoScrollerAndClickKeyHandler.this.handleMouseMoved(evt);
            }
        });
    }

    private void handleMousePressed(MouseEvent evt) {
        this.mProgramAutoScrollListener.handleMousePressed(evt);
        this.mScrollComponent.requestFocus();
        if (this.mClickThread == null || !this.mClickThread.isAlive()) {
            this.mClickThread = new Thread("AutoScroller Singe Click"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(Plugin.SINGLE_CLICK_WAITING_TIME + 50);
                        AutoScrollerAndClickKeyHandler.this.mScrollComponent.setCursor(Cursor.getPredefinedCursor(13));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            if (!evt.isShiftDown() && SwingUtilities.isLeftMouseButton(evt)) {
                this.mClickThread.start();
            }
        }
        this.setDraggingPoint(evt.getPoint());
        this.setDraggingPointOnScreen(new Point(evt.getXOnScreen(), evt.getYOnScreen()));
    }

    public void setOwner(ContextMenuIf owner) {
        this.mProgramMouseEventHandler.setOwner(owner);
    }

    private void handleMouseReleased(MouseEvent evt) {
        this.mProgramAutoScrollListener.handleMouseReleased(evt);
        if (this.mDraggingPoint != null && this.mProgramAutoScrollListener.isAutoScrollingEnabled() && System.currentTimeMillis() - this.mLastDragTime < 20L && (Math.abs(this.mLastDragDeltaX) >= 3 || Math.abs(this.mLastDragDeltaY) >= 3)) {
            this.stopAutoScroll(true);
            this.startAutoScroll(new Point(this.mLastDragDeltaX, this.mLastDragDeltaY), 2);
        }
        this.setDraggingPoint(null);
        this.setDraggingPointOnScreen(null);
        if (this.mClickThread != null && this.mClickThread.isAlive()) {
            this.mClickThread.interrupt();
        }
        this.mScrollComponent.setCursor(Cursor.getDefaultCursor());
        if (SwingUtilities.isMiddleMouseButton(evt)) {
            this.stopAutoScroll(true);
        }
    }

    private void handleMouseExited(MouseEvent evt) {
        this.mProgramAutoScrollListener.handleMouseExited(evt);
    }

    private void handleMouseDragged(MouseEvent evt) {
        this.mProgramAutoScrollListener.handleMouseDragged(evt);
        if (this.getDraggingPoint() != null && !evt.isShiftDown()) {
            if (SwingUtilities.isLeftMouseButton(evt)) {
                this.stopAutoScroll(false);
                this.mScrollComponent.setCursor(Cursor.getPredefinedCursor(13));
                this.calcualteLastDragDelta(evt.getX(), evt.getY());
                this.scrollBy(this.mLastDragDeltaX, this.mLastDragDeltaY);
            } else if (SwingUtilities.isMiddleMouseButton(evt) && this.mDraggingPointOnScreen != null) {
                Point scroll = new Point(evt.getXOnScreen() - this.mDraggingPointOnScreen.x, evt.getYOnScreen() - this.mDraggingPointOnScreen.y);
                this.startAutoScroll(scroll, 10);
            }
        }
    }

    private void handleMouseMoved(MouseEvent evt) {
        this.mProgramAutoScrollListener.handleMouseMoved(evt);
    }

    public void startAutoScroll(Point scroll, int scaling) {
        this.mScrollComponent.setCursor(Cursor.getPredefinedCursor(1));
        if (Math.abs(scroll.x) > Math.abs(scroll.y)) {
            scroll.y = 0;
        } else {
            scroll.x = 0;
        }
        if (Math.abs(scroll.x) >= scaling) {
            scroll.x /= scaling;
        }
        if (Math.abs(scroll.y) >= scaling) {
            scroll.y /= scaling;
        }
        this.mAutoScroll = scroll;
        if (this.mAutoScrollThread == null) {
            this.mAutoScrollThread = new Thread("Autoscrolling"){

                @Override
                public void run() {
                    while (AutoScrollerAndClickKeyHandler.this.mAutoScrollThread != null) {
                        SwingUtilities.invokeLater(() -> AutoScrollerAndClickKeyHandler.this.scrollBy(AutoScrollerAndClickKeyHandler.this.mAutoScroll.x, AutoScrollerAndClickKeyHandler.this.mAutoScroll.y));
                        try {
                            4.sleep(30L);
                        }
                        catch (InterruptedException e) {
                            AutoScrollerAndClickKeyHandler.this.mAutoScrollThread = null;
                        }
                    }
                    AutoScrollerAndClickKeyHandler.this.mAutoScrollThread = null;
                }
            };
            this.mAutoScrollThread.start();
        }
    }

    public void scrollBy(int deltaX, int deltaY) {
        if (this.mScrollComponent.getParent() instanceof JViewport) {
            JViewport viewport = (JViewport)this.mScrollComponent.getParent();
            Point oldViewPos = viewport.getViewPosition();
            Point viewPos = new Point(oldViewPos.x, oldViewPos.y);
            if (deltaX != 0) {
                viewPos.x += deltaX;
                int maxX = this.mScrollComponent.getWidth() - viewport.getWidth();
                viewPos.x = Math.min(viewPos.x, maxX);
                viewPos.x = Math.max(viewPos.x, 0);
            }
            if (deltaY != 0) {
                viewPos.y += deltaY;
                int maxY = this.mScrollComponent.getHeight() - viewport.getHeight();
                viewPos.y = Math.min(viewPos.y, maxY);
                viewPos.y = Math.max(viewPos.y, 0);
            }
            if (viewPos.equals(oldViewPos)) {
                this.stopAutoScroll(false);
            } else {
                viewport.setViewPosition(viewPos);
            }
        }
    }

    public boolean stopAutoScroll(boolean setCursor) {
        if (setCursor) {
            this.mScrollComponent.setCursor(Cursor.getDefaultCursor());
        }
        if (this.mAutoScrollThread != null && this.mAutoScrollThread.isAlive()) {
            this.mAutoScrollThread.interrupt();
            this.mAutoScrollThread = null;
            return true;
        }
        return false;
    }

    public void setDraggingPoint(Point p) {
        this.mDraggingPoint = p;
    }

    public void setDraggingPointOnScreen(Point p) {
        this.mDraggingPointOnScreen = p;
    }

    public void calcualteLastDragDelta(int x, int y) {
        this.mLastDragDeltaX = this.mDraggingPoint.x - x;
        this.mLastDragDeltaY = this.mDraggingPoint.y - y;
        this.mLastDragTime = System.currentTimeMillis();
    }

    public Point getDraggingPoint() {
        return this.mDraggingPoint;
    }

    public Point getDraggingPointOnScreen() {
        return this.mDraggingPointOnScreen;
    }

    public int getLastDragDeltaX() {
        return this.mLastDragDeltaX;
    }

    public int getLastDragDeltaY() {
        return this.mLastDragDeltaY;
    }

    public long getLastDragTime() {
        return this.mLastDragTime;
    }

    public boolean isScrolling() {
        return this.mAutoScrollThread != null && this.mAutoScrollThread.isAlive();
    }

    public void stopClickIfNecessary() {
        if (this.mClickThread != null && this.mClickThread.isAlive()) {
            this.mClickThread.interrupt();
        }
    }

    public static interface ProgramAutoScrollListener
    extends ProgramMouseAndContextMenuListener {
        public Program getProgramAt(int var1, int var2);

        public boolean isSelectedItemAt(int var1, int var2);

        public void selectItemAt(int var1, int var2);

        public void deSelectItem();

        public void handleMousePressed(MouseEvent var1);

        public void handleMouseReleased(MouseEvent var1);

        public void handleMouseExited(MouseEvent var1);

        public void handleMouseDragged(MouseEvent var1);

        public void handleMouseMoved(MouseEvent var1);

        public boolean isAutoScrollingEnabled();

        public boolean isClickAndContextMenuHandlingEnabled();
    }
}

