/*
 * Decompiled with CFR 0.152.
 */
package util.settings;

import java.util.HashMap;
import java.util.Set;
import util.settings.Property;
import util.settings.PropertyManager;

public class StringMapProperty
extends Property {
    private static final String SEPARATOR_ENTRIES = "\u00a7#-";
    private static final String SEPARATOR_VALUES = "#\u00a7#";
    private HashMap<String, String> mMap = new HashMap();
    private boolean mIsCacheFilled = false;

    public StringMapProperty(PropertyManager manager, String key) {
        super(manager, key);
    }

    public void putEntry(String key, int value) {
        this.putEntry(key, String.valueOf(value));
    }

    public String getEntry(String key) {
        if (!this.mIsCacheFilled) {
            this.fillCache();
        }
        return this.mMap.get(key);
    }

    public void putEntry(String key, String value) {
        if (!this.mIsCacheFilled) {
            this.fillCache();
        }
        this.mMap.put(key, value);
        this.updateProperty();
    }

    public boolean containsKey(String key) {
        if (!this.mIsCacheFilled) {
            this.fillCache();
        }
        return this.mMap.containsKey(key);
    }

    public String removeEntry(String key) {
        String result;
        if (!this.mIsCacheFilled) {
            this.fillCache();
        }
        if ((result = this.mMap.remove(key)) != null) {
            this.updateProperty();
        }
        return result;
    }

    public Set<String> getKeySet() {
        if (!this.mIsCacheFilled) {
            this.fillCache();
        }
        return this.mMap.keySet();
    }

    private void updateProperty() {
        if (!this.mIsCacheFilled) {
            this.fillCache();
        }
        Set<String> keys = this.mMap.keySet();
        StringBuilder property = new StringBuilder();
        for (String key : keys) {
            if (property.length() > 0) {
                property.append(SEPARATOR_ENTRIES);
            }
            property.append(key).append(SEPARATOR_VALUES).append(this.mMap.get(key));
        }
        this.setProperty(property.toString());
    }

    private void fillCache() {
        String prop = this.getProperty();
        if (prop != null && !prop.isBlank()) {
            String[] entries;
            for (String entry : entries = prop.split(SEPARATOR_ENTRIES)) {
                String[] parts = entry.split(SEPARATOR_VALUES);
                this.mMap.put(parts[0], parts[1]);
            }
        }
        this.mIsCacheFilled = prop != null;
    }

    @Override
    protected void clearCache() {
        this.mMap.clear();
        this.mIsCacheFilled = false;
    }
}

