/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Plugin;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.SortedMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import util.i18n.Localizer;
import util.paramhandler.ParamHelpDialog;
import util.paramhandler.ParamLibrary;
import util.paramhandler.ParamParser;
import util.program.AbstractPluginProgramFormating;
import util.ui.EnhancedPanelBuilder;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class LocalPluginProgramFormatingSettingsDialog
extends JDialog
implements WindowClosingIf,
ActionListener {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(LocalPluginProgramFormatingSettingsDialog.class);
    private AbstractPluginProgramFormating mConfig;
    private AbstractPluginProgramFormating mDefaultConfig;
    private JButton mSetName;
    private JButton mPreview;
    private JButton mSetBack;
    private JButton mHelp;
    private JButton mOk;
    private JButton mCancel;
    private JLabel mName;
    private JTextField mTitle;
    private JTextArea mContentArea;
    private JComboBox<String> mEncoding;

    public static void createInstance(Window parent, AbstractPluginProgramFormating config, AbstractPluginProgramFormating defaultConfig, boolean showTitleSetting, boolean showEncodingSetting) {
        new LocalPluginProgramFormatingSettingsDialog(parent, config, defaultConfig, showTitleSetting, showEncodingSetting);
    }

    private LocalPluginProgramFormatingSettingsDialog(Window parent, AbstractPluginProgramFormating config, AbstractPluginProgramFormating defaultConfig, boolean showTitleSetting, boolean showEncodingSetting) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.createGui(parent, config, defaultConfig, showTitleSetting, showEncodingSetting);
    }

    private void createGui(Window w, AbstractPluginProgramFormating config, AbstractPluginProgramFormating defaultConfig, boolean showTitleSetting, boolean showEncodingSetting) {
        this.mConfig = config;
        this.mDefaultConfig = defaultConfig;
        this.setTitle(LOCALIZER.msg("settingsFor", "Settings for ") + config.getName());
        UiUtilities.registerForClosing(this);
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder(new FormLayout("default,5dlu,default:grow"), (JPanel)this.getContentPane());
        pb.border(Borders.DIALOG);
        this.mName = new JLabel(config.getName());
        this.mSetName = new JButton(LOCALIZER.msg("changeName", "Change name"));
        this.mSetName.addActionListener(this);
        EnhancedPanelBuilder panel = new EnhancedPanelBuilder(new FormLayout("default:grow,5dlu,default", "default"));
        panel.add(this.mName, 1);
        panel.add(this.mSetName, 3);
        this.mTitle = new JTextField(config.getTitleValue());
        this.mContentArea = new JTextArea(config.getContentValue());
        Vector<String> encodings = new Vector<String>();
        SortedMap<String, Charset> availcs = Charset.availableCharsets();
        Set keys = availcs.keySet();
        for (String string : keys) {
            encodings.add(string);
        }
        this.mEncoding = new JComboBox(encodings);
        this.mEncoding.setSelectedItem(config.getEncodingValue());
        this.mEncoding.addActionListener(this);
        this.mPreview = new JButton(LOCALIZER.msg("preview", "Preview"));
        this.mPreview.addActionListener(this);
        this.mSetBack = new JButton(Localizer.getLocalization("i18n_default"));
        this.mSetBack.addActionListener(this);
        this.mHelp = new JButton(Localizer.getLocalization("i18n_help"));
        this.mHelp.addActionListener(this);
        this.mOk = new JButton(Localizer.getLocalization("i18n_ok"));
        this.mOk.addActionListener(this);
        this.mCancel = new JButton(Localizer.getLocalization("i18n_cancel"));
        this.mCancel.addActionListener(this);
        EnhancedPanelBuilder buttonPanel = new EnhancedPanelBuilder(new FormLayout("default,3dlu,default,3dlu,default,0dlu:grow,default,3dlu,default", "default"));
        buttonPanel.getLayout().setColumnGroups((int[][])new int[][]{{1, 3, 5, 7, 9}});
        buttonPanel.add(this.mPreview, 1);
        buttonPanel.add(this.mSetBack, 3);
        buttonPanel.add(this.mHelp, 5);
        buttonPanel.add(this.mOk, 7);
        buttonPanel.add(this.mCancel, 9);
        pb.addLabelRow(false, LOCALIZER.msg("name", "Name") + ":", 1);
        pb.add(panel.getPanel(), 3);
        if (showTitleSetting) {
            pb.addLabelRow("2dlu,default", LOCALIZER.msg("title", "Titel") + ":", 1);
            pb.add(this.mTitle, 3);
        }
        pb.addLabelRowFull(LOCALIZER.msg("content", "Content") + ":");
        pb.addRowFull("fill:default:grow", false, new JScrollPane(this.mContentArea));
        if (showEncodingSetting) {
            pb.addLabelRow(LOCALIZER.msg("encoding", "Encoding") + ":", 1);
            pb.add(this.mEncoding, 3);
        }
        pb.addRowFull(buttonPanel.getPanel());
        UiUtilities.setSize(this, 500, 400);
        this.setLocationRelativeTo(w);
        this.setVisible(true);
    }

    @Override
    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mCancel) {
            this.close();
        } else if (e.getSource() == this.mPreview) {
            this.showPreview();
        } else if (e.getSource() == this.mSetBack) {
            this.defaultPressed();
        } else if (e.getSource() == this.mHelp) {
            ParamHelpDialog dialog = new ParamHelpDialog((Window)this, new ParamLibrary());
            dialog.setVisible(true);
        } else if (e.getSource() == this.mSetName) {
            String value = JOptionPane.showInputDialog(this, LOCALIZER.msg("changeName", "Change name") + ":", this.mName.getText());
            if (value != null) {
                this.mName.setText(value);
            }
        } else if (e.getSource() == this.mOk) {
            this.mConfig.setName(this.mName.getText());
            this.mConfig.setTitleValue(this.mTitle.getText());
            this.mConfig.setContentValue(this.mContentArea.getText());
            this.mConfig.setEncodingValue(this.mEncoding.getSelectedItem().toString());
            this.close();
        }
    }

    protected void showPreview() {
        ParamParser parser = new ParamParser();
        String content = parser.analyse(this.mContentArea.getText(), Plugin.getPluginManager().getExampleProgram());
        if (parser.hasErrors()) {
            content = parser.getErrorString();
        }
        if (content == null) {
            content = "";
        }
        final JDialog dialog = new JDialog(this, LOCALIZER.msg("preview", "Preview"), true);
        JPanel contentPanel = (JPanel)dialog.getContentPane();
        UiUtilities.registerForClosing(new WindowClosingIf(){

            @Override
            public void close() {
                dialog.setVisible(false);
            }

            @Override
            public JRootPane getRootPane() {
                return dialog.getRootPane();
            }
        });
        contentPanel.setLayout((LayoutManager)new FormLayout("fill:default:grow, pref", "fill:default:grow, 3dlu, pref"));
        contentPanel.setBorder(Borders.DLU4);
        JEditorPane example = new JEditorPane("text", content);
        example.setEditable(false);
        example.setCaretPosition(0);
        CellConstraints cc = new CellConstraints();
        contentPanel.add((Component)new JScrollPane(example), cc.xyw(1, 1, 2));
        JButton ok = new JButton(Localizer.getLocalization("i18n_ok"));
        ok.addActionListener(e -> dialog.setVisible(false));
        dialog.getRootPane().setDefaultButton(ok);
        contentPanel.add((Component)ok, cc.xy(2, 3));
        dialog.setSize(500, 400);
        UiUtilities.centerAndShow(dialog);
    }

    protected void defaultPressed() {
        int ret = JOptionPane.showConfirmDialog(this, LOCALIZER.msg("reset", "Reset to default Settings?"), Localizer.getLocalization("i18n_default") + "?", 0);
        if (ret == 0) {
            this.mTitle.setText(this.mDefaultConfig.getTitleValue());
            this.mContentArea.setText(this.mDefaultConfig.getContentValue());
            this.mEncoding.setSelectedItem(this.mDefaultConfig.getEncodingValue());
        }
    }
}

