/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.TreePath;
import util.ui.UiUtilities;

public class OverlayListener
extends MouseInputAdapter {
    private JTree mTree;
    private Component mOldGlassPane;
    private TreePath mPath;
    private int mRow;
    private Rectangle mBounds;
    JComponent c = new JComponent(){

        @Override
        public void paint(Graphics g) {
            boolean selected = OverlayListener.this.mTree.isRowSelected(OverlayListener.this.mRow);
            Component renderer = OverlayListener.this.mTree.getCellRenderer().getTreeCellRendererComponent(OverlayListener.this.mTree, OverlayListener.this.mPath.getLastPathComponent(), OverlayListener.this.mTree.isRowSelected(OverlayListener.this.mRow), OverlayListener.this.mTree.isExpanded(OverlayListener.this.mRow), OverlayListener.this.mTree.getModel().isLeaf(OverlayListener.this.mPath.getLastPathComponent()), OverlayListener.this.mRow, selected);
            if (renderer instanceof JComponent) {
                ((JComponent)renderer).setOpaque(false);
            }
            OverlayListener.this.c.setFont(OverlayListener.this.mTree.getFont());
            Rectangle paintBounds = SwingUtilities.convertRectangle(OverlayListener.this.mTree, OverlayListener.this.mBounds, this);
            if (UiUtilities.isNimbusLookAndFeel()) {
                Color current = g.getColor();
                if (selected) {
                    g.setColor(UIManager.getColor("Tree.selectionBackground"));
                } else {
                    g.setColor(OverlayListener.this.mTree.getBackground());
                }
                g.fillRect(paintBounds.x, paintBounds.y, paintBounds.width, paintBounds.height);
                g.setColor(current);
            }
            SwingUtilities.paintComponent(g, renderer, this, paintBounds);
            if (selected) {
                return;
            }
            g.setColor(Color.blue);
            ((Graphics2D)g).draw(paintBounds);
        }
    };

    public OverlayListener(JTree tree) {
        this.mTree = tree;
        tree.addMouseListener(this);
        tree.addMouseMotionListener(this);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.resetGlassPane();
    }

    private void resetGlassPane() {
        if (this.mOldGlassPane != null) {
            this.c.setVisible(false);
            this.mTree.getRootPane().setGlassPane(this.mOldGlassPane);
            this.mOldGlassPane = null;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.resetGlassPane();
        super.mousePressed(e);
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        this.mPath = this.mTree.getPathForLocation(me.getX(), me.getY());
        if (this.mPath == null) {
            this.resetGlassPane();
            return;
        }
        this.mRow = this.mTree.getRowForPath(this.mPath);
        this.mBounds = this.mTree.getPathBounds(this.mPath);
        if (!this.mTree.getVisibleRect().contains(this.mBounds)) {
            if (this.mOldGlassPane == null) {
                this.mOldGlassPane = this.mTree.getRootPane().getGlassPane();
                this.c.setOpaque(false);
                this.mTree.getRootPane().setGlassPane(this.c);
                this.c.setVisible(true);
            } else {
                this.mTree.getRootPane().repaint();
            }
        } else {
            this.resetGlassPane();
        }
    }
}

