/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.common;

import com.jgoodies.looks.common.MenuItemRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuUI;

public class ExtBasicMenuUI
extends BasicMenuUI {
    private static final String MENU_PROPERTY_PREFIX = "Menu";
    private static final String SUBMENU_PROPERTY_PREFIX = "MenuItem";
    private String propertyPrefix = "Menu";
    private MenuItemRenderer renderer;
    private MouseListener mouseListener;

    public static ComponentUI createUI(JComponent b) {
        return new ExtBasicMenuUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIManager.getIcon("Menu.arrowIcon");
        }
        this.renderer = new MenuItemRenderer(this.menuItem, false, this.acceleratorFont, this.selectionForeground, this.disabledForeground, this.acceleratorForeground, this.acceleratorSelectionForeground);
        Integer gap = (Integer)UIManager.get(String.valueOf(this.getPropertyPrefix()) + ".textIconGap");
        this.defaultTextIconGap = gap != null ? gap : 2;
        LookAndFeel.installBorder(this.menuItem, String.valueOf(this.getPropertyPrefix()) + ".border");
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.renderer = null;
    }

    @Override
    protected String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon aCheckIcon, Icon anArrowIcon, int textIconGap) {
        if (ExtBasicMenuUI.isSubMenu(this.menuItem)) {
            this.ensureSubMenuInstalled();
            return this.renderer.getPreferredMenuItemSize(c, aCheckIcon, anArrowIcon, textIconGap);
        }
        return super.getPreferredMenuItemSize(c, aCheckIcon, anArrowIcon, textIconGap);
    }

    @Override
    protected void paintMenuItem(Graphics g, JComponent c, Icon aCheckIcon, Icon anArrowIcon, Color background, Color foreground, int textIconGap) {
        if (ExtBasicMenuUI.isSubMenu(this.menuItem)) {
            this.renderer.paintMenuItem(g, c, aCheckIcon, anArrowIcon, background, foreground, textIconGap);
        } else {
            super.paintMenuItem(g, c, aCheckIcon, anArrowIcon, background, foreground, textIconGap);
        }
    }

    private void ensureSubMenuInstalled() {
        if (this.propertyPrefix.equals(SUBMENU_PROPERTY_PREFIX)) {
            return;
        }
        ButtonModel model = this.menuItem.getModel();
        boolean oldArmed = model.isArmed();
        boolean oldSelected = model.isSelected();
        this.uninstallRolloverListener();
        this.uninstallDefaults();
        this.propertyPrefix = SUBMENU_PROPERTY_PREFIX;
        this.installDefaults();
        model.setArmed(oldArmed);
        model.setSelected(oldSelected);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.mouseListener = new RolloverHandler();
        this.menuItem.addMouseListener(this.mouseListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.uninstallRolloverListener();
    }

    private void uninstallRolloverListener() {
        if (this.mouseListener != null) {
            this.menuItem.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
    }

    private static boolean isSubMenu(JMenuItem aMenuItem) {
        return !((JMenu)aMenuItem).isTopLevelMenu();
    }

    private static final class RolloverHandler
    extends MouseAdapter {
        private RolloverHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            b.getModel().setRollover(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            b.getModel().setRollover(false);
        }
    }
}

