/*
 * Decompiled with CFR 0.152.
 */
package compat;

import compat.PersonaCompat;
import compat.VersionCompat;
import devplugin.Version;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import tvbrowser.TVBrowser;
import util.ui.ChannelLabel;
import util.ui.UiUtilities;

public final class UiCompat {
    public static void updateHtmlHelpTextArea(JEditorPane helpTextArea, String html, Color background) {
        UiCompat.updateHtmlHelpTextArea(helpTextArea, html, UIManager.getColor("Label.foreground"), background);
    }

    public static void updateHtmlHelpTextArea(JEditorPane helpTextArea, String html, Color foreground, Color background) {
        if (TVBrowser.VERSION.compareTo(new Version(3, 34, true)) >= 0) {
            try {
                Class<UiUtilities> clazz = UiUtilities.class;
                Method m = clazz.getMethod("updateHtmlHelpTextArea", JEditorPane.class, String.class, Color.class, Color.class);
                m.invoke(clazz, helpTextArea, html, foreground, background);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (html.indexOf("<html>") >= 0) {
                int start = html.indexOf("<html>");
                int end = html.lastIndexOf("</html>");
                if (end == -1 || end < start) {
                    end = html.length();
                }
                html = html.substring(start, end);
            }
            Font font = UIManager.getFont("Label.font");
            html = "<html><div style=\"color:" + UiUtilities.getHTMLColorCode((Color)foreground) + ";font-family:" + font.getName() + "; font-size:" + font.getSize() + ";background-color:rgb(" + background.getRed() + "," + background.getGreen() + "," + background.getBlue() + ");\">" + html + "</div></html>";
            helpTextArea.setFont(font);
            helpTextArea.setText(html);
        }
    }

    public static JPanel createPersonaBackgroundPanel() {
        JPanel panel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                if (PersonaCompat.getInstance().getAccentColor() != null && PersonaCompat.getInstance().getHeaderImage() != null) {
                    Color c = PersonaCompat.testPersonaForegroundAgainst(PersonaCompat.getInstance().getAccentColor());
                    int alpha = c.getAlpha();
                    g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha));
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                } else {
                    super.paintComponent(g);
                }
            }
        };
        panel.setOpaque(false);
        return panel;
    }

    public static ChannelLabel createChannelLabel(boolean channelIconsVisible, boolean textIsVisible, boolean showDefaultValues, boolean showCountry, boolean showJoinedChannelInfo) {
        return UiCompat.createChannelLabel(channelIconsVisible, textIsVisible, showDefaultValues, showCountry, showJoinedChannelInfo, false);
    }

    public static ChannelLabel createChannelLabel(boolean channelIconsVisible, boolean textIsVisible, boolean showDefaultValues, boolean showCountry, boolean showJoinedChannelInfo, boolean showTimeLimitation) {
        ChannelLabel result = null;
        if (VersionCompat.isJointChannelSupported()) {
            try {
                Constructor c = ChannelLabel.class.getConstructor(Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
                result = (ChannelLabel)c.newInstance(channelIconsVisible, textIsVisible, showDefaultValues, showCountry, showJoinedChannelInfo, showTimeLimitation);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result == null) {
            result = new ChannelLabel(channelIconsVisible, textIsVisible, showDefaultValues, showCountry);
        }
        return result;
    }

    public static ChannelLabel createChannelLabel(boolean channelIconsVisible, boolean textIsVisible, boolean showDefaultValues, boolean showCountry, boolean showJoinedChannelInfo, boolean showTimeLimitation, boolean showSortNumber) {
        ChannelLabel result = null;
        if (VersionCompat.isSortNumberSupported()) {
            try {
                Constructor c = ChannelLabel.class.getConstructor(Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
                result = (ChannelLabel)c.newInstance(channelIconsVisible, textIsVisible, showDefaultValues, showCountry, showJoinedChannelInfo, showTimeLimitation, showSortNumber);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result == null) {
            result = UiCompat.createChannelLabel(channelIconsVisible, textIsVisible, showDefaultValues, showCountry, showJoinedChannelInfo, showTimeLimitation);
        }
        return result;
    }

    public static ChannelLabel createChannelLabel(boolean channelIconsVisible, boolean textIsVisible, boolean showDefaultValues, boolean showCountry, boolean showJoinedChannelInfo, boolean showTimeLimitation, boolean showSortNumber, boolean paintBackground) {
        ChannelLabel result = null;
        if (TVBrowser.VERSION.compareTo(new Version(3, 44, 95, false)) >= 0) {
            try {
                Constructor c = ChannelLabel.class.getConstructor(Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
                result = (ChannelLabel)c.newInstance(channelIconsVisible, textIsVisible, showDefaultValues, showCountry, showJoinedChannelInfo, showTimeLimitation, showSortNumber, paintBackground);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result == null) {
            result = UiCompat.createChannelLabel(channelIconsVisible, textIsVisible, showDefaultValues, showCountry, showJoinedChannelInfo, showTimeLimitation, showSortNumber);
        }
        return result;
    }

    public static void addKeyRotation(final JList list) {
        list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (list.getModel().getSize() > 1) {
                    if (e.getKeyCode() == 40 && e.getModifiersEx() == 0 && list.getSelectedIndex() == list.getModel().getSize() - 1) {
                        list.setSelectedIndex(0);
                        list.ensureIndexIsVisible(0);
                        e.consume();
                    } else if (e.getKeyCode() == 38 && e.getModifiersEx() == 0 && list.getSelectedIndex() == 0) {
                        list.setSelectedIndex(list.getModel().getSize() - 1);
                        list.ensureIndexIsVisible(list.getModel().getSize() - 1);
                        e.consume();
                    }
                }
            }
        });
    }

    public static Dialog.ModalityType getSuggestedModalityType() {
        Dialog.ModalityType result = Dialog.ModalityType.APPLICATION_MODAL;
        if (VersionCompat.isAtLeastTvBrowser4()) {
            result = Dialog.ModalityType.DOCUMENT_MODAL;
        }
        return result;
    }
}

