/* 
 * HTML forms
 */
#ifndef FORM_H
#define FORM_H

#include "Str.h"

enum {
    FORM_UNKNOWN = -1,
    FORM_INPUT_TEXT,
    FORM_INPUT_PASSWORD,
    FORM_INPUT_CHECKBOX,
    FORM_INPUT_RADIO,
    FORM_INPUT_SUBMIT,
    FORM_INPUT_RESET,
    FORM_INPUT_HIDDEN,
    FORM_INPUT_IMAGE,
    FORM_SELECT,
    FORM_TEXTAREA,
    FORM_INPUT_BUTTON,
    FORM_INPUT_FILE,
};

#define FORM_I_TEXT_DEFAULT_SIZE 20
#define FORM_I_SELECT_DEFAULT_SIZE 20
#define FORM_I_TEXTAREA_DEFAULT_WIDTH 40

enum {
    FORM_METHOD_GET,
    FORM_METHOD_POST,
    FORM_METHOD_INTERNAL,
    FORM_METHOD_HEAD,
};

#define FORM_ENCTYPE_URLENCODED 0
#define FORM_ENCTYPE_MULTIPART  1

#define FORM_INT_ENC(m, e) ((((m) & 0xF) << 4) | ((e) & 0xF))
#define FORM_INT_DEC(c, m, e) (((m) = ((c) >> 4) & 0xF) , (e) = (c) & 0xF)

#define MAX_TEXTAREA 10	/* max number of <textarea>..</textarea>
			   within one document */
#ifdef MENU_SELECT
#define MAX_SELECT 10		/* max number of <select>..</select>
				 * within one document */
#endif				/* MENU_SELECT */

typedef struct form_list {
    struct form_item_list *item;
    struct form_item_list *lastitem;
    int method;
    Str method_str;
    Str action;
    char *target;
    char *name;
#if LANG == MANY
    char *charset;
#else
    int charset;
#endif
    int enctype;
    struct form_list *next;
    int nitems;
    char *body;
    char *boundary;
    unsigned long length;
} FormList;

#ifdef MENU_SELECT
typedef struct form_select_option_item {
    Str value;
    Str label;
    int checked;
    struct form_select_option_item *next;
} FormSelectOptionItem;

typedef struct form_select_option {
    FormSelectOptionItem *first;
    FormSelectOptionItem *last;
} FormSelectOption;

void addSelectOption(FormSelectOption *fso, Str value, Str label, int chk);
void chooseSelectOption(struct form_item_list *fi, FormSelectOptionItem *item);
void updateSelectOption(struct form_item_list *fi, FormSelectOptionItem *item);
int formChooseOptionByMenu(struct form_item_list *fi, short x, short y);
#endif				/* MENU_SELECT */

typedef struct form_item_list {
    int type;
    Str name;
    Str value, init_value;
    Str *lines;
    int checked, init_checked;
    int accept;
    short size;
    short rows;
    int maxlength;
    int readonly;
#ifdef MENU_SELECT
    FormSelectOptionItem *select_option;
    Str label, init_label;
    int selected, init_selected;
#endif				/* MENU_SELECT */
    struct form_list *parent;
    struct form_item_list *next;
    int y, hseq;
    int fold;
} FormItemList;

#endif				/* not FORM_H */

/* Local Variables:    */
/* c-basic-offset: 4   */
/* tab-width: 8        */
/* End:                */
