#ifndef HISTORY_H
#define HISTORY_H

#include <btri.h>
#include "textlist.h"

typedef ListItem HistItem;

typedef GeneralList HistList;

typedef struct {
    HistList *list;
    HistItem *current;   
    btri_string_tab_t *tab;   
} Hist;

extern Hist *newHist();
extern Hist *copyHist(Hist *hist);
extern HistItem *unshiftHist(Hist *hist, char *ptr);
extern HistItem *pushHist(Hist *hist, char *ptr);
extern HistItem *pushHashHist(Hist *hist, char *ptr);
extern HistItem *getHashHist(Hist *hist, char *ptr);
extern char *lastHist(Hist *hist);
extern char *nextHist(Hist *hist);
extern char *prevHist(Hist *hist);

#endif /* HISTORY_H */
