/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import org.jquantlib.util.LazyObject;

public abstract class Instrument
extends LazyObject {
    protected double NPV = Double.NaN;
    protected double errorEstimate = 0.0;

    public abstract boolean isExpired();

    protected Instrument() {
    }

    public final double getNPV() {
        this.calculate();
        if (Double.isNaN(this.NPV)) {
            throw new ArithmeticException("NPV not provided");
        }
        return this.NPV;
    }

    public final double getErrorEstimate() {
        this.calculate();
        if (Double.isNaN(this.errorEstimate)) {
            throw new ArithmeticException("error estimate not provided");
        }
        return this.errorEstimate;
    }

    protected void setupExpired() {
        this.NPV = 0.0;
        this.errorEstimate = 0.0;
    }

    @Override
    protected void calculate() {
        if (this.isExpired()) {
            this.setupExpired();
            this.calculated = true;
        } else {
            super.calculate();
        }
    }
}

