/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.util.StringTokenizer;
import netscape.application.FastStringBuffer;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;

public class TextParagraphFormat
implements Cloneable,
Codable {
    int _leftIndent;
    int _leftMargin;
    int _rightMargin;
    int _lineSpacing;
    int[] _tabStops;
    int _justification;
    boolean _wrapsUnderFirstCharacter;
    static final String LEFTINDENT_KEY = "leftIndent";
    static final String LEFTMARGIN_KEY = "leftMargin";
    static final String RIGHTINDENT_KEY = "rightMargin";
    static final String LINESPACING_KEY = "lineSpacing";
    static final String TABSTOPS_KEY = "tabStops";
    static final String JUSTIFICATION_KEY = "justification";
    static final String WRAPS_UNDER_FIRST_CHARACTER_KEY = "wrapsUnderFirstCharacter";

    public Object clone() {
        try {
            Object object = super.clone();
            TextParagraphFormat textParagraphFormat = (TextParagraphFormat)object;
            if (this._tabStops != null) {
                textParagraphFormat.clearAllTabPositions();
                textParagraphFormat.setTabPositions(this._tabStops);
            }
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InconsistencyException(this + ": clone() not supported :" + cloneNotSupportedException);
        }
    }

    public void setLeftMargin(int n) {
        this._leftMargin = n;
    }

    public int leftMargin() {
        return this._leftMargin;
    }

    public void setLeftIndent(int n) {
        this._leftIndent = n;
    }

    public int leftIndent() {
        return this._leftIndent;
    }

    public void setRightMargin(int n) {
        this._rightMargin = n;
    }

    public int rightMargin() {
        return this._rightMargin;
    }

    public void setLineSpacing(int n) {
        this._lineSpacing = n;
    }

    public int lineSpacing() {
        return this._lineSpacing;
    }

    public void setJustification(int n) {
        if (this._justification < 0 || this._justification > 3) {
            return;
        }
        this._justification = n;
    }

    public int justification() {
        return this._justification;
    }

    public void setWrapsUnderFirstCharacter(boolean bl) {
        this._wrapsUnderFirstCharacter = bl;
    }

    public boolean wrapsUnderFirstCharacter() {
        if (this._justification == 0) {
            return this._wrapsUnderFirstCharacter;
        }
        return false;
    }

    public void clearAllTabPositions() {
        this._tabStops = null;
    }

    public void addTabPosition(int n) {
        if (n < 0) {
            return;
        }
        if (this._tabStops == null) {
            this._growTabArrayTo(20);
            this._tabStops[0] = n;
            return;
        }
        int n2 = this._tabStops.length;
        if (this._tabStops[n2 - 1] != -1) {
            this._growTabArrayTo(this._tabStops.length + 10);
            n2 = this._tabStops.length;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (this._tabStops[n3] > n) {
                return;
            }
            if (this._tabStops[n3] == -1) {
                this._tabStops[n3] = n;
                return;
            }
            ++n3;
        }
    }

    public void setTabPositions(int[] nArray) {
        if (nArray == null) {
            return;
        }
        this.clearAllTabPositions();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.addTabPosition(nArray[n2]);
            ++n2;
        }
    }

    public int[] tabPositions() {
        int n = 0;
        int n2 = 0;
        int n3 = this._tabStops.length;
        while (n2 < n3) {
            if (this._tabStops[n2] == -1) break;
            ++n;
            ++n2;
        }
        int[] nArray = new int[n];
        System.arraycopy(this._tabStops, 0, nArray, 0, n);
        return nArray;
    }

    public int positionForTab(int n) {
        if (this._tabStops == null || n < 0 || n >= this._tabStops.length) {
            return -1;
        }
        return this._tabStops[n];
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("netscape.application.TextParagraphFormat", 1);
        classInfo.addField(LEFTINDENT_KEY, (byte)8);
        classInfo.addField(LEFTMARGIN_KEY, (byte)8);
        classInfo.addField(RIGHTINDENT_KEY, (byte)8);
        classInfo.addField(LINESPACING_KEY, (byte)8);
        classInfo.addField(TABSTOPS_KEY, (byte)16);
        classInfo.addField(JUSTIFICATION_KEY, (byte)8);
        classInfo.addField(WRAPS_UNDER_FIRST_CHARACTER_KEY, (byte)0);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeInt(LEFTINDENT_KEY, this._leftIndent);
        encoder.encodeInt(LEFTMARGIN_KEY, this._leftMargin);
        encoder.encodeInt(RIGHTINDENT_KEY, this._rightMargin);
        encoder.encodeInt(LINESPACING_KEY, this._lineSpacing);
        if (this._tabStops != null) {
            FastStringBuffer fastStringBuffer = new FastStringBuffer();
            int n = this._tabStops.length;
            int n2 = 0;
            while (n2 < n) {
                fastStringBuffer.append(this._tabStops[n2] + ".");
                ++n2;
            }
            encoder.encodeString(TABSTOPS_KEY, fastStringBuffer.toString());
        } else {
            encoder.encodeString(TABSTOPS_KEY, null);
        }
        encoder.encodeInt(JUSTIFICATION_KEY, this._justification);
        encoder.encodeBoolean(WRAPS_UNDER_FIRST_CHARACTER_KEY, this._wrapsUnderFirstCharacter);
    }

    public void decode(Decoder decoder) throws CodingException {
        this._leftIndent = decoder.decodeInt(LEFTINDENT_KEY);
        this._leftMargin = decoder.decodeInt(LEFTMARGIN_KEY);
        this._rightMargin = decoder.decodeInt(RIGHTINDENT_KEY);
        this._lineSpacing = decoder.decodeInt(LINESPACING_KEY);
        String string = decoder.decodeString(TABSTOPS_KEY);
        if (string != null) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
                this.addTabPosition(Integer.parseInt(stringTokenizer.nextToken()));
            }
            catch (Exception exception) {
                throw new CodingException("Illegal tab stop data: \"" + string + "\"");
            }
        }
        this._justification = decoder.decodeInt(JUSTIFICATION_KEY);
        this._wrapsUnderFirstCharacter = decoder.decodeBoolean(WRAPS_UNDER_FIRST_CHARACTER_KEY);
    }

    public void finishDecoding() throws CodingException {
    }

    private void _growTabArrayTo(int n) {
        if (n < 1) {
            return;
        }
        if (this._tabStops != null && this._tabStops.length >= n) {
            return;
        }
        int[] nArray = this._tabStops;
        int n2 = n + 5;
        this._tabStops = new int[n2];
        while (n2-- > 0) {
            this._tabStops[n2] = -1;
        }
        if (nArray == null) {
            return;
        }
        int n3 = nArray.length;
        n2 = 0;
        while (n2 < n3) {
            this._tabStops[n2] = nArray[n2];
            ++n2;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("leftIndent = " + this._leftIndent + " " + "leftMargin = " + this._leftMargin + " " + "rightMargin = " + this._rightMargin + " " + "lineSpacing = " + this._lineSpacing + " " + "justification = " + this._justification);
        return stringBuffer.toString();
    }
}

