/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.equinox.internal.provisional.p2.core.FormatException;
import org.eclipse.equinox.internal.provisional.p2.core.Messages;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionFormat;
import org.eclipse.equinox.internal.provisional.p2.core.VersionVector;
import org.eclipse.osgi.util.NLS;

abstract class VersionParser {
    static final String RAW_PREFIX = "raw:";

    static void removeRedundantTrail(List segments, Comparable padValue) {
        Comparable redundantTrail = padValue == null ? VersionVector.MIN_VALUE : padValue;
        int idx = segments.size();
        while (--idx >= 0 && segments.get(idx).equals(redundantTrail)) {
            segments.remove(idx);
        }
    }

    private VersionParser() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean parseInto(String version, int start, int maxPos, Version receiver) throws IllegalArgumentException {
        int pos = VersionParser.skipWhite(version, start);
        if (pos == (maxPos = VersionParser.skipTrailingWhite(version, start, maxPos))) {
            return false;
        }
        Comparable[] padReturn = new Comparable[1];
        Comparable[] vector = null;
        Comparable pad = null;
        VersionFormat fmt = null;
        char c = version.charAt(pos);
        if (VersionParser.isDigit(c)) {
            fmt = VersionFormat.OSGI_FORMAT;
            vector = fmt.parse(version, pos, maxPos, padReturn);
            receiver.init(vector, padReturn[0], fmt, version);
            return true;
        }
        if (!VersionParser.isLetter(c)) {
            throw new IllegalArgumentException();
        }
        if (version.startsWith(RAW_PREFIX, pos)) {
            VersionFormat rawFmt = VersionFormat.RAW_FORMAT;
            int end = maxPos;
            int idx = pos += 4;
            block7: while (idx < maxPos) {
                c = version.charAt(idx);
                block1 : switch (c) {
                    case '/': {
                        end = idx;
                        break block7;
                    }
                    case '\\': {
                        ++idx;
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        ++idx;
                        while (idx < maxPos) {
                            char e = version.charAt(idx);
                            if (e == c) break block1;
                            if (e == '\\') {
                                ++idx;
                            }
                            ++idx;
                        }
                        break block1;
                    }
                }
                ++idx;
            }
            vector = rawFmt.parse(version, pos, end, padReturn);
            pad = padReturn[0];
            pos = end;
            if (pos == maxPos) {
                receiver.init(vector, pad, null, null);
                return true;
            }
            if (version.charAt(pos) != '/') {
                throw new IllegalArgumentException(NLS.bind((String)Messages.expected_slash_after_raw_vector_0, (Object)version.substring(start, maxPos)));
            }
            if (++pos == maxPos) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.expected_orignal_after_slash_0, (Object)version.substring(start, maxPos)));
            }
        }
        if (version.startsWith("format(", pos)) {
            pos += 7;
            try {
                int end = VersionParser.findEndOfFormat(version, pos, maxPos);
                fmt = VersionFormat.compile(version, pos, end);
                pos = end + 1;
            }
            catch (FormatException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            if (pos == maxPos) {
                if (vector == null) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages.only_format_specified_0, (Object)version.substring(start, maxPos)));
                }
                receiver.init(vector, pad, fmt, null);
                return true;
            }
        }
        if (fmt == null && vector == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.neither_raw_vector_nor_format_specified_0, (Object)version.substring(start, maxPos)));
        }
        if (version.charAt(pos) != ':') {
            throw new IllegalArgumentException(NLS.bind((String)Messages.colon_expected_before_original_version_0, (Object)version.substring(start, maxPos)));
        }
        if (++pos == maxPos) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.expected_orignal_after_colon_0, (Object)version.substring(start, maxPos)));
        }
        if (vector == null) {
            vector = fmt.parse(version, pos, maxPos, padReturn);
            pad = padReturn[0];
        }
        receiver.init(vector, pad, fmt, version.substring(pos));
        return true;
    }

    static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    static boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    static boolean isLetterOrDigit(char c) {
        return VersionParser.isDigit(c) || VersionParser.isLetter(c);
    }

    /*
     * Enabled aggressive block sorting
     */
    static int findEndOfFormat(String string, int pos, int maxPos) {
        int end = -1;
        int depth = 1;
        int idx = pos;
        block6: while (idx < maxPos) {
            char c = string.charAt(idx);
            block0 : switch (c) {
                case ')': {
                    if (--depth != 0) break;
                    end = idx;
                    break block6;
                }
                case '(': {
                    ++depth;
                    break;
                }
                case '\\': {
                    ++idx;
                    break;
                }
                case '\"': 
                case '\'': {
                    ++idx;
                    while (idx < maxPos) {
                        char e = string.charAt(idx);
                        if (e == c) break block0;
                        if (e == '\\') {
                            ++idx;
                        }
                        ++idx;
                    }
                    break block0;
                }
            }
            ++idx;
        }
        if (depth != 0) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.unbalanced_format_parenthesis, (Object)string.substring(pos - 1, maxPos)));
        }
        return end;
    }

    static Comparable parseRawElement(String value, int[] position, int maxPos) {
        Object v;
        int current = position[0];
        if (current >= maxPos) {
            return null;
        }
        boolean negate = false;
        char c = value.charAt(current);
        switch (c) {
            case '\"': 
            case '\'': {
                StringBuffer sb = new StringBuffer();
                do {
                    char q = c;
                    if (++current == maxPos) {
                        return null;
                    }
                    c = value.charAt(current);
                    while (c != q) {
                        if (c < ' ') {
                            return null;
                        }
                        sb.append(c);
                        if (++current == maxPos) {
                            return null;
                        }
                        c = value.charAt(current);
                    }
                } while (++current != maxPos && ((c = value.charAt(current)) == '\'' || c == '\"'));
                v = sb.toString();
                break;
            }
            case '<': {
                if (++current == maxPos) {
                    return null;
                }
                position[0] = current;
                v = VersionParser.parseRawVector(value, position, maxPos);
                if (v == null) {
                    return null;
                }
                current = position[0];
                break;
            }
            case 'm': {
                v = VersionVector.MAXS_VALUE;
                break;
            }
            case 'M': {
                v = VersionVector.MAX_VALUE;
                ++current;
                break;
            }
            case '-': {
                if (++current >= maxPos) {
                    return null;
                }
                c = value.charAt(current);
                if (c == 'M') {
                    ++current;
                    v = VersionVector.MIN_VALUE;
                    break;
                }
                negate = true;
            }
            default: {
                if (VersionParser.isDigit(c)) {
                    int start = current++;
                    while (current < maxPos && VersionParser.isDigit(value.charAt(current))) {
                        ++current;
                    }
                    int val = Integer.parseInt(value.substring(start, current));
                    if (negate) {
                        val = -val;
                    }
                    v = Version.valueOf(val);
                    break;
                }
                return null;
            }
        }
        position[0] = ++current;
        return v;
    }

    private static Comparable parseRawVector(String value, int[] position, int maxPos) {
        Comparable pad;
        ArrayList<Comparable> rawList;
        block11: {
            boolean padMarkerSeen;
            int pos = position[0];
            if (pos >= maxPos) {
                return null;
            }
            char c = value.charAt(pos);
            if (c == '>') {
                return null;
            }
            rawList = new ArrayList<Comparable>();
            boolean bl = padMarkerSeen = c == 'p';
            if (padMarkerSeen) {
                if (++pos >= maxPos) {
                    return null;
                }
                position[0] = pos;
            }
            pad = null;
            while (true) {
                Comparable elem;
                if ((elem = VersionParser.parseRawElement(value, position, maxPos)) == null) {
                    return null;
                }
                if (padMarkerSeen) {
                    pad = elem;
                } else {
                    rawList.add(elem);
                }
                pos = position[0];
                if (pos >= maxPos) {
                    return null;
                }
                c = value.charAt(pos);
                position[0] = ++pos;
                if (c == '>') break block11;
                if (padMarkerSeen || pos >= maxPos) {
                    return null;
                }
                if (c == 'p') {
                    padMarkerSeen = true;
                    continue;
                }
                if (c != '.') break;
            }
            return null;
        }
        VersionParser.removeRedundantTrail(rawList, pad);
        return new VersionVector(rawList.toArray(new Comparable[rawList.size()]), pad);
    }

    static int skipWhite(String string, int pos) {
        int top = string.length();
        while (pos < top && string.charAt(pos) <= ' ') {
            ++pos;
        }
        return pos;
    }

    static int skipTrailingWhite(String string, int start, int end) {
        while (end > start && string.charAt(end - 1) <= ' ') {
            --end;
        }
        return end;
    }
}

