/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.impl.CaseInsensitiveDictionary;
import org.apache.felix.cm.impl.ConfigurationBase;
import org.apache.felix.cm.impl.ConfigurationManager;
import org.apache.felix.cm.impl.Factory;
import org.apache.felix.cm.impl.helper.TargetedPID;
import org.osgi.service.cm.Configuration;

public class ConfigurationImpl
extends ConfigurationBase {
    private static final String CONFIGURATION_NEW = "_felix_.cm.newConfiguration";
    private final TargetedPID factoryPID;
    private volatile String staticBundleLocation;
    private volatile String dynamicBundleLocation;
    private volatile CaseInsensitiveDictionary properties;
    private volatile boolean isDeleted;
    private volatile long revision;

    ConfigurationImpl(ConfigurationManager configurationManager, PersistenceManager persistenceManager, Dictionary properties) {
        super(configurationManager, persistenceManager, (String)properties.remove("service.pid"));
        String factoryPid = (String)properties.remove("service.factoryPid");
        this.factoryPID = factoryPid == null ? null : new TargetedPID(factoryPid);
        this.isDeleted = false;
        this.staticBundleLocation = (String)properties.remove("service.bundleLocation");
        this.dynamicBundleLocation = configurationManager.getDynamicBundleLocation(this.getBaseId().toString());
        this.configureFromPersistence(properties);
    }

    ConfigurationImpl(ConfigurationManager configurationManager, PersistenceManager persistenceManager, String pid, String factoryPid, String bundleLocation) throws IOException {
        super(configurationManager, persistenceManager, pid);
        this.factoryPID = factoryPid == null ? null : new TargetedPID(factoryPid);
        this.isDeleted = false;
        this.staticBundleLocation = bundleLocation;
        this.dynamicBundleLocation = configurationManager.getDynamicBundleLocation(this.getBaseId().toString());
        this.properties = null;
        this.revision = 1L;
        if (factoryPid == null) {
            this.storeNewConfiguration();
        }
    }

    public void delete() throws IOException {
        this.isDeleted = true;
        this.getPersistenceManager().delete(this.getPidString());
        this.getConfigurationManager().setDynamicBundleLocation(this.getPidString(), null);
        this.getConfigurationManager().deleted(this);
    }

    public String getPidString() {
        return this.getBaseId().toString();
    }

    public TargetedPID getPid() {
        return this.getBaseId();
    }

    public String getFactoryPidString() {
        return this.factoryPID == null ? null : this.factoryPID.toString();
    }

    public TargetedPID getFactoryPid() {
        return this.factoryPID;
    }

    String getBundleLocation() {
        if (this.staticBundleLocation != null) {
            return this.staticBundleLocation;
        }
        return this.dynamicBundleLocation;
    }

    String getDynamicBundleLocation() {
        return this.dynamicBundleLocation;
    }

    String getStaticBundleLocation() {
        return this.staticBundleLocation;
    }

    void setStaticBundleLocation(String bundleLocation) {
        String oldBundleLocation = this.getBundleLocation();
        this.staticBundleLocation = bundleLocation;
        this.storeSilently();
        this.setDynamicBundleLocation(null, false);
        this.getConfigurationManager().locationChanged(this, oldBundleLocation);
    }

    void setDynamicBundleLocation(String bundleLocation, boolean dispatchConfiguration) {
        String oldBundleLocation = this.getBundleLocation();
        this.dynamicBundleLocation = bundleLocation;
        this.getConfigurationManager().setDynamicBundleLocation(this.getPidString(), bundleLocation);
        if (dispatchConfiguration) {
            this.getConfigurationManager().locationChanged(this, oldBundleLocation);
        }
    }

    void tryBindLocation(String bundleLocation) {
        if (this.getBundleLocation() == null) {
            this.getConfigurationManager().log(4, "Dynamically binding config {0} to {1}", new Object[]{this.getPidString(), bundleLocation});
            this.setDynamicBundleLocation(bundleLocation, true);
        }
    }

    public Dictionary getProperties(boolean deepCopy) {
        if (this.properties == null) {
            return null;
        }
        CaseInsensitiveDictionary props = new CaseInsensitiveDictionary(this.properties, deepCopy);
        this.setAutoProperties(props, false);
        return props;
    }

    public void update() throws IOException {
        PersistenceManager localPersistenceManager = this.getPersistenceManager();
        if (localPersistenceManager != null) {
            if (localPersistenceManager.exists(this.getPidString())) {
                Dictionary properties = localPersistenceManager.load(this.getPidString());
                String servicePid = (String)properties.get("service.pid");
                if (servicePid != null && !this.getPidString().equals(servicePid)) {
                    throw new IOException("PID of configuration file does match requested PID; expected " + this.getPidString() + ", got " + servicePid);
                }
                this.configureFromPersistence(properties);
            }
            this.getConfigurationManager().updated(this, false);
        }
    }

    public void update(Dictionary properties) throws IOException {
        PersistenceManager localPersistenceManager = this.getPersistenceManager();
        if (localPersistenceManager != null) {
            CaseInsensitiveDictionary newProperties = new CaseInsensitiveDictionary(properties);
            this.getConfigurationManager().log(4, "Updating config {0} with {1}", new Object[]{this.getPidString(), newProperties});
            this.setAutoProperties(newProperties, true);
            localPersistenceManager.store(this.getPidString(), newProperties);
            this.configure(newProperties);
            this.updateFactory();
            this.getConfigurationManager().updated(this, true);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Configuration) {
            return this.getPidString().equals(((Configuration)obj).getPid());
        }
        return false;
    }

    public int hashCode() {
        return this.getPidString().hashCode();
    }

    public String toString() {
        return "Configuration PID=" + this.getPidString() + ", factoryPID=" + this.factoryPID + ", bundleLocation=" + this.getBundleLocation();
    }

    void ensureFactoryConfigPersisted() throws IOException {
        if (this.factoryPID != null && this.isNew() && !this.getPersistenceManager().exists(this.getPidString())) {
            this.storeNewConfiguration();
        }
    }

    private void storeNewConfiguration() throws IOException {
        Hashtable<String, Boolean> props = new Hashtable<String, Boolean>();
        this.setAutoProperties(props, true);
        ((Dictionary)props).put(CONFIGURATION_NEW, Boolean.TRUE);
        this.getPersistenceManager().store(this.getPidString(), props);
    }

    private void updateFactory() throws IOException {
        Factory factory;
        String factoryPid = this.getFactoryPidString();
        if (factoryPid != null && (factory = this.getConfigurationManager().getOrCreateFactory(factoryPid)).addPID(this.getPidString())) {
            try {
                factory.store();
            }
            catch (IOException ioe) {
                this.getConfigurationManager().log(1, "Failure storing factory {0} with new configuration {1}", new Object[]{factoryPid, this.getPidString(), ioe});
            }
        }
    }

    void store() throws IOException {
        Hashtable props = this.getProperties(false);
        if (props == null) {
            props = new Hashtable();
            this.setAutoProperties(props, true);
        } else {
            ConfigurationImpl.replaceProperty(props, "service.bundleLocation", this.getStaticBundleLocation());
        }
        this.getPersistenceManager().store(this.getPidString(), props);
    }

    public long getRevision() {
        return this.revision;
    }

    boolean isNew() {
        return this.properties == null;
    }

    boolean isDeleted() {
        return this.isDeleted;
    }

    private void configureFromPersistence(Dictionary properties) {
        if (properties.get(CONFIGURATION_NEW) == null) {
            this.configure(properties);
        } else {
            this.configure(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure(Dictionary properties) {
        CaseInsensitiveDictionary newProperties;
        if (properties == null) {
            newProperties = null;
        } else {
            ConfigurationImpl.clearAutoProperties(properties);
            newProperties = properties instanceof CaseInsensitiveDictionary ? (CaseInsensitiveDictionary)properties : new CaseInsensitiveDictionary(properties);
        }
        ConfigurationImpl configurationImpl = this;
        synchronized (configurationImpl) {
            this.properties = newProperties;
            ++this.revision;
        }
    }

    void setAutoProperties(Dictionary properties, boolean withBundleLocation) {
        ConfigurationImpl.replaceProperty(properties, "service.pid", this.getPidString());
        ConfigurationImpl.replaceProperty(properties, "service.factoryPid", this.getFactoryPidString());
        if (withBundleLocation) {
            ConfigurationImpl.replaceProperty(properties, "service.bundleLocation", this.getStaticBundleLocation());
        } else {
            properties.remove("service.bundleLocation");
        }
    }

    static void setAutoProperties(Dictionary properties, String pid, String factoryPid) {
        ConfigurationImpl.replaceProperty(properties, "service.pid", pid);
        ConfigurationImpl.replaceProperty(properties, "service.factoryPid", factoryPid);
        properties.remove("service.bundleLocation");
    }

    static void clearAutoProperties(Dictionary properties) {
        properties.remove("service.pid");
        properties.remove("service.factoryPid");
        properties.remove("service.bundleLocation");
    }
}

