/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.interpolations;

import java.util.Arrays;
import org.jquantlib.math.interpolations.AbstractInterpolation;
import org.jquantlib.math.interpolations.Interpolation;
import org.jquantlib.math.interpolations.Interpolator;

public class LinearInterpolation
extends AbstractInterpolation {
    private double[] vp;
    private double[] vs;

    private LinearInterpolation() {
    }

    public static Interpolator getInterpolator() {
        LinearInterpolation linearInterpolation = new LinearInterpolation();
        return new LinearInterpolationImpl(linearInterpolation);
    }

    @Override
    protected double primitiveImpl(double x) {
        int i = this.locate(x);
        double dx = x - this.vx[i];
        return this.vp[i - 1] + dx * (this.vy[i - 1] + 0.5 * dx * this.vs[i - 1]);
    }

    @Override
    protected double derivativeImpl(double x) {
        int i = this.locate(x);
        return this.vs[i];
    }

    @Override
    protected double secondDerivativeImpl(double x) {
        return 0.0;
    }

    @Override
    @Deprecated
    public void update() {
        this.reload();
    }

    @Override
    public void reload() {
        super.reload();
        this.vp = new double[this.vx.length];
        this.vs = new double[this.vx.length];
        this.vp[0] = 0.0;
        for (int i = 1; i < this.vx.length; ++i) {
            double dx = this.vx[i] - this.vx[i - 1];
            this.vs[i - 1] = (this.vy[i] - this.vy[i - 1]) / dx;
            this.vp[i] = this.vp[i - 1] + dx * (this.vy[i - 1] + 0.5 * dx * this.vs[i - 1]);
        }
    }

    @Override
    protected double evaluateImpl(double x) {
        int i = this.locate(x);
        return this.vy[i] + (x - this.vx[i]) * this.vs[i];
    }

    private static class LinearInterpolationImpl
    implements Interpolator {
        private LinearInterpolation delegate;

        public LinearInterpolationImpl(LinearInterpolation delegate) {
            this.delegate = delegate;
        }

        @Override
        public final Interpolation interpolate(double[] x, double[] y) {
            return this.interpolate(x.length, x, y);
        }

        @Override
        public final Interpolation interpolate(int size, double[] x, double[] y) {
            this.delegate.vx = Arrays.copyOfRange(x, 0, size);
            this.delegate.vy = Arrays.copyOfRange(y, 0, size);
            this.delegate.reload();
            return this.delegate;
        }

        @Override
        public final boolean isGlobal() {
            return false;
        }
    }
}

