/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.indexes;

import java.util.Currency;
import org.jquantlib.daycounters.Actual360;
import org.jquantlib.daycounters.Actual365Fixed;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.time.calendars.Target;

public class Euribor
extends IborIndex {
    protected Euribor(String name, Period tenor, int settlementDays, DayCounter dayCounter, Handle<YieldTermStructure> h) {
        super(name, tenor, settlementDays, Target.getCalendar(), Currency.getInstance("EUR"), Euribor.euriborConvention(tenor), Euribor.euriborEOM(tenor), dayCounter, h);
    }

    public Euribor(Period tenor, Handle<YieldTermStructure> h) {
        this("Euribor", tenor, 2, Actual360.getDayCounter(), h);
        if (tenor.units() == TimeUnit.DAYS) {
            throw new IllegalArgumentException("for daily tenors (" + tenor + ") dedicated DailyTenor constructor must be used");
        }
    }

    protected static BusinessDayConvention euriborConvention(Period p) {
        switch (p.units()) {
            case DAYS: 
            case WEEKS: {
                return BusinessDayConvention.FOLLOWING;
            }
            case MONTHS: 
            case YEARS: {
                return BusinessDayConvention.MODIFIED_FOLLOWING;
            }
        }
        throw new IllegalArgumentException("invalid time units");
    }

    protected static boolean euriborEOM(Period p) {
        switch (p.units()) {
            case DAYS: 
            case WEEKS: {
                return false;
            }
            case MONTHS: 
            case YEARS: {
                return true;
            }
        }
        throw new IllegalArgumentException("invalid time units");
    }

    public static class DailyTenorEuribor365
    extends IborIndex {
        public DailyTenorEuribor365(int settlementDays, Handle<YieldTermStructure> h) {
            super("Euribor", new Period(1, TimeUnit.DAYS), settlementDays, Target.getCalendar(), Currency.getInstance("EUR"), Euribor.euriborConvention(new Period(1, TimeUnit.DAYS)), Euribor.euriborEOM(new Period(1, TimeUnit.DAYS)), Actual365Fixed.getDayCounter(), h);
        }
    }

    public static class DailyTenorEuribor
    extends IborIndex {
        public DailyTenorEuribor(int settlementDays, Handle<YieldTermStructure> h) {
            super("Euribor", new Period(1, TimeUnit.DAYS), settlementDays, Target.getCalendar(), Currency.getInstance("EUR"), Euribor.euriborConvention(new Period(1, TimeUnit.DAYS)), Euribor.euriborEOM(new Period(1, TimeUnit.DAYS)), Actual360.getDayCounter(), h);
        }
    }

    public static class Euribor365
    extends Euribor {
        public Euribor365(Period tenor, Handle<YieldTermStructure> h) {
            super("Euribor365", tenor, 2, Actual365Fixed.getDayCounter(), h);
            if (tenor.units() == TimeUnit.DAYS) {
                throw new IllegalArgumentException("for daily tenors (" + tenor + ") dedicated DailyTenor constructor must be used");
            }
        }
    }
}

