/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulation.annotations;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.manipulation.annotations.CustomAnnotationVisitor;
import org.apache.felix.ipojo.manipulation.annotations.FieldCollector;
import org.apache.felix.ipojo.manipulation.annotations.MethodCollector;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;

public class MetadataCollector
extends EmptyVisitor
implements Opcodes {
    private String m_className;
    private Element m_elem = new Element("component", "");
    private boolean m_containsAnnotation = false;
    private Map m_ids = new HashMap();
    private Map m_elements = new HashMap();

    public Element getElem() {
        return this.m_elem;
    }

    public boolean isAnnotated() {
        return this.m_containsAnnotation;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.m_ids = new HashMap();
        this.m_elements = new HashMap();
        this.m_className = name;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (desc.equals("Lorg/apache/felix/ipojo/annotations/Component;")) {
            this.m_containsAnnotation = true;
            this.m_elem.addAttribute(new Attribute("className", this.m_className.replace('/', '.')));
            return new ComponentVisitor();
        }
        if (desc.equals("Lorg/apache/felix/ipojo/annotations/Provides;")) {
            return new ProvidesVisitor();
        }
        if (CustomAnnotationVisitor.isCustomAnnotation(desc)) {
            Element elem = CustomAnnotationVisitor.buildElement(desc);
            return new CustomAnnotationVisitor(elem, this, true);
        }
        return null;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return new FieldCollector(name, this);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return new MethodCollector(name, this);
    }

    public void visitEnd() {
        Set elems = this.getElements().keySet();
        Iterator it = elems.iterator();
        while (it.hasNext()) {
            Element current = (Element)it.next();
            String reference = (String)this.getElements().get(current);
            if (reference == null) {
                this.m_elem.addElement(current);
                continue;
            }
            Element ref = (Element)this.getIds().get(reference);
            if (ref == null) {
                System.err.println("The element " + reference + " is not declared - skip the element " + current.toXMLString());
                continue;
            }
            ref.addElement(current);
        }
    }

    protected Map getIds() {
        return this.m_ids;
    }

    protected Map getElements() {
        return this.m_elements;
    }

    private class ComponentVisitor
    extends EmptyVisitor
    implements AnnotationVisitor {
        private String m_factory;
        private String m_immediate;
        private String m_name;
        private String m_architecture;
        private String m_propagation;
        private String m_managedservice;
        private Element m_props;

        private ComponentVisitor() {
        }

        public void visit(String arg0, Object arg1) {
            if (arg0.equals("factory")) {
                this.m_factory = arg1.toString();
                return;
            }
            if (arg0.equals("name")) {
                this.m_name = arg1.toString();
                return;
            }
            if (arg0.equals("immediate")) {
                this.m_immediate = arg1.toString();
                return;
            }
            if (arg0.equals("architecture")) {
                this.m_architecture = arg1.toString();
                return;
            }
            if (arg0.equals("propagation")) {
                this.m_propagation = arg1.toString();
                return;
            }
            if (arg0.equals("managedservice")) {
                this.m_managedservice = arg1.toString();
                return;
            }
        }

        public void visitEnd() {
            if (this.m_name == null) {
                this.m_name = MetadataCollector.this.m_className.replace('/', '.');
            }
            MetadataCollector.this.m_elem.addAttribute(new Attribute("name", this.m_name));
            if (this.m_factory == null) {
                MetadataCollector.this.m_elem.addAttribute(new Attribute("factory", "false"));
            } else {
                MetadataCollector.this.m_elem.addAttribute(new Attribute("factory", this.m_factory));
            }
            if (this.m_architecture != null) {
                MetadataCollector.this.m_elem.addAttribute(new Attribute("architecture", this.m_architecture));
            }
            if (this.m_immediate != null) {
                MetadataCollector.this.m_elem.addAttribute(new Attribute("immediate", this.m_immediate));
            }
            if (this.m_propagation != null) {
                if (this.m_props == null) {
                    this.m_props = new Element("properties", "");
                    MetadataCollector.this.getElements().put(this.m_props, null);
                    MetadataCollector.this.getIds().put("properties", this.m_props);
                }
                this.m_props.addAttribute(new Attribute("propagation", this.m_propagation));
            }
            if (this.m_managedservice != null) {
                if (this.m_props == null) {
                    this.m_props = new Element("properties", "");
                    MetadataCollector.this.getElements().put(this.m_props, null);
                    MetadataCollector.this.getIds().put("properties", this.m_props);
                }
                this.m_props.addAttribute(new Attribute("pid", this.m_managedservice));
            }
        }
    }

    private class ProvidesVisitor
    extends EmptyVisitor
    implements AnnotationVisitor {
        Element m_prov = new Element("provides", "");

        private ProvidesVisitor() {
        }

        public void visit(String arg0, Object arg1) {
            if (arg0.equals("factory")) {
                this.m_prov.addAttribute(new Attribute("factory", arg1.toString()));
            }
        }

        public AnnotationVisitor visitArray(String arg0) {
            if (arg0.equals("specifications")) {
                return new InterfaceArrayVisitor();
            }
            return null;
        }

        public void visitEnd() {
            MetadataCollector.this.getIds().put("provides", this.m_prov);
            MetadataCollector.this.getElements().put(this.m_prov, null);
        }

        private class InterfaceArrayVisitor
        extends EmptyVisitor {
            private String m_itfs;

            private InterfaceArrayVisitor() {
            }

            public void visit(String arg0, Object arg1) {
                this.m_itfs = this.m_itfs == null ? "{" + ((Type)arg1).getClassName() : this.m_itfs + "," + ((Type)arg1).getClassName();
            }

            public void visitEnd() {
                ProvidesVisitor.this.m_prov.addAttribute(new Attribute("interface", this.m_itfs + "}"));
            }
        }
    }
}

