/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.arguments;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.instruments.AverageType;
import org.jquantlib.pricingengines.arguments.OneAssetOptionArguments;
import org.jquantlib.util.Date;

public class DiscreteAveragingAsianOptionArguments
extends OneAssetOptionArguments {
    private static final double NULLREAL = Double.MAX_VALUE;
    private static final int NULLSIZE = Integer.MAX_VALUE;
    public AverageType averageType = AverageType.Arithmetic;
    public double runningAccumulator = Double.MAX_VALUE;
    public int pastFixings = Integer.MAX_VALUE;
    public List<Date> fixingDates = new ArrayList<Date>();

    @Override
    public void validate() {
        super.validate();
        if (this.averageType == null) {
            throw new IllegalArgumentException("unspecified average type");
        }
        if (this.pastFixings == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("null past-fixing number");
        }
        if (this.runningAccumulator == Double.MAX_VALUE) {
            throw new IllegalArgumentException("null running product");
        }
        switch (this.averageType) {
            case Arithmetic: {
                if (!(this.runningAccumulator >= 0.0)) break;
                throw new IllegalArgumentException("non negative running sum required: " + this.runningAccumulator + " not allowed");
            }
            case Geometric: {
                if (this.runningAccumulator > 0.0) break;
                throw new IllegalArgumentException("positive running product required: " + this.runningAccumulator + " not allowed");
            }
            default: {
                throw new IllegalArgumentException("invalid average type");
            }
        }
    }
}

