/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.assets;

import java.util.List;
import org.jquantlib.assets.DiscretizedAsset;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.math.Array;

public class DiscretizedOption
extends DiscretizedAsset {
    protected Exercise.Type exerciseType;
    protected List<Double> exerciseTimes;
    protected DiscretizedAsset underlying;

    public DiscretizedOption(DiscretizedAsset underlying, Exercise.Type exerciseType, List<Double> exerciseTimes) {
        this.underlying = underlying;
        this.exerciseType = exerciseType;
        this.exerciseTimes = exerciseTimes;
    }

    @Override
    public void reset(int size) {
        if (this.method() != this.underlying.method()) {
            throw new IllegalStateException("option and underlying were initialized on different methods");
        }
        this.values = new Array(size, 0.0);
        this.adjustValues();
    }

    @Override
    public List<Double> mandatoryTimes() {
        List<Double> times = this.underlying.mandatoryTimes();
        return times;
    }

    protected void applyExerciseCondition() {
        for (int i = 0; i < this.values.size(); ++i) {
            this.values.set(i, Math.max(this.underlying.values().get(i), this.values.get(i)));
        }
    }

    @Override
    public void postAdjustValuesImpl() {
        this.underlying.partialRollback(this.time());
        this.underlying.preAdjustValues();
        switch (this.exerciseType) {
            case AMERICAN: {
                if (!(this.time >= this.exerciseTimes.get(0)) || !(this.time <= this.exerciseTimes.get(1))) break;
                this.applyExerciseCondition();
                break;
            }
            case BERMUDAN: 
            case EUROPEAN: {
                for (int i = 0; i < this.exerciseTimes.size(); ++i) {
                    double t = this.exerciseTimes.get(i);
                    if (!(t >= 0.0) || !this.isOnTime(t)) continue;
                    this.applyExerciseCondition();
                }
                break;
            }
            default: {
                throw new IllegalStateException("invalid exercise type");
            }
        }
        this.underlying.postAdjustValues();
    }
}

