/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.examples;

import cern.colt.Timer;
import org.jquantlib.examples.utils.ReplicationError;
import org.jquantlib.instruments.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscreteHedging {
    private static final Logger logger = LoggerFactory.getLogger(DiscreteHedging.class);

    public static void main(String[] args) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        try {
            Timer timer = new Timer();
            timer.start();
            Double maturity = new Double(0.08333333333333333);
            Double strike = new Double(100.0);
            Double underlying = new Double(100.0);
            Double volatility = new Double(0.2);
            Double riskFreeRate = new Double(0.05);
            Option.Type Call = Option.Type.CALL;
            ReplicationError rp = new ReplicationError(Call, maturity, strike, underlying, volatility, riskFreeRate);
            int scenarios = 50000;
            int hedgesNum = 21;
            rp.compute(hedgesNum, scenarios);
            hedgesNum = 84;
            rp.compute(hedgesNum, scenarios);
            timer.stop();
            System.out.println("Run completed in " + timer.elapsedTime());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

