/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.equinox.ds.model.ComponentDescription;
import org.eclipse.equinox.ds.model.PropertyValueDescription;
import org.eclipse.equinox.ds.parser.ComponentElement;
import org.eclipse.equinox.ds.parser.ElementHandler;
import org.eclipse.equinox.ds.parser.ParserHandler;
import org.xml.sax.Attributes;

class PropertyElement
extends ElementHandler {
    private ComponentElement parent;
    private PropertyValueDescription property;
    private List values;

    PropertyElement(ParserHandler root, ComponentElement parent, Attributes attributes) {
        this.root = root;
        this.parent = parent;
        this.property = new PropertyValueDescription();
        this.values = new ArrayList();
        this.processAttributes(attributes);
        if (this.property.getName() == null) {
            root.logError("property name not specified");
        }
    }

    protected void handleAttribute(String name, String value) {
        if (name.equals("name")) {
            this.property.setName(value);
            return;
        }
        if (name.equals("value")) {
            this.property.setValue(value);
            return;
        }
        if (name.equals("type")) {
            this.property.setType(value);
            return;
        }
        this.root.logError("unrecognized properties element attribute: " + name);
    }

    public void characters(char[] ch, int start, int length) {
        int end = start + length;
        int cursor = start;
        while (cursor < end) {
            if (ch[cursor] == '\n') {
                this.charLine(ch, start, cursor - start);
                start = cursor;
            }
            ++cursor;
        }
        this.charLine(ch, start, cursor - start);
    }

    private void charLine(char[] ch, int start, int length) {
        String line;
        if (length > 0 && (line = new String(ch, start, length).trim()).length() > 0) {
            this.values.add(line);
        }
    }

    public void endElement(String uri, String localName, String qName) {
        int size = this.values.size();
        if (this.property.getValue() != null) {
            String type;
            if (size > 0) {
                this.root.logError("If the value attribute is specified, the body of the property element is ignored. key = " + this.property.getName() + " value = " + this.property.getValue());
            }
            if ((type = this.property.getType()) != null && !type.equals("String")) {
                if (type.equals("Long")) {
                    this.property.setValue(Long.valueOf((String)this.property.getValue(), 10));
                } else if (type.equals("Double")) {
                    this.property.setValue(Double.valueOf((String)this.property.getValue()));
                } else if (type.equals("Float")) {
                    this.property.setValue(Float.valueOf((String)this.property.getValue()));
                } else if (type.equals("Integer")) {
                    this.property.setValue(Integer.valueOf((String)this.property.getValue()));
                } else if (type.equals("Byte")) {
                    this.property.setValue(Byte.valueOf((String)this.property.getValue(), 10));
                } else if (type.equals("Char")) {
                    this.property.setValue(new Character(((String)this.property.getValue()).charAt(0)));
                } else if (type.equals("Boolean")) {
                    this.property.setValue(Boolean.valueOf((String)this.property.getValue()));
                } else if (type.equals("Short")) {
                    this.property.setValue(Short.valueOf((String)this.property.getValue(), 10));
                }
            }
        } else if (size > 0) {
            Object[] result;
            if (this.property.getType().equals("String")) {
                result = new String[size];
                this.values.toArray(result);
                this.property.setValue(result);
            } else if (this.property.getType().equals("Integer")) {
                result = new int[size];
                if (this.values != null) {
                    Iterator it = this.values.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        Integer value = new Integer((String)it.next());
                        result[i++] = (String)((Object)value);
                    }
                    this.property.setValue(result);
                }
            } else if (this.property.getType().equals("Long")) {
                result = new long[size];
                if (this.values != null) {
                    Iterator it = this.values.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        Long value = new Long((String)it.next());
                        result[i++] = (String)((Object)value);
                    }
                    this.property.setValue(result);
                }
            } else if (this.property.getType().equals("Double")) {
                result = new double[size];
                if (this.values != null) {
                    Iterator it = this.values.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        Double value = new Double((String)it.next());
                        result[i++] = (String)((Object)value);
                    }
                    this.property.setValue(result);
                }
            } else if (this.property.getType().equals("Float")) {
                result = new float[size];
                if (this.values != null) {
                    Iterator it = this.values.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        Float value = new Float((String)it.next());
                        result[i++] = (String)value.floatValue();
                    }
                    this.property.setValue(result);
                }
            } else if (this.property.getType().equals("Byte")) {
                result = new byte[size];
                if (this.values != null) {
                    Iterator it = this.values.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        Byte value = new Byte((String)it.next());
                        result[i++] = (String)((Object)value);
                    }
                    this.property.setValue(result);
                }
            } else if (this.property.getType().equals("Char")) {
                result = new char[size];
                if (this.values != null) {
                    Iterator it = this.values.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        char[] value = ((String)it.next()).toCharArray();
                        result[i++] = (String)value[0];
                    }
                    this.property.setValue(result);
                }
            } else if (this.property.getType().equals("Boolean")) {
                result = new boolean[size];
                if (this.values != null) {
                    Iterator it = this.values.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        Boolean value = new Boolean((String)it.next());
                        result[i++] = (String)((Object)value);
                    }
                    this.property.setValue(result);
                }
            } else if (this.property.getType().equals("Short")) {
                result = new short[size];
                if (this.values != null) {
                    Iterator it = this.values.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        Short value = new Short((String)it.next());
                        result[i++] = (String)((Object)value);
                    }
                    this.property.setValue(result);
                }
            }
        }
        ComponentDescription component = this.parent.getComponentDescription();
        component.addPropertyDescription(this.property);
        this.root.setHandler(this.parent);
    }

    protected String getElementName() {
        return "property";
    }
}

