/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds.parser;

import org.eclipse.equinox.ds.model.ComponentDescription;
import org.eclipse.equinox.ds.model.ReferenceDescription;
import org.eclipse.equinox.ds.parser.ComponentElement;
import org.eclipse.equinox.ds.parser.ElementHandler;
import org.eclipse.equinox.ds.parser.ParserHandler;
import org.xml.sax.Attributes;

class ReferenceElement
extends ElementHandler {
    private ComponentElement parent;
    private ReferenceDescription reference;

    ReferenceElement(ParserHandler root, ComponentElement parent, Attributes attributes) {
        this.root = root;
        this.parent = parent;
        this.reference = new ReferenceDescription();
        this.processAttributes(attributes);
        if (this.reference.getName() == null) {
            root.logError("reference name not specified");
        }
        if (this.reference.getInterfacename() == null) {
            root.logError("reference interface not specified");
        }
    }

    protected void handleAttribute(String name, String value) {
        if (name.equals("name")) {
            this.reference.setName(value);
            return;
        }
        if (name.equals("interface")) {
            this.reference.setInterfacename(value);
            return;
        }
        if (name.equals("cardinality")) {
            this.reference.setCardinality(value);
            return;
        }
        if (name.equals("policy")) {
            this.reference.setPolicy(value);
            return;
        }
        if (name.equals("target")) {
            this.reference.setTarget(value);
            return;
        }
        if (name.equals("bind")) {
            this.reference.setBind(value);
            return;
        }
        if (name.equals("unbind")) {
            this.reference.setUnbind(value);
            return;
        }
        this.root.logError("unrecognized reference element attribute: " + name);
    }

    public void endElement(String uri, String localName, String qName) {
        ComponentDescription component = this.parent.getComponentDescription();
        component.addReferenceDescription(this.reference);
        this.root.setHandler(this.parent);
    }

    protected String getElementName() {
        return "reference";
    }
}

