package aQute.lib.tiny;

import java.util.*;

public class Context {
	Context		parent;
	private Map	properties;

	public Map getProperties() {
		if (properties == null)
			properties = new Properties();
		return properties;
	}

	public Object setProperty(String name, Object value) {
		Context c = this;
		while (c != null) {
			Map p = c.getProperties();
			if (p.containsKey(name)) {
				p.put(name, value);
				return value;
			}
			c = c.parent;
		}
		getProperties().put(name, value);
		return value;
	}

	public Object getProperty(CharSequence key) {
		Map p = getProperties();
		Object result = p.get(key);
		if (result == null && parent != null)
			return parent.getProperty(key);
		else
			return result;
	}
	
	public Context getRoot() {
		if ( parent == null )
			return this;
		return parent.getRoot();
	}
}
