/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.util.HashMap;
import org.apache.commons.text.lookup.StringLookup;
import org.apache.commons.text.lookup.XmlStringLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XmlStringLookupTest {
    private static final String DOC_PATH = "src/test/resources/org/apache/commons/text/document.xml";

    static void assertLookup(StringLookup xmlStringLookup) {
        Assertions.assertNotNull((Object)xmlStringLookup);
        Assertions.assertTrue((boolean)(xmlStringLookup instanceof XmlStringLookup));
        Assertions.assertEquals((Object)"Hello World!", (Object)xmlStringLookup.lookup("src/test/resources/org/apache/commons/text/document.xml:/root/path/to/node"));
        Assertions.assertNull((Object)xmlStringLookup.lookup(null));
    }

    @Test
    public void testBadXPath() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> XmlStringLookup.INSTANCE.lookup("docName"));
    }

    @Test
    public void testMissingXPath() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> XmlStringLookup.INSTANCE.lookup("src/test/resources/org/apache/commons/text/document.xml:!JUNK!"));
    }

    @Test
    public void testNoFeatures() {
        String xpath = "/root/path/to/node";
        Assertions.assertEquals((Object)"Hello World!", (Object)new XmlStringLookup(new HashMap()).lookup("src/test/resources/org/apache/commons/text/document.xml:/root/path/to/node"));
    }

    @Test
    public void testNoFeaturesDefault() {
        HashMap<String, Boolean> features = new HashMap<String, Boolean>(1);
        features.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        XmlStringLookupTest.assertLookup((StringLookup)new XmlStringLookup(features));
    }

    @Test
    public void testNull() {
        Assertions.assertNull((Object)XmlStringLookup.INSTANCE.lookup(null));
    }

    @Test
    public void testOne() {
        XmlStringLookupTest.assertLookup((StringLookup)XmlStringLookup.INSTANCE);
    }

    @Test
    public void testToString() {
        Assertions.assertFalse((boolean)XmlStringLookup.INSTANCE.toString().isEmpty());
    }
}

