/*
 * joystick plugin for VDR
 *
 * mappings.h - axis mapping classes
 *
 * Copyright (C) 2003 Andreas Regel <andreas.regel@powarman.de>
 *
 * This code is distributed under the terms and conditions of the
 * GNU GENERAL PUBLIC LICENSE. See the file COPYING for details.
 */

#ifndef _MAPPINGS_H_
#define _MAPPINGS_H_

#include <string>
#include <vector>
using namespace std;

#include <vdr/config.h>
#include <vdr/tools.h>

class cMapping : public cListObject
{
private:
	int number;
	int off;
	int threshold;
	vector<int> values;

	bool Active(int axisValue, int value);
public:
	cMapping();
	bool Parse(const char * s);

	int GetButton(int axisValue, int previousButton);
	int Number() const { return number; }
};

class cMappings : public cConfig<cMapping>
{
public:
	cMappings();
	virtual bool Load(const char * fileName, bool allowComments = false);
	cMapping * GetByNumber(int number);
};

extern cMappings Mappings;

#endif

