/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildingBlock {
    private Vector<String> rawData;
    private static final int version = 1;
    private static final char comment = '#';

    public BuildingBlock() {
        this.rawData = new Vector();
    }

    public BuildingBlock(String[] stringArray) {
        this.rawData = new Vector();
        this.rawData = this.makeVector(stringArray);
    }

    public BuildingBlock(Vector<String> vector) {
        this.rawData = vector;
    }

    public BuildingBlock(InputStream inputStream) {
        this.rawData = new Vector();
        this.readInputStream(inputStream);
    }

    public boolean readInputStream(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        this.rawData.clear();
        try {
            while (bufferedReader.ready()) {
                String string = bufferedReader.readLine();
                if (string == null || (string = string.trim()).length() <= 0 || string.startsWith("#")) continue;
                this.rawData.add(string);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.err.println("An IO Exception occured while attempting to read a BuildingBlock stream.");
            return false;
        }
        return true;
    }

    public int findStartIndex(String string) {
        int n = -1;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        stringBuffer.append('<').append(string).append('>');
        string2 = stringBuffer.toString();
        stringBuffer = null;
        for (int i = 0; i < this.rawData.size(); ++i) {
            String string3 = this.rawData.get(i).toString();
            try {
                if (string3.length() < 3 || !string3.equalsIgnoreCase(string2)) continue;
                n = ++i;
                break;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                System.err.print("Was looking for ");
                System.err.print(string2);
                System.err.println(" and caught a");
                System.err.print("string index out of bounds exception on line: \"");
                System.err.print(string3);
                System.err.println("\"");
                System.err.print("rawData index number: ");
                System.err.println(i);
            }
        }
        return n;
    }

    public int findEndIndex(String string) {
        int n = -1;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        stringBuffer.append('<').append('/').append(string).append('>');
        string2 = stringBuffer.toString();
        stringBuffer = null;
        for (int i = 0; i < this.rawData.size(); ++i) {
            String string3 = this.rawData.get(i).toString();
            try {
                if (string3.length() < 3 || !string3.equalsIgnoreCase(string2)) continue;
                n = i;
                break;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                System.err.print("Was looking for ");
                System.err.print(string2);
                System.err.println(" and caught a");
                System.err.print("string index out of bounds exception on line: \"");
                System.err.print(string3);
                System.err.println("\"");
                System.err.print("rawData index number: ");
                System.err.println(i);
            }
        }
        return n;
    }

    public String[] getDataAsString(String string) {
        int n = 0;
        int n2 = 0;
        n = this.findStartIndex(string);
        n2 = this.findEndIndex(string);
        if (n == -1 || n2 == -1) {
            String[] stringArray = new String[]{"0"};
            return stringArray;
        }
        int n3 = n2 - n;
        String[] stringArray = n3 == 0 ? new String[n3 + 1] : new String[n3];
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            stringArray[n4] = this.rawData.get(i).toString();
            ++n4;
        }
        return stringArray;
    }

    public int[] getDataAsInt(String string) {
        int n = this.findStartIndex(string);
        int n2 = this.findEndIndex(string);
        if (n == -1 || n2 == -1) {
            int[] nArray = new int[]{0};
            return nArray;
        }
        int n3 = n2 - n;
        int[] nArray = n3 == 0 ? new int[n3 + 1] : new int[n3];
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            try {
                String string2 = this.rawData.get(i).toString();
                if (string2.indexOf(44) >= 0) {
                    string2 = string2.replaceAll(",", "");
                }
                nArray[n4] = Integer.parseInt(string2);
                ++n4;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                nArray[0] = 0;
                System.err.println("getDataAsInt(\"" + string + "\") failed.  NumberFormatException was caught.");
                numberFormatException.printStackTrace();
            }
        }
        return nArray;
    }

    public float[] getDataAsFloat(String string) {
        int n = this.findStartIndex(string);
        int n2 = this.findEndIndex(string);
        if (n == -1 || n2 == -1) {
            float[] fArray = new float[]{0.0f};
            return fArray;
        }
        int n3 = n2 - n;
        float[] fArray = n3 == 0 ? new float[n3 + 1] : new float[n3];
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            try {
                fArray[n4] = Float.valueOf(this.rawData.get(i).toString()).floatValue();
                ++n4;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                fArray[0] = 0.0f;
                System.err.println("getDataAsFloat(\"" + string + "\") failed.  NumberFormatException was caught.");
            }
        }
        return fArray;
    }

    public Vector<String> getDataAsVector(String string) {
        int n = 0;
        int n2 = 0;
        n = this.findStartIndex(string);
        n2 = this.findEndIndex(string);
        if (n == -1 || n2 == -1) {
            Vector<String> vector = new Vector<String>();
            vector.clear();
            return vector;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = n; i < n2; ++i) {
            vector.add(this.rawData.get(i));
        }
        return vector;
    }

    public boolean createNewBlock() {
        this.rawData.clear();
        this.writeBlockComment("building block data file");
        this.rawData.add(new String(""));
        this.writeBlockData("BlockVersion", "1");
        return true;
    }

    public boolean writeBlockData(String string, String string2) {
        String[] stringArray = new String[]{string2};
        return this.writeBlockData(string, this.makeVector(stringArray));
    }

    public boolean writeBlockData(String string, int n) {
        String[] stringArray = new String[]{"" + n};
        return this.writeBlockData(string, this.makeVector(stringArray));
    }

    public boolean writeBlockData(String string, int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = "" + nArray[i];
        }
        return this.writeBlockData(string, this.makeVector(stringArray));
    }

    public boolean writeBlockData(String string, float f) {
        String[] stringArray = new String[]{"" + f};
        return this.writeBlockData(string, this.makeVector(stringArray));
    }

    public boolean writeBlockData(String string, float[] fArray) {
        String[] stringArray = new String[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            stringArray[i] = "" + fArray[i];
        }
        return this.writeBlockData(string, this.makeVector(stringArray));
    }

    public boolean writeBlockData(String string, String[] stringArray) {
        return this.writeBlockData(string, this.makeVector(stringArray));
    }

    public boolean writeBlockData(String string, Vector<String> vector) {
        this.rawData.add(new String("<" + string + ">"));
        for (int i = 0; i < vector.size(); ++i) {
            this.rawData.add(vector.get(i).trim());
        }
        this.rawData.add(new String("</" + string + ">"));
        this.rawData.add(new String(""));
        return true;
    }

    public boolean writeBlockComment(String string) {
        this.rawData.add('#' + string);
        return true;
    }

    public boolean writeBlockFile(String string) {
        File file = new File(string);
        if (file.exists() && !file.delete()) {
            System.err.println("Unable to delete file...(so I could re-write it)");
            return false;
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            for (int i = 0; i < this.rawData.size(); ++i) {
                bufferedWriter.write(this.rawData.get(i).toString());
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.err.println("Unable to save block file " + string);
            return false;
        }
        return true;
    }

    public void clearData() {
        this.rawData.clear();
    }

    public int dataSize() {
        return this.rawData.size();
    }

    public Vector<String> makeVector(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        try {
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = stringArray[n].trim();
                vector.add(stringArray[n]);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return vector;
        }
        return vector;
    }

    public Vector<String> getVector() {
        return this.rawData;
    }

    public String[] getAllDataAsString() {
        String[] stringArray = new String[this.rawData.size()];
        for (int i = 0; i < this.rawData.size(); ++i) {
            stringArray[i] = this.rawData.get(i).toString();
        }
        return stringArray;
    }

    public Vector<String> getAllDataAsVector() {
        Vector<String> vector = this.rawData;
        return vector;
    }

    public int getReturnedArraySize(String[] stringArray) {
        try {
            return Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Couldn't find array size at [0]...is this an array I returned...?");
            System.err.println("Trying to find size anyway...");
            return this.countArray(stringArray);
        }
    }

    public int getReturnedArraySize(int[] nArray) {
        return nArray[0];
    }

    public int getReturnedArraySize(Vector<Object> vector) {
        return vector.size();
    }

    public int getReturnedArraySize(float[] fArray) {
        try {
            return Integer.parseInt("" + fArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Couldn't find array size at [0]...is this an array I returned...?");
            System.err.println("Trying to find size anyway...");
            return this.countArray(fArray);
        }
    }

    public int countArray(String[] stringArray) {
        return stringArray.length;
    }

    public int countArray(float[] fArray) {
        return fArray.length;
    }

    public int countArray(int[] nArray) {
        return nArray.length;
    }

    public boolean exists(String string) {
        if (this.findStartIndex(string) == -1) {
            return false;
        }
        return this.findEndIndex(string) != -1;
    }
}

