/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.generic.ClassGenException;
import org.aspectj.apache.bcel.generic.ConstantPoolGen;
import org.aspectj.apache.bcel.generic.ConstantPushInstruction;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.apache.bcel.generic.TypedInstruction;
import org.aspectj.apache.bcel.generic.Visitor;

public class LCONST
extends Instruction
implements ConstantPushInstruction,
TypedInstruction {
    private long value;

    LCONST() {
    }

    public LCONST(long l) {
        super((short)9, (short)1);
        if (l == 0L) {
            this.opcode = (short)9;
        } else if (l == 1L) {
            this.opcode = (short)10;
        } else {
            throw new ClassGenException("LCONST can be used only for 0 and 1: " + l);
        }
        this.value = l;
    }

    public Number getValue() {
        return new Long(this.value);
    }

    public Type getType(ConstantPoolGen cp) {
        return Type.LONG;
    }

    public void accept(Visitor v) {
        v.visitPushInstruction(this);
        v.visitStackProducer(this);
        v.visitTypedInstruction(this);
        v.visitConstantPushInstruction(this);
        v.visitLCONST(this);
    }
}

