/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodScope;

public class JavadocSingleNameReference
extends SingleNameReference {
    public int tagSourceStart;
    public int tagSourceEnd;

    public JavadocSingleNameReference(char[] source, long pos, int tagStart, int tagEnd) {
        super(source, pos);
        this.tagSourceStart = tagStart;
        this.tagSourceEnd = tagEnd;
        this.bits |= 0x8000;
    }

    public void resolve(BlockScope scope) {
        this.resolve(scope, true);
    }

    public void resolve(BlockScope scope, boolean warn) {
        LocalVariableBinding variableBinding = scope.findVariable(this.token);
        if (variableBinding != null && variableBinding.isValidBinding() && variableBinding.isArgument) {
            this.binding = variableBinding;
            return;
        }
        if (warn) {
            try {
                MethodScope methScope = (MethodScope)scope;
                scope.problemReporter().javadocUndeclaredParamTagName(this.token, this.sourceStart, this.sourceEnd, methScope.referenceMethod().modifiers);
            }
            catch (Exception e) {
                scope.problemReporter().javadocUndeclaredParamTagName(this.token, this.sourceStart, this.sourceEnd, -1);
            }
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }
}

