/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.PerTypeWithinTargetTypeMunger;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.World;
import org.aspectj.weaver.ast.CallExpr;
import org.aspectj.weaver.ast.Expr;
import org.aspectj.weaver.ast.Literal;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.patterns.AndPointcut;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.AnyAnnotationTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.KindedPointcut;
import org.aspectj.weaver.patterns.ModifiersPattern;
import org.aspectj.weaver.patterns.NamePattern;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.SignaturePattern;
import org.aspectj.weaver.patterns.ThrowsPattern;
import org.aspectj.weaver.patterns.TypePattern;
import org.aspectj.weaver.patterns.TypePatternList;
import org.aspectj.weaver.patterns.WithinPointcut;

public class PerTypeWithin
extends PerClause {
    private TypePattern typePattern;
    private static final Set kindSet = new HashSet(Shadow.ALL_SHADOW_KINDS);

    public TypePattern getTypePattern() {
        return this.typePattern;
    }

    public PerTypeWithin(TypePattern p) {
        this.typePattern = p;
    }

    public Set couldMatchKinds() {
        return kindSet;
    }

    public FuzzyBoolean fastMatch(FastMatchInfo info) {
        if (this.typePattern.annotationPattern instanceof AnyAnnotationTypePattern) {
            return this.isWithinType(info.getType());
        }
        return FuzzyBoolean.MAYBE;
    }

    protected FuzzyBoolean matchInternal(Shadow shadow) {
        ResolvedTypeX enclosingType = shadow.getIWorld().resolve(shadow.getEnclosingType(), true);
        if (enclosingType == ResolvedTypeX.MISSING) {
            Message msg = new Message("Cant find type pertypewithin matching...", shadow.getSourceLocation(), true, new ISourceLocation[]{this.getSourceLocation()});
            shadow.getIWorld().getMessageHandler().handleMessage(msg);
        }
        this.typePattern.resolve(shadow.getIWorld());
        return this.isWithinType(enclosingType);
    }

    public void resolveBindings(IScope scope, Bindings bindings) {
        this.typePattern = this.typePattern.resolveBindings(scope, bindings, false, false);
    }

    protected Test findResidueInternal(Shadow shadow, ExposedState state) {
        ResolvedMember ptwField = AjcMemberMaker.perTypeWithinField(shadow.getEnclosingType(), this.inAspect);
        CallExpr myInstance = Expr.makeCallExpr(AjcMemberMaker.perTypeWithinLocalAspectOf(shadow.getEnclosingType(), this.inAspect), Expr.NONE, this.inAspect);
        state.setAspectInstance(myInstance);
        return this.match(shadow).alwaysTrue() ? Literal.TRUE : Literal.FALSE;
    }

    public PerClause concretize(ResolvedTypeX inAspect) {
        PerTypeWithin ret = new PerTypeWithin(this.typePattern);
        ret.copyLocationFrom(this);
        ret.inAspect = inAspect;
        if (inAspect.isAbstract()) {
            return ret;
        }
        World world = inAspect.getWorld();
        SignaturePattern sigpat = new SignaturePattern(Member.STATIC_INITIALIZATION, ModifiersPattern.ANY, TypePattern.ANY, TypePattern.ANY, NamePattern.ANY, TypePatternList.ANY, ThrowsPattern.ANY, AnnotationTypePattern.ANY);
        KindedPointcut staticInitStar = new KindedPointcut(Shadow.StaticInitialization, sigpat);
        WithinPointcut withinTp = new WithinPointcut(this.typePattern);
        AndPointcut andPcut = new AndPointcut(staticInitStar, withinTp);
        inAspect.crosscuttingMembers.addConcreteShadowMunger(Advice.makePerTypeWithinEntry(world, andPcut, inAspect));
        PerTypeWithinTargetTypeMunger munger = new PerTypeWithinTargetTypeMunger(inAspect, ret);
        inAspect.crosscuttingMembers.addTypeMunger(world.concreteTypeMunger(munger, inAspect));
        return ret;
    }

    public void write(DataOutputStream s) throws IOException {
        PerClause.PERTYPEWITHIN.write(s);
        this.typePattern.write(s);
        this.writeLocation(s);
    }

    public static PerClause readPerClause(VersionedDataInputStream s, ISourceContext context) throws IOException {
        PerTypeWithin ret = new PerTypeWithin(TypePattern.read(s, context));
        ret.readLocation(context, s);
        return ret;
    }

    public PerClause.Kind getKind() {
        return PerClause.PERTYPEWITHIN;
    }

    public String toString() {
        return "pertypewithin(" + this.typePattern + ")";
    }

    public String toDeclarationString() {
        return this.toString();
    }

    private FuzzyBoolean isWithinType(ResolvedTypeX type) {
        while (type != null) {
            if (this.typePattern.matchesStatically(type)) {
                return FuzzyBoolean.YES;
            }
            type = type.getDeclaringType();
        }
        return FuzzyBoolean.NO;
    }
}

