/** \file InfoDisplay.h
 * \author Gabriel Montenegro <gmontenegro@users.sourceforge.net>
 * \date 10-14-04
 * \brief InfoDisplay class header
 *
 * Define class structure
 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _INFODECORATOR_H
#define _INFODECORATOR_H


// Include files

#include "Display.h"

enum eDisplayInfo
{
	LeftRight = 0,
	Left,
	None
};

class InfoDisplay : public Display
{
public:
	InfoDisplay();
	virtual ~InfoDisplay();

	virtual void Draw(Interfaces & rInterfaces, bool bForce = false);

private:

	void ShowLabels(Interface & rInterface, eDisplayInfo eInfo);
	void ShowInfo(Interface & rInterface, eDisplayInfo eInfo, bool bForce);

	void FormatSize(unsigned long ulBytes, string & strOutput, bool bPerSecond);
  void FormatPacket(unsigned long ulPackets, string & strOutput, bool bPerSecond);


private:
	string m_strLastInterface;
	string m_strLastIPAddress;
	string m_strLastOnlineTime;

	unsigned long m_ulLastTopInBytesSecond;
	unsigned long m_ulLastTopOutBytesSecond;

	InterfaceData m_cLastData;

	string strData[11];
	int iLastDataSize[11];

	bool m_bLabelsDrawn;
	bool m_bLastHaveOnlineTime;
};

#endif
