/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.fus;

import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.terminal.frontend.fus.FrontendLatencyServiceImplKt;
import com.intellij.terminal.session.TerminalContentUpdatedEvent;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.fus.BatchLatencyReporter;
import org.jetbrains.plugins.terminal.fus.BatchLatencyReporterKt;
import org.jetbrains.plugins.terminal.fus.FrontendOutputActivity;
import org.jetbrains.plugins.terminal.fus.ReworkedTerminalUsageCollector;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0002J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/terminal/frontend/fus/FrontendOutputActivityImpl;", "Lorg/jetbrains/plugins/terminal/fus/FrontendOutputActivity;", "outputEditor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "alternateBufferEditor", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "pendingEvents", "Ljava/util/concurrent/ArrayBlockingQueue;", "Lcom/intellij/terminal/frontend/fus/FrontendOutputActivityImpl$ReceivedEvent;", "pendingPaints", "editorRepaintRequests", "", "editorRepaintRequestsBeforeModelUpdate", "latencyReporter", "Lorg/jetbrains/plugins/terminal/fus/BatchLatencyReporter;", "Lkotlin/time/Duration;", "eventReceived", "", "event", "Lcom/intellij/terminal/session/TerminalContentUpdatedEvent;", "beforeModelUpdate", "editorRepaintRequested", "afterModelUpdate", "editorPainted", "reportLatency", "receivedEvent", "ReceivedEvent", "intellij.terminal.frontend"})
final class FrontendOutputActivityImpl
implements FrontendOutputActivity {
    @NotNull
    private final EditorImpl outputEditor;
    @NotNull
    private final EditorImpl alternateBufferEditor;
    @NotNull
    private final ArrayBlockingQueue<ReceivedEvent> pendingEvents;
    @NotNull
    private final ArrayBlockingQueue<ReceivedEvent> pendingPaints;
    private long editorRepaintRequests;
    private long editorRepaintRequestsBeforeModelUpdate;
    @NotNull
    private final BatchLatencyReporter<Duration> latencyReporter;

    public FrontendOutputActivityImpl(@NotNull EditorImpl outputEditor, @NotNull EditorImpl alternateBufferEditor) {
        Intrinsics.checkNotNullParameter((Object)outputEditor, (String)"outputEditor");
        Intrinsics.checkNotNullParameter((Object)alternateBufferEditor, (String)"alternateBufferEditor");
        this.outputEditor = outputEditor;
        this.alternateBufferEditor = alternateBufferEditor;
        this.pendingEvents = new ArrayBlockingQueue(100);
        this.pendingPaints = new ArrayBlockingQueue(100);
        this.latencyReporter = new BatchLatencyReporter(100, FrontendOutputActivityImpl::latencyReporter$lambda$0);
        this.outputEditor.setRepaintCallback(() -> FrontendOutputActivityImpl._init_$lambda$1(this));
        this.alternateBufferEditor.setRepaintCallback(() -> FrontendOutputActivityImpl._init_$lambda$2(this));
        this.outputEditor.setPaintCallback(() -> FrontendOutputActivityImpl._init_$lambda$3(this));
        this.alternateBufferEditor.setPaintCallback(() -> FrontendOutputActivityImpl._init_$lambda$4(this));
    }

    @Override
    public void eventReceived(@NotNull TerminalContentUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        FrontendLatencyServiceImplKt.access$addDroppingOldest(this.pendingEvents, new ReceivedEvent((TimeMark)TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto()), event));
    }

    @Override
    public void beforeModelUpdate() {
        this.editorRepaintRequestsBeforeModelUpdate = this.editorRepaintRequests;
    }

    private final void editorRepaintRequested() {
        ++this.editorRepaintRequests;
    }

    @Override
    public void afterModelUpdate() {
        boolean editorShowing;
        boolean repaintRequested = this.editorRepaintRequests > this.editorRepaintRequestsBeforeModelUpdate;
        boolean bl = editorShowing = this.outputEditor.getComponent().isShowing() || this.alternateBufferEditor.getComponent().isShowing();
        if (!editorShowing) {
            this.pendingPaints.clear();
        }
        boolean repaintExpected = repaintRequested && editorShowing;
        while (this.pendingEvents.poll() != null) {
            ReceivedEvent pendingEvent;
            if (!repaintExpected) continue;
            FrontendLatencyServiceImplKt.access$addDroppingOldest(this.pendingPaints, pendingEvent);
        }
    }

    private final void editorPainted() {
        while (this.pendingPaints.poll() != null) {
            ReceivedEvent pendingPaint;
            this.reportLatency(pendingPaint);
        }
    }

    private final void reportLatency(ReceivedEvent receivedEvent) {
        long latency = receivedEvent.getTime().elapsedNow-UwyO8pc();
        this.latencyReporter.update(Duration.box-impl((long)latency));
    }

    private static final Unit latencyReporter$lambda$0(List samples) {
        Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
        ReworkedTerminalUsageCollector.INSTANCE.logFrontendOutputLatency-WzaCiaA(BatchLatencyReporterKt.totalDuration(samples), ((Duration)BatchLatencyReporterKt.percentile(samples, 90)).unbox-impl(), ((Duration)BatchLatencyReporterKt.thirdLargest(samples)).unbox-impl());
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(FrontendOutputActivityImpl this$0) {
        this$0.editorRepaintRequested();
    }

    private static final void _init_$lambda$2(FrontendOutputActivityImpl this$0) {
        this$0.editorRepaintRequested();
    }

    private static final void _init_$lambda$3(FrontendOutputActivityImpl this$0) {
        this$0.editorPainted();
    }

    private static final void _init_$lambda$4(FrontendOutputActivityImpl this$0) {
        this$0.editorPainted();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/terminal/frontend/fus/FrontendOutputActivityImpl$ReceivedEvent;", "", "time", "Lkotlin/time/TimeMark;", "event", "Lcom/intellij/terminal/session/TerminalContentUpdatedEvent;", "<init>", "(Lkotlin/time/TimeMark;Lcom/intellij/terminal/session/TerminalContentUpdatedEvent;)V", "getTime", "()Lkotlin/time/TimeMark;", "getEvent", "()Lcom/intellij/terminal/session/TerminalContentUpdatedEvent;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.terminal.frontend"})
    private static final class ReceivedEvent {
        @NotNull
        private final TimeMark time;
        @NotNull
        private final TerminalContentUpdatedEvent event;

        public ReceivedEvent(@NotNull TimeMark time, @NotNull TerminalContentUpdatedEvent event) {
            Intrinsics.checkNotNullParameter((Object)time, (String)"time");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.time = time;
            this.event = event;
        }

        @NotNull
        public final TimeMark getTime() {
            return this.time;
        }

        @NotNull
        public final TerminalContentUpdatedEvent getEvent() {
            return this.event;
        }

        @NotNull
        public final TimeMark component1() {
            return this.time;
        }

        @NotNull
        public final TerminalContentUpdatedEvent component2() {
            return this.event;
        }

        @NotNull
        public final ReceivedEvent copy(@NotNull TimeMark time, @NotNull TerminalContentUpdatedEvent event) {
            Intrinsics.checkNotNullParameter((Object)time, (String)"time");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return new ReceivedEvent(time, event);
        }

        public static /* synthetic */ ReceivedEvent copy$default(ReceivedEvent receivedEvent, TimeMark timeMark, TerminalContentUpdatedEvent terminalContentUpdatedEvent, int n, Object object) {
            if ((n & 1) != 0) {
                timeMark = receivedEvent.time;
            }
            if ((n & 2) != 0) {
                terminalContentUpdatedEvent = receivedEvent.event;
            }
            return receivedEvent.copy(timeMark, terminalContentUpdatedEvent);
        }

        @NotNull
        public String toString() {
            return "ReceivedEvent(time=" + this.time + ", event=" + this.event + ")";
        }

        public int hashCode() {
            int result2 = this.time.hashCode();
            result2 = result2 * 31 + this.event.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReceivedEvent)) {
                return false;
            }
            ReceivedEvent receivedEvent = (ReceivedEvent)other;
            if (!Intrinsics.areEqual((Object)this.time, (Object)receivedEvent.time)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.event, (Object)receivedEvent.event);
        }
    }
}

