/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowContextMenuActionBase;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;
import org.jetbrains.plugins.terminal.ui.TerminalContainer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ(\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ(\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/terminal/action/TerminalSessionContextMenuActionBase;", "Lcom/intellij/openapi/wm/ToolWindowContextMenuActionBase;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "content", "Lcom/intellij/ui/content/Content;", "updateInTerminalToolWindow", "project", "Lcom/intellij/openapi/project/Project;", "terminalWidget", "Lcom/intellij/terminal/ui/TerminalWidget;", "actionPerformed", "actionPerformedInTerminalToolWindow", "findContextTerminal", "intellij.terminal"})
public abstract class TerminalSessionContextMenuActionBase
extends ToolWindowContextMenuActionBase
implements ActionRemoteBehaviorSpecification.Frontend {
    public final void update(@NotNull AnActionEvent e, @NotNull ToolWindow toolWindow, @Nullable Content content) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Project project = e.getProject();
        if (project != null && TerminalToolWindowManager.isTerminalToolWindow(toolWindow) && content != null) {
            TerminalWidget terminalWidget = this.findContextTerminal(e, content);
            if (terminalWidget != null) {
                this.updateInTerminalToolWindow(e, project, content, terminalWidget);
            } else {
                e.getPresentation().setEnabledAndVisible(false);
            }
        } else {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    public void updateInTerminalToolWindow(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Content content, @NotNull TerminalWidget terminalWidget) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)terminalWidget, (String)"terminalWidget");
    }

    public final void actionPerformed(@NotNull AnActionEvent e, @NotNull ToolWindow toolWindow, @Nullable Content content) {
        TerminalWidget terminalWidget;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Project project = e.getProject();
        if (project != null && TerminalToolWindowManager.isTerminalToolWindow(toolWindow) && content != null && (terminalWidget = this.findContextTerminal(e, content)) != null) {
            this.actionPerformedInTerminalToolWindow(e, project, content, terminalWidget);
        }
    }

    public abstract void actionPerformedInTerminalToolWindow(@NotNull AnActionEvent var1, @NotNull Project var2, @NotNull Content var3, @NotNull TerminalWidget var4);

    private final TerminalWidget findContextTerminal(AnActionEvent e, Content content) {
        TerminalWidget newWidget = (TerminalWidget)e.getDataContext().getData(TerminalContainer.TERMINAL_WIDGET_DATA_KEY);
        if (newWidget != null) {
            return newWidget;
        }
        JBTerminalWidget terminalWidget = (JBTerminalWidget)e.getDataContext().getData(JBTerminalWidget.TERMINAL_DATA_KEY);
        return terminalWidget != null && UIUtil.isAncestor((Component)content.getComponent(), (Component)((Component)terminalWidget)) ? terminalWidget.asNewWidget() : TerminalToolWindowManager.findWidgetByContent(content);
    }
}

