/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.prettierjs.PrettierCodeStyleImporter;
import com.intellij.prettierjs.PrettierUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrettierImportCodeStyleAction
extends AnAction
implements DumbAware {
    public static final String ACTION_ID = "PrettierImportCodeStyleAction";

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PrettierImportCodeStyleAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        VirtualFile contextFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        boolean enabled = project != null && contextFile != null && (PrettierImportCodeStyleAction.getFileWithPrettierConfiguration(project, contextFile) != null || PrettierImportCodeStyleAction.isPackageJsonWithDependencyOnPrettier(contextFile));
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            PrettierImportCodeStyleAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    @Nullable
    static VirtualFile getFileWithPrettierConfiguration(@NotNull Project project, @NotNull VirtualFile contextFile) {
        if (project == null) {
            PrettierImportCodeStyleAction.$$$reportNull$$$0(2);
        }
        if (contextFile == null) {
            PrettierImportCodeStyleAction.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (!PrettierUtil.isConfigFileOrPackageJson(contextFile)) {
            return null;
        }
        if (!ProjectFileIndex.getInstance((Project)project).isInContent(contextFile)) {
            return null;
        }
        if (PrettierUtil.isConfigFile(contextFile)) {
            return contextFile;
        }
        PackageJsonData data = PackageJsonData.getOrCreate((VirtualFile)contextFile);
        if (data.getTopLevelProperties().contains("prettier")) {
            return contextFile;
        }
        return PrettierUtil.findSingleConfigInDirectory(contextFile.getParent());
    }

    private static boolean isPackageJsonWithDependencyOnPrettier(@NotNull VirtualFile file) {
        if (file == null) {
            PrettierImportCodeStyleAction.$$$reportNull$$$0(4);
        }
        if (!PackageJsonUtil.isPackageJsonFile((VirtualFile)file)) {
            return false;
        }
        PackageJsonData data = PackageJsonData.getOrCreate((VirtualFile)file);
        return data.isDependencyOfAnyType("prettier");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiFile psiFile;
        if (e == null) {
            PrettierImportCodeStyleAction.$$$reportNull$$$0(5);
        }
        Project project = e.getProject();
        VirtualFile contextFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || contextFile == null) {
            return;
        }
        VirtualFile file = PrettierImportCodeStyleAction.getFileWithPrettierConfiguration(project, contextFile);
        if (file == null && PrettierImportCodeStyleAction.isPackageJsonWithDependencyOnPrettier(contextFile)) {
            file = contextFile;
        }
        PsiFile psiFile2 = psiFile = file != null ? PsiManager.getInstance((Project)project).findFile(file) : null;
        if (psiFile == null) {
            return;
        }
        new PrettierCodeStyleImporter(false).importConfigFile(psiFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/prettierjs/PrettierImportCodeStyleAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/prettierjs/PrettierImportCodeStyleAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFileWithPrettierConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPackageJsonWithDependencyOnPrettier";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

