/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.TestTrackingIOUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestTrackingCallback {
    private final File myDataFile;
    private File myTracesDir;
    private final AtomicReference<Map<Object, boolean[]>> myTrace = new AtomicReference();

    /*
     * WARNING - void declaration
     */
    protected TestTrackingCallback(File file) {
        void var1_1;
        this.myDataFile = var1_1;
    }

    public abstract void clearTrace(ClassData var1);

    public abstract boolean[] traceLine(ClassData var1, int var2);

    private Map<Object, boolean[]> getTraces() {
        return this.myTrace.get();
    }

    /*
     * WARNING - void declaration
     */
    public void traceLineByTest(Object classData, int line) {
        boolean[] lines;
        Map<Object, boolean[]> traces = this.getTraces();
        if (traces != null && (lines = this.traceLine((ClassData)classData, line)) != null) {
            void var2_3;
            void var1_1;
            void var3_4;
            var3_4.put(var1_1, var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void registerForTrace(Object classData) {
        Map<Object, boolean[]> traces = this.getTraces();
        if (traces != null) {
            Object object = classData;
            synchronized (object) {
                void var1_1;
                void var2_3;
                boolean[] trace = ((ClassData)classData).getTraceMask();
                if (var2_3.put(var1_1, trace) == null) {
                    Arrays.fill(trace, false);
                }
                trace[0] = true;
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testEnded(String name) {
        Iterator iterator;
        File file;
        Map trace = this.myTrace.getAndSet(null);
        if (trace == null) {
            return;
        }
        File tracesDir = this.getTracesDir();
        try {
            try {
                TestTrackingIOUtil.saveTestResults(tracesDir, name, trace);
            }
            catch (IOException e) {
                ErrorReporter.warn("Error writing traces for test '" + name + "' to directory " + file.getPath(), e);
                file = null;
                iterator = iterator.entrySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return;
                    }
                    Map.Entry entry = iterator.next();
                    ClassData classData = (ClassData)entry.getKey();
                    boolean[] touched = (boolean[])entry.getValue();
                    Object[] lines = classData.getLines();
                    int lineCount = Math.min(lines.length, touched.length);
                    for (int i = 1; i < lineCount; ++i) {
                        LineData lineData = (LineData)lines[i];
                        if (lineData == null || !touched[i]) continue;
                        lineData.setTestName(name);
                    }
                    this.clearTrace(classData);
                }
            }
            file = null;
            iterator = iterator.entrySet().iterator();
        }
        catch (Throwable throwable) {
            file = null;
            iterator = iterator.entrySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    throw throwable;
                }
                Map.Entry entry = iterator.next();
                ClassData classData = (ClassData)entry.getKey();
                boolean[] touched = (boolean[])entry.getValue();
                Object[] lines = classData.getLines();
                int lineCount = Math.min(lines.length, touched.length);
                for (int i = 1; i < lineCount; ++i) {
                    LineData lineData = (LineData)lines[i];
                    if (lineData == null || !touched[i]) continue;
                    lineData.setTestName(name);
                }
                this.clearTrace(classData);
            }
        }
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ClassData classData = (ClassData)entry.getKey();
            boolean[] touched = (boolean[])entry.getValue();
            Object[] lines = classData.getLines();
            int lineCount = Math.min(lines.length, touched.length);
            for (int i = 1; i < lineCount; ++i) {
                LineData lineData = (LineData)lines[i];
                if (lineData == null || !touched[i]) continue;
                lineData.setTestName(name);
            }
            this.clearTrace(classData);
        }
    }

    public void testStarted(String ignoredName) {
        this.myTrace.compareAndSet(null, new ConcurrentHashMap());
    }

    private File getTracesDir() {
        if (this.myTracesDir == null) {
            this.myTracesDir = TestTrackingCallback.createTracesDir(this.myDataFile);
        }
        return this.myTracesDir;
    }

    /*
     * WARNING - void declaration
     */
    public static File createTracesDir(File dataFile) {
        File file;
        void var1_1;
        void dirName;
        void var2_2;
        String fileName = dataFile.getName();
        int i = fileName.lastIndexOf(46);
        dirName = i != -1 ? fileName.substring(0, (int)var2_2) : dirName;
        File result = new File(dataFile.getParent(), (String)var1_1);
        if (!result.exists()) {
            result.mkdirs();
        }
        return file;
    }
}

