/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.connections.P4ConfigListener;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionParameters;
import org.jetbrains.idea.perforce.perforce.connections.P4EnvHelper;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.connections.PerforceMultipleConnections;

public class PerforceP4ConfigVirtualFileListener
implements VirtualFileListener {
    private final PerforceConnectionManagerI myConnectionManager;
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance(PerforceP4ConfigVirtualFileListener.class);
    private final P4EnvHelper myP4EnvHelper;

    public PerforceP4ConfigVirtualFileListener(@NotNull PerforceConnectionManagerI connectionManager, @NotNull Project project, @NotNull Disposable parentDisposable) {
        if (connectionManager == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(0);
        }
        if (project == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(2);
        }
        this.myConnectionManager = connectionManager;
        this.myProject = project;
        this.myP4EnvHelper = P4EnvHelper.getConfigHelper(this.myProject);
        project.getMessageBus().connect(parentDisposable).subscribe(P4ConfigListener.TOPIC, (Object)new MyPerforceConfigListener());
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(3);
        }
        this.processFileEvent((VirtualFileEvent)event);
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(4);
        }
        this.processFileEvent(event);
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(5);
        }
        this.processFileEvent(event);
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        if (event == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(6);
        }
        this.processFileEvent(event);
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(7);
        }
        this.processFileEvent((VirtualFileEvent)event);
    }

    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(8);
        }
        this.processFileEvent((VirtualFileEvent)event);
    }

    public void beforeContentsChange(@NotNull VirtualFileEvent event) {
        if (event == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(9);
        }
        this.processFileEvent(event);
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
        if (event == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(10);
        }
        this.processFileEvent(event);
    }

    public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(11);
        }
        this.processFileEvent((VirtualFileEvent)event);
    }

    private boolean isConfigFileName(@NotNull String fileName) {
        PerforceMultipleConnections multipleConnections;
        if (fileName == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(12);
        }
        if ((multipleConnections = this.myConnectionManager.getMultipleConnectionObject()) != null) {
            for (Pair<VirtualFile, P4ConnectionParameters> parameters : multipleConnections.getAllConnectionParameters()) {
                if (!Objects.equals(((P4ConnectionParameters)parameters.second).getConfigFileName(), fileName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isIgnoredFileName(@NotNull String fileName) {
        if (fileName == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(13);
        }
        if (fileName.equals(this.myP4EnvHelper.getP4Ignore())) {
            return true;
        }
        PerforceMultipleConnections multipleConnections = this.myConnectionManager.getMultipleConnectionObject();
        if (multipleConnections != null) {
            for (Pair<VirtualFile, P4ConnectionParameters> parameters : multipleConnections.getAllConnectionParameters()) {
                if (!Objects.equals(((P4ConnectionParameters)parameters.second).getIgnoreFileName(), fileName)) continue;
                return true;
            }
        }
        return false;
    }

    private void processFileEvent(VirtualFileEvent event) {
        String fileName = event.getFileName();
        this.processFileChanged(fileName);
    }

    private void processFileChanged(@NotNull String fileName) {
        if (fileName == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(14);
        }
        if (this.isIgnoredFileName(fileName)) {
            LOG.debug("p4ignore file changed");
            PerforceVcs.getInstance(this.myProject).getOnlineChangeProvider().discardCache();
        }
        if (this.isConfigFileName(fileName)) {
            LOG.debug("p4config file changed");
            this.myConnectionManager.updateConnections();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/perforce/perforce/connections/PerforceP4ConfigVirtualFileListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "contentsChanged";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fileCreated";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "fileDeleted";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "fileMoved";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "beforePropertyChange";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeContentsChange";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeFileDeletion";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeFileMovement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigFileName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isIgnoredFileName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "processFileChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyPerforceConfigListener
    implements P4ConfigListener {
        private MyPerforceConfigListener() {
        }

        @Override
        public void notifyConfigChanged(@NotNull String configPath) {
            if (configPath == null) {
                MyPerforceConfigListener.$$$reportNull$$$0(0);
            }
            try {
                Path path = Paths.get(configPath, new String[0]);
                Path fileNamePath = path.getFileName();
                if (fileNamePath != null) {
                    PerforceP4ConfigVirtualFileListener.this.processFileChanged(fileNamePath.toString());
                } else {
                    LOG.warn("Invalid config path: " + configPath);
                }
            }
            catch (InvalidPathException e) {
                LOG.warn("Invalid config path: " + configPath, (Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configPath", "org/jetbrains/idea/perforce/perforce/connections/PerforceP4ConfigVirtualFileListener$MyPerforceConfigListener", "notifyConfigChanged"));
        }
    }
}

