/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.NopProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.javascript.karma.KarmaBundle;
import com.intellij.javascript.karma.KarmaConfig;
import com.intellij.javascript.karma.execution.KarmaConsoleProperties;
import com.intellij.javascript.karma.execution.KarmaConsoleView;
import com.intellij.javascript.karma.execution.KarmaDetector;
import com.intellij.javascript.karma.execution.KarmaExecutionType;
import com.intellij.javascript.karma.execution.KarmaRunConfiguration;
import com.intellij.javascript.karma.execution.KarmaRunSettings;
import com.intellij.javascript.karma.scope.KarmaScopeKind;
import com.intellij.javascript.karma.server.KarmaJsSourcesLocator;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.server.KarmaServerTerminatedListener;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.javascript.testFramework.util.JSTestNamePattern;
import com.intellij.javascript.testing.JSTestRunnerUtil;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetector;
import com.intellij.lang.javascript.ConsoleCommandLineFolder;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.io.LocalFileFinder;

public class KarmaExecutionSession {
    private static final Logger LOG = Logger.getInstance(KarmaExecutionSession.class);
    private final Project myProject;
    private final KarmaRunConfiguration myRunConfiguration;
    private final Executor myExecutor;
    private final KarmaServer myKarmaServer;
    private final KarmaRunSettings myRunSettings;
    private final KarmaExecutionType myExecutionType;
    private final ConsoleCommandLineFolder myFolder;
    private final List<List<String>> myFailedTestNames;

    public KarmaExecutionSession(@NotNull Project project, @NotNull KarmaRunConfiguration runConfiguration, @NotNull Executor executor, @NotNull KarmaServer karmaServer, @NotNull KarmaRunSettings runSettings, @NotNull KarmaExecutionType executionType, @Nullable List<List<String>> failedTestNames) {
        if (project == null) {
            KarmaExecutionSession.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            KarmaExecutionSession.$$$reportNull$$$0(1);
        }
        if (executor == null) {
            KarmaExecutionSession.$$$reportNull$$$0(2);
        }
        if (karmaServer == null) {
            KarmaExecutionSession.$$$reportNull$$$0(3);
        }
        if (runSettings == null) {
            KarmaExecutionSession.$$$reportNull$$$0(4);
        }
        if (executionType == null) {
            KarmaExecutionSession.$$$reportNull$$$0(5);
        }
        this.myFolder = new ConsoleCommandLineFolder(new String[]{"karma", "run"});
        this.myProject = project;
        this.myRunConfiguration = runConfiguration;
        this.myExecutor = executor;
        this.myKarmaServer = karmaServer;
        this.myRunSettings = runSettings;
        this.myExecutionType = executionType;
        this.myFailedTestNames = failedTestNames;
    }

    @NotNull
    public SMTRunnerConsoleView createSMTRunnerConsoleView(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            KarmaExecutionSession.$$$reportNull$$$0(6);
        }
        KarmaConsoleProperties consoleProperties = this.myRunConfiguration.createTestConsoleProperties(this.myExecutor, this.myKarmaServer);
        consoleProperties.addStackTraceFilter((Filter)new NodeStackTraceFilter(this.myProject, this.myKarmaServer.getServerSettings().getWorkingDirectorySystemDependent()));
        KarmaConsoleView consoleView = new KarmaConsoleView((TestConsoleProperties)consoleProperties, this.myKarmaServer, this.myExecutionType, processHandler);
        for (Filter filter : consoleProperties.getStackTrackFilters()) {
            if (filter instanceof NodeStackTraceFilter) continue;
            consoleView.addMessageFilter(filter);
        }
        SMTestRunnerConnectionUtil.initConsoleView((SMTRunnerConsoleView)consoleView, (String)consoleProperties.getTestFrameworkName());
        KarmaConsoleView karmaConsoleView = consoleView;
        if (karmaConsoleView == null) {
            KarmaExecutionSession.$$$reportNull$$$0(7);
        }
        return karmaConsoleView;
    }

    private boolean isDebug() {
        return this.myExecutionType == KarmaExecutionType.DEBUG;
    }

    @NotNull
    public ConsoleCommandLineFolder getFolder() {
        ConsoleCommandLineFolder consoleCommandLineFolder = this.myFolder;
        if (consoleCommandLineFolder == null) {
            KarmaExecutionSession.$$$reportNull$$$0(8);
        }
        return consoleCommandLineFolder;
    }

    @NotNull
    public ProcessHandler createProcessHandler() throws ExecutionException {
        OSProcessHandler processHandler = null;
        if (this.isDebug()) {
            if (this.myKarmaServer.isPortBound()) {
                processHandler = this.createOSProcessHandler(this.myKarmaServer);
            }
        } else if (this.myKarmaServer.areBrowsersReady()) {
            processHandler = this.createOSProcessHandler(this.myKarmaServer);
        }
        if (processHandler == null) {
            processHandler = new NopProcessHandler();
        }
        KarmaExecutionSession.terminateOnServerShutdown(this.myKarmaServer, (ProcessHandler)processHandler);
        OSProcessHandler oSProcessHandler = processHandler;
        if (oSProcessHandler == null) {
            KarmaExecutionSession.$$$reportNull$$$0(9);
        }
        return oSProcessHandler;
    }

    private static void terminateOnServerShutdown(final @NotNull KarmaServer server, final @NotNull ProcessHandler processHandler) {
        if (server == null) {
            KarmaExecutionSession.$$$reportNull$$$0(10);
        }
        if (processHandler == null) {
            KarmaExecutionSession.$$$reportNull$$$0(11);
        }
        final KarmaServerTerminatedListener terminationCallback = new KarmaServerTerminatedListener(){

            @Override
            public void onTerminated(int exitCode) {
                ProcessIOExecutorService.INSTANCE.execute(() -> ScriptRunnerUtil.terminateProcessHandler((ProcessHandler)processHandler, (long)2000L, null));
            }
        };
        server.onTerminated(terminationCallback);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                server.removeTerminatedListener(terminationCallback);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/karma/execution/KarmaExecutionSession$2", "processTerminated"));
            }
        });
    }

    @NotNull
    private OSProcessHandler createOSProcessHandler(@NotNull KarmaServer server) throws ExecutionException {
        if (server == null) {
            KarmaExecutionSession.$$$reportNull$$$0(12);
        }
        NodeJsInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolveNotNull(this.myProject);
        NodeTargetRun targetRun = this.createTargetRun(interpreter, server);
        KillableProcessHandler processHandler = targetRun.startProcessEx().getProcessHandler();
        server.getRestarter().onRunnerExecutionStarted((OSProcessHandler)processHandler);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        KillableProcessHandler killableProcessHandler = processHandler;
        if (killableProcessHandler == null) {
            KarmaExecutionSession.$$$reportNull$$$0(13);
        }
        return killableProcessHandler;
    }

    @NotNull
    private NodeTargetRun createTargetRun(@NotNull NodeJsInterpreter interpreter, @NotNull KarmaServer server) throws ExecutionException {
        String testNamesPattern;
        if (interpreter == null) {
            KarmaExecutionSession.$$$reportNull$$$0(14);
        }
        if (server == null) {
            KarmaExecutionSession.$$$reportNull$$$0(15);
        }
        NodeTargetRun targetRun = new NodeTargetRun(interpreter, this.myProject, null, NodeTargetRunOptions.of((Boolean)NodeTargetRunOptions.shouldUsePtyForTestRunners(), (RunConfigurationBase)this.myRunConfiguration));
        TargetedCommandLineBuilder commandLine = targetRun.getCommandLineBuilder();
        commandLine.setWorkingDirectory(targetRun.path(this.myRunSettings.getWorkingDirectorySystemDependent()));
        targetRun.addNodeOptionsWithExpandedMacros(false, this.myRunSettings.getNodeOptions());
        targetRun.path(KarmaJsSourcesLocator.getInstance().getKarmaIntellijPackageDir());
        Path clientAppFile = KarmaJsSourcesLocator.getInstance().getClientAppFile();
        commandLine.addParameter(targetRun.path(clientAppFile));
        if (NodeJsRemoteInterpreter.isDocker((NodeJsInterpreter)interpreter) || NodeJsRemoteInterpreter.isDockerCompose((NodeJsInterpreter)interpreter)) {
            Promise resolvedPortBinding = targetRun.localPortBinding(server.getServerPort());
            commandLine.addParameter(TargetValue.create((Object)"--serverHost=127.0.0.1", (Promise)resolvedPortBinding.then(portBinding -> "--serverHost=" + portBinding.getTargetEndpoint().getHost())));
            commandLine.addParameter(TargetValue.create((Object)("--serverPort=" + server.getServerPort()), (Promise)resolvedPortBinding.then(portBinding -> "--serverPort=" + portBinding.getTargetEndpoint().getPort())));
        } else {
            commandLine.addParameter("--serverHost=127.0.0.1");
            commandLine.addParameter("--serverPort=" + server.getServerPort());
        }
        KarmaConfig config = server.getKarmaConfig();
        if (config != null) {
            commandLine.addParameter("--protocol=" + config.getProtocol());
            commandLine.addParameter("--urlRoot=" + config.getUrlRoot());
        }
        if (this.isDebug()) {
            commandLine.addParameter("--debug=true");
        }
        if ((testNamesPattern = this.getTestNamesPattern()) != null) {
            commandLine.addParameter("--testNamePattern=" + testNamesPattern);
            this.myFolder.addPlaceholderText("--testNamePattern=" + testNamesPattern);
        }
        NodeTargetRun nodeTargetRun = targetRun;
        if (nodeTargetRun == null) {
            KarmaExecutionSession.$$$reportNull$$$0(16);
        }
        return nodeTargetRun;
    }

    @Nullable
    private String getTestNamesPattern() throws ExecutionException {
        if (this.myFailedTestNames != null) {
            return JSTestRunnerUtil.getTestsPattern(this.myFailedTestNames, (boolean)false);
        }
        if (this.myRunSettings.getScopeKind() == KarmaScopeKind.TEST_FILE) {
            List allFileTests = (List)ReadAction.compute(() -> KarmaExecutionSession.findAllFileTests(this.myProject, this.myRunSettings.getTestFileSystemIndependentPath()));
            String testFileName = PathUtil.getFileName((String)this.myRunSettings.getTestFileSystemIndependentPath());
            if (allFileTests.isEmpty()) {
                throw new ExecutionException(KarmaBundle.message("execution.no_tests_found_in_file.dialog.message", testFileName));
            }
            return JSTestRunnerUtil.getTestNamesPattern((Collection)allFileTests, (boolean)false);
        }
        if (this.myRunSettings.getScopeKind() == KarmaScopeKind.SUITE || this.myRunSettings.getScopeKind() == KarmaScopeKind.TEST) {
            return JSTestRunnerUtil.buildTestNamesPattern((Project)this.myProject, (JsTestFrameworkDetector)KarmaDetector.Companion.getInstance(), (String)this.myRunSettings.getTestFileSystemDependentPath(), this.myRunSettings.getTestNames(), (this.myRunSettings.getScopeKind() == KarmaScopeKind.SUITE ? 1 : 0) != 0);
        }
        return null;
    }

    @NotNull
    private static List<List<JSTestNamePattern>> findAllFileTests(@NotNull Project project, @NotNull String testFilePath) throws ExecutionException {
        VirtualFile file;
        if (project == null) {
            KarmaExecutionSession.$$$reportNull$$$0(17);
        }
        if (testFilePath == null) {
            KarmaExecutionSession.$$$reportNull$$$0(18);
        }
        if ((file = LocalFileFinder.findFile((String)testFilePath)) == null) {
            throw new ExecutionException(KarmaBundle.message("execution.cannot_find_test_by_path.dialog.message", testFilePath));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        JSFile jsFile = (JSFile)ObjectUtils.tryCast((Object)psiFile, JSFile.class);
        if (jsFile == null) {
            LOG.info("Not a JavaScript file " + testFilePath + ", " + String.valueOf(psiFile == null ? "null" : psiFile.getClass()));
            throw new ExecutionException(KarmaBundle.message("execution.javascript_file_expected.dialog.message", testFilePath));
        }
        List<List<JSTestNamePattern>> allTestsPatterns = KarmaDetector.Companion.getInstance().findAllFileTestPatterns(jsFile);
        if (!allTestsPatterns.isEmpty()) {
            List<List<JSTestNamePattern>> list = allTestsPatterns;
            if (list == null) {
                KarmaExecutionSession.$$$reportNull$$$0(19);
            }
            return list;
        }
        throw new ExecutionException(KarmaBundle.message("execution.no_tests_found_in_file.dialog.message", testFilePath));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 13, 16, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "karmaServer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionType";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/execution/KarmaExecutionSession";
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/execution/KarmaExecutionSession";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSMTRunnerConsoleView";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolder";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandler";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createOSProcessHandler";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargetRun";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllFileTests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createSMTRunnerConsoleView";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 16: 
            case 19: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "terminateOnServerShutdown";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createOSProcessHandler";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createTargetRun";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findAllFileTests";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 13, 16, 19 -> new IllegalStateException(string);
        };
    }
}

