/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.formatting.datetime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.formatting.datetime.DateLocale;
import org.jetbrains.letsPlot.commons.formatting.datetime.Pattern;
import org.jetbrains.letsPlot.commons.intern.datetime.Date;
import org.jetbrains.letsPlot.commons.intern.datetime.DateTime;
import org.jetbrains.letsPlot.commons.intern.datetime.Time;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0003\u000f\u0010\u0011B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\b\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\b\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/datetime/DateTimeFormat;", "", "spec", "", "(Ljava/lang/String;)V", "", "Lorg/jetbrains/letsPlot/commons/formatting/datetime/DateTimeFormat$SpecPart;", "(Ljava/util/List;)V", "apply", "date", "Lorg/jetbrains/letsPlot/commons/intern/datetime/Date;", "dateTime", "Lorg/jetbrains/letsPlot/commons/intern/datetime/DateTime;", "time", "Lorg/jetbrains/letsPlot/commons/intern/datetime/Time;", "Companion", "PatternSpecPart", "SpecPart", "commons"})
@SourceDebugExtension(value={"SMAP\nDateTimeFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateTimeFormat.kt\norg/jetbrains/letsPlot/commons/formatting/datetime/DateTimeFormat\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n766#2:131\n857#2,2:132\n766#2:134\n857#2,2:135\n*S KotlinDebug\n*F\n+ 1 DateTimeFormat.kt\norg/jetbrains/letsPlot/commons/formatting/datetime/DateTimeFormat\n*L\n33#1:131\n33#1:132,2\n44#1:134\n44#1:135,2\n*E\n"})
public final class DateTimeFormat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<SpecPart> spec;

    public DateTimeFormat(@NotNull List<? extends SpecPart> spec) {
        Intrinsics.checkNotNullParameter(spec, (String)"spec");
        this.spec = spec;
    }

    public DateTimeFormat(@NotNull String spec) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        this(Companion.parse(spec));
    }

    @NotNull
    public final String apply(@NotNull DateTime dateTime) {
        Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
        return CollectionsKt.joinToString$default((Iterable)this.spec, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<SpecPart, CharSequence>(dateTime){
            final /* synthetic */ DateTime $dateTime;
            {
                this.$dateTime = $dateTime;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull SpecPart it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.exec(this.$dateTime);
            }
        }), (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String apply(@NotNull Date date) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Iterable $this$filter$iv = this.spec;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SpecPart it = (SpecPart)element$iv$iv;
            boolean bl = false;
            boolean bl2 = it instanceof PatternSpecPart && ((PatternSpecPart)it).getPattern().getKind() == Pattern.Companion.Kind.DATE ? true : !(it instanceof PatternSpecPart);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<SpecPart, CharSequence>(date){
            final /* synthetic */ Date $date;
            {
                this.$date = $date;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull SpecPart it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.exec(new DateTime(this.$date, null, 2, null));
            }
        }), (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String apply(@NotNull Time time) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Iterable $this$filter$iv = this.spec;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SpecPart it = (SpecPart)element$iv$iv;
            boolean bl = false;
            boolean bl2 = it instanceof PatternSpecPart && ((PatternSpecPart)it).getPattern().getKind() == Pattern.Companion.Kind.TIME ? true : !(it instanceof PatternSpecPart);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<SpecPart, CharSequence>(time){
            final /* synthetic */ Time $time;
            {
                this.$time = $time;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull SpecPart it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.exec(new DateTime(Date.Companion.getEPOCH(), this.$time));
            }
        }), (int)30, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00042\b\b\u0002\u0010\u0010\u001a\u00020\u0004H\u0002J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/datetime/DateTimeFormat$Companion;", "", "()V", "getHours12", "", "dateTime", "Lorg/jetbrains/letsPlot/commons/intern/datetime/DateTime;", "getHours24", "getMeridian", "", "getValueForPattern", "type", "Lorg/jetbrains/letsPlot/commons/formatting/datetime/Pattern;", "getWeekDayNumber", "leadZero", "value", "length", "parse", "", "Lorg/jetbrains/letsPlot/commons/formatting/datetime/DateTimeFormat$SpecPart;", "str", "commons"})
    @SourceDebugExtension(value={"SMAP\nDateTimeFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateTimeFormat.kt\norg/jetbrains/letsPlot/commons/formatting/datetime/DateTimeFormat$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,130:1\n1313#2,2:131\n*S KotlinDebug\n*F\n+ 1 DateTimeFormat.kt\norg/jetbrains/letsPlot/commons/formatting/datetime/DateTimeFormat$Companion\n*L\n58#1:131,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<SpecPart> parse(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            List result2 = new ArrayList();
            Sequence resultSequence = Regex.findAll$default((Regex)Pattern.Companion.getPATTERN_REGEX(), (CharSequence)str, (int)0, (int)2, null);
            int lastIndex = 0;
            Sequence $this$forEach$iv = resultSequence;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MatchResult it = (MatchResult)element$iv;
                boolean bl = false;
                String value = it.getValue();
                IntRange range = it.getRange();
                int startIndex = range.getFirst();
                int endIndex = range.getLast();
                if (startIndex > 0) {
                    SpecPart spec = new SpecPart(StringsKt.substring((String)str, (IntRange)RangesKt.until((int)lastIndex, (int)startIndex)));
                    result2.add(spec);
                }
                result2.add(new PatternSpecPart(value));
                lastIndex = endIndex + 1;
            }
            if (lastIndex < str.length()) {
                String string = str.substring(lastIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                result2.add(new SpecPart(string));
            }
            return result2;
        }

        private final String getValueForPattern(Pattern type, DateTime dateTime) {
            String string;
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    string = org.jetbrains.letsPlot.commons.formatting.datetime.DateTimeFormat$Companion.leadZero$default(this, dateTime.getSeconds(), 0, 2, null);
                    break;
                }
                case 2: {
                    string = org.jetbrains.letsPlot.commons.formatting.datetime.DateTimeFormat$Companion.leadZero$default(this, dateTime.getMinutes(), 0, 2, null);
                    break;
                }
                case 3: {
                    string = String.valueOf(this.getHours12(dateTime));
                    break;
                }
                case 4: {
                    string = org.jetbrains.letsPlot.commons.formatting.datetime.DateTimeFormat$Companion.leadZero$default(this, this.getHours12(dateTime), 0, 2, null);
                    break;
                }
                case 5: {
                    string = org.jetbrains.letsPlot.commons.formatting.datetime.DateTimeFormat$Companion.leadZero$default(this, this.getHours24(dateTime), 0, 2, null);
                    break;
                }
                case 6: {
                    string = this.getMeridian(dateTime);
                    break;
                }
                case 7: {
                    String string2 = this.getMeridian(dateTime).toUpperCase(Locale.ROOT);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                    break;
                }
                case 8: {
                    string = this.getWeekDayNumber(dateTime);
                    break;
                }
                case 9: {
                    string = DateLocale.INSTANCE.getWeekDayAbbr().get((Object)dateTime.getWeekDay());
                    if (string != null) break;
                    string = "";
                    break;
                }
                case 10: {
                    string = DateLocale.INSTANCE.getWeekDayFull().get((Object)dateTime.getWeekDay());
                    if (string != null) break;
                    string = "";
                    break;
                }
                case 11: {
                    string = String.valueOf(dateTime.getDay());
                    break;
                }
                case 12: {
                    string = org.jetbrains.letsPlot.commons.formatting.datetime.DateTimeFormat$Companion.leadZero$default(this, dateTime.getDay(), 0, 2, null);
                    break;
                }
                case 13: {
                    string = this.leadZero(dateTime.getDate().daysFromYearStart(), 3);
                    break;
                }
                case 14: {
                    string = org.jetbrains.letsPlot.commons.formatting.datetime.DateTimeFormat$Companion.leadZero$default(this, dateTime.getMonth().ordinal() + 1, 0, 2, null);
                    break;
                }
                case 15: {
                    string = DateLocale.INSTANCE.getMonthAbbr().get(dateTime.getMonth());
                    if (string != null) break;
                    string = "";
                    break;
                }
                case 16: {
                    string = DateLocale.INSTANCE.getMonthFull().get(dateTime.getMonth());
                    if (string != null) break;
                    string = "";
                    break;
                }
                case 17: {
                    String string3 = String.valueOf(dateTime.getYear()).substring(2);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    break;
                }
                case 18: {
                    string = String.valueOf(dateTime.getYear());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        private final String leadZero(int value, int length) {
            return StringsKt.padStart((String)String.valueOf(value), (int)length, (char)'0');
        }

        static /* synthetic */ String leadZero$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 2;
            }
            return companion.leadZero(n, n2);
        }

        private final int getHours12(DateTime dateTime) {
            int hours = dateTime.getHours();
            return hours == 0 ? 12 : (hours <= 12 ? hours : hours - 12);
        }

        private final int getHours24(DateTime dateTime) {
            return dateTime.getHours();
        }

        private final String getMeridian(DateTime dateTime) {
            int hours = dateTime.getHours();
            return hours == 24 ? "am" : (hours < 12 ? "am" : "pm");
        }

        private final String getWeekDayNumber(DateTime dateTime) {
            int num = dateTime.getWeekDay().ordinal() + 1;
            if (num == 7) {
                num = 0;
            }
            return String.valueOf(num);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Pattern.values().length];
                try {
                    nArray[Pattern.SECOND.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Pattern.MINUTE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Pattern.HOUR_12.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Pattern.HOUR_12_LEADING_ZERO.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Pattern.HOUR_24.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Pattern.MERIDIAN_LOWER.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Pattern.MERIDIAN_UPPER.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Pattern.DAY_OF_WEEK.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Pattern.DAY_OF_WEEK_ABBR.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Pattern.DAY_OF_WEEK_FULL.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Pattern.DAY_OF_MONTH.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Pattern.DAY_OF_MONTH_LEADING_ZERO.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Pattern.DAY_OF_THE_YEAR.ordinal()] = 13;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Pattern.MONTH.ordinal()] = 14;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Pattern.MONTH_ABBR.ordinal()] = 15;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Pattern.MONTH_FULL.ordinal()] = 16;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Pattern.YEAR_SHORT.ordinal()] = 17;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Pattern.YEAR_FULL.ordinal()] = 18;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/datetime/DateTimeFormat$PatternSpecPart;", "Lorg/jetbrains/letsPlot/commons/formatting/datetime/DateTimeFormat$SpecPart;", "str", "", "(Ljava/lang/String;)V", "pattern", "Lorg/jetbrains/letsPlot/commons/formatting/datetime/Pattern;", "getPattern", "()Lorg/jetbrains/letsPlot/commons/formatting/datetime/Pattern;", "exec", "dateTime", "Lorg/jetbrains/letsPlot/commons/intern/datetime/DateTime;", "commons"})
    public static final class PatternSpecPart
    extends SpecPart {
        @NotNull
        private final Pattern pattern;

        public PatternSpecPart(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            super(str);
            Pattern pattern2 = Pattern.Companion.patternByString(str);
            if (pattern2 == null) {
                throw new IllegalArgumentException("Wrong date-time pattern: '" + str + '\'');
            }
            this.pattern = pattern2;
        }

        @NotNull
        public final Pattern getPattern() {
            return this.pattern;
        }

        @Override
        @NotNull
        public String exec(@NotNull DateTime dateTime) {
            Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
            return Companion.getValueForPattern(this.pattern, dateTime);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/datetime/DateTimeFormat$SpecPart;", "", "str", "", "(Ljava/lang/String;)V", "getStr", "()Ljava/lang/String;", "exec", "dateTime", "Lorg/jetbrains/letsPlot/commons/intern/datetime/DateTime;", "commons"})
    public static class SpecPart {
        @NotNull
        private final String str;

        public SpecPart(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            this.str = str;
        }

        @NotNull
        public final String getStr() {
            return this.str;
        }

        @NotNull
        public String exec(@NotNull DateTime dateTime) {
            Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
            return this.str;
        }
    }
}

