/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm.registry;

import com.google.common.collect.ImmutableList;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryUtil;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.URLUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/nodejs/npm/registry/NpmjsComSearchService;", "", "<init>", "()V", "createSearchQuery", "Lcom/intellij/javascript/nodejs/npm/registry/NpmRegistryService$SearchQuery;", "text", "", "SearchResultsReader", "intellij.javascript.impl"})
public final class NpmjsComSearchService {
    @NotNull
    public static final NpmjsComSearchService INSTANCE = new NpmjsComSearchService();

    private NpmjsComSearchService() {
    }

    @JvmStatic
    @NotNull
    public static final NpmRegistryService.SearchQuery createSearchQuery(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new NpmRegistryService.SearchQuery(text){
            final /* synthetic */ String $text;
            {
                this.$text = $text;
                super($text);
            }

            public String getQueryUrl(int from, int limit) {
                return "https://www.npmjs.com/search/suggestions?q=" + URLUtil.encodeURIComponent((String)this.$text) + "&size=" + (from + limit);
            }

            public int getMaxQueryBatchSize() {
                return 100;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<NodePackageBasicInfo> parseContent(String content) throws IOException {
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                Closeable closeable = (Closeable)new JsonReader((Reader)new StringReader(content));
                Throwable throwable = null;
                try {
                    JsonReader reader = (JsonReader)closeable;
                    boolean bl = false;
                    List<NodePackageBasicInfo> list = new SearchResultsReader(reader).read();
                    return list;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }

            public String toString() {
                return "'" + this.$text + "*' (Prefix)";
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/javascript/nodejs/npm/registry/NpmjsComSearchService$SearchResultsReader;", "", "myReader", "Lcom/google/gson/stream/JsonReader;", "<init>", "(Lcom/google/gson/stream/JsonReader;)V", "myResults", "", "Lcom/intellij/javascript/nodejs/packageJson/NodePackageBasicInfo;", "read", "", "intellij.javascript.impl"})
    private static final class SearchResultsReader {
        @NotNull
        private final JsonReader myReader;
        @NotNull
        private final List<NodePackageBasicInfo> myResults;

        public SearchResultsReader(@NotNull JsonReader myReader) {
            Intrinsics.checkNotNullParameter((Object)myReader, (String)"myReader");
            this.myReader = myReader;
            this.myResults = new ArrayList();
        }

        @NotNull
        public final List<NodePackageBasicInfo> read() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_ARRAY) {
                this.myReader.skipValue();
                ImmutableList immutableList = ImmutableList.of();
                Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(...)");
                return (List)immutableList;
            }
            this.myReader.beginArray();
            while (this.myReader.hasNext()) {
                UtilKt.addIfNotNull(this.myResults, (Object)NpmRegistryUtil.readPackageInfo(this.myReader));
            }
            this.myReader.endArray();
            return CollectionsKt.toList((Iterable)this.myResults);
        }
    }
}

