/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.psi.IndexedData;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeGenericId;
import com.intellij.lang.javascript.psi.types.JSTypeWithGenericParameters;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSClassExpressionType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptIntrinsicJSTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.openapi.util.Key;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t\u001a*\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u001a<\u0010\u0012\u001a\u00020\u00022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\t\"#\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"INDEXED_TYPE_DATA", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/lang/javascript/psi/IndexedData;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "EMPTY_DATA", "indexTypeRecursive", "", "startType", "Lcom/intellij/lang/javascript/psi/JSType;", "isSimpleType", "", "jsType", "unionSets", "", "Lcom/intellij/lang/javascript/psi/types/JSTypeGenericId;", "set1", "set2", "createIndexedData", "generics", "ownGenerics", "unexpandedTypes", "hasApplyingGenerics", "simpleNested", "getTypeIndexedData", "intellij.javascript.psi.impl"})
public final class JSTypeIndexerKt {
    @JvmField
    @NotNull
    public static final Key<IndexedData> INDEXED_TYPE_DATA;
    @NotNull
    private static final IndexedData EMPTY_DATA;

    private static final void indexTypeRecursive(JSType startType) {
        if (JSTypeIndexerKt.isSimpleType(startType)) {
            return;
        }
        JSRecursiveTypeVisitor.Checks checks = JSRecursiveTypeVisitor.Checks.DISABLED;
        startType.accept(new JSRecursiveTypeVisitor(checks){
            private final Deque<IndexedData> stack;
            {
                this.stack = new ArrayDeque<E>();
            }

            public void visitJSType(JSType currentType) {
                Intrinsics.checkNotNullParameter((Object)currentType, (String)"currentType");
                if (JSTypeIndexerKt.isSimpleType(currentType)) {
                    this.updateParent(currentType, JSTypeIndexerKt.access$getEMPTY_DATA$p());
                    return;
                }
                if (this.updateFromData(currentType)) {
                    return;
                }
                Set<JSTypeGenericId> declaredIds = currentType instanceof JSTypeWithGenericParameters ? ((JSTypeWithGenericParameters)((Object)currentType)).getGenericIds() : SetsKt.emptySet();
                Set<T> currentIds = currentType instanceof JSGenericParameterType ? Collections.singleton(((JSGenericParameterType)currentType).getGenericId()) : Collections.emptySet();
                Intrinsics.checkNotNull(currentIds);
                Intrinsics.checkNotNull(declaredIds);
                JSGenericParameterType jSGenericParameterType = currentType instanceof JSGenericParameterType ? (JSGenericParameterType)currentType : null;
                this.stack.addLast(JSTypeIndexerKt.access$createIndexedData(currentIds, declaredIds, currentType instanceof JSCodeBasedType || currentType instanceof TypeScriptGenericThisTypeImpl || currentType instanceof JSClassExpressionType, jSGenericParameterType != null ? jSGenericParameterType.isApplying() : false, true));
                super.visitJSType(currentType);
                IndexedData afterData = this.stack.removeLast();
                Intrinsics.checkNotNull((Object)afterData);
                Set<JSTypeGenericId> toProcess = this.getGenericsToProcess(afterData, declaredIds);
                IndexedData processedData = JSTypeIndexerKt.access$createIndexedData(toProcess, afterData.getDeclaredGenerics(), afterData.getUnexpandedTypes(), afterData.getApplyingGenerics(), afterData.getSimpleNested());
                this.updateParent(currentType, processedData);
                currentType.putUserData(JSTypeIndexerKt.INDEXED_TYPE_DATA, processedData);
            }

            private final Set<JSTypeGenericId> getGenericsToProcess(IndexedData afterData, Set<? extends JSTypeGenericId> ignoredIds) {
                Set<JSTypeGenericId> generics = afterData.getGenerics();
                if (generics.isEmpty()) {
                    return SetsKt.emptySet();
                }
                HashSet<E> toProcess = new HashSet<E>();
                toProcess.addAll(generics);
                toProcess.removeAll((Collection)ignoredIds);
                return toProcess;
            }

            private final boolean updateFromData(JSType currentType) {
                IndexedData data2 = (IndexedData)currentType.getUserData(JSTypeIndexerKt.INDEXED_TYPE_DATA);
                if (data2 != null) {
                    this.updateParent(currentType, data2);
                    return true;
                }
                return false;
            }

            private final void updateParent(JSType currentType, IndexedData data2) {
                IndexedData parent = this.stack.peekLast();
                if (parent != null) {
                    this.stack.removeLast();
                    Set generics = JSTypeIndexerKt.access$unionSets(parent.getGenerics(), data2.getGenerics());
                    Set ownGenerics = JSTypeIndexerKt.access$unionSets(parent.getDeclaredGenerics(), data2.getDeclaredGenerics());
                    boolean unexpandedTypes = parent.getUnexpandedTypes() || data2.getUnexpandedTypes();
                    boolean hasApplyingGenerics = parent.getApplyingGenerics() || data2.getApplyingGenerics();
                    boolean simpleNested = parent.getSimpleNested() && JSTypeIndexerKt.isSimpleType(currentType);
                    this.stack.addLast(JSTypeIndexerKt.access$createIndexedData(generics, ownGenerics, unexpandedTypes, hasApplyingGenerics, simpleNested));
                }
            }
        });
    }

    public static final boolean isSimpleType(@NotNull JSType jsType) {
        Intrinsics.checkNotNullParameter((Object)jsType, (String)"jsType");
        return jsType instanceof JSNamedType || jsType instanceof JSNullType || jsType instanceof JSUndefinedType || jsType instanceof JSAnyType || jsType instanceof JSVoidType || jsType instanceof TypeScriptIntrinsicJSTypeImpl || jsType instanceof TypeScriptNeverType;
    }

    private static final Set<JSTypeGenericId> unionSets(Set<? extends JSTypeGenericId> set1, Set<? extends JSTypeGenericId> set2) {
        if (set1.isEmpty()) {
            return set2;
        }
        if (set2.isEmpty()) {
            return set1;
        }
        HashSet set = new HashSet(set1.size() + set2.size());
        set.addAll(set1);
        set.addAll(set2);
        return set;
    }

    private static final IndexedData createIndexedData(Set<? extends JSTypeGenericId> generics, Set<? extends JSTypeGenericId> ownGenerics, boolean unexpandedTypes, boolean hasApplyingGenerics, boolean simpleNested) {
        return generics.isEmpty() && ownGenerics.isEmpty() && !unexpandedTypes && !hasApplyingGenerics && simpleNested ? EMPTY_DATA : new IndexedData(generics, ownGenerics, unexpandedTypes, hasApplyingGenerics, simpleNested);
    }

    @NotNull
    public static final IndexedData getTypeIndexedData(@Nullable JSType startType) {
        IndexedData indexedData;
        if (startType == null || JSTypeIndexerKt.isSimpleType(startType)) {
            return EMPTY_DATA;
        }
        IndexedData data2 = (IndexedData)startType.getUserData(INDEXED_TYPE_DATA);
        if (data2 == null) {
            JSTypeIndexerKt.indexTypeRecursive(startType);
        }
        if ((indexedData = (data2 = (IndexedData)startType.getUserData(INDEXED_TYPE_DATA))) == null) {
            indexedData = EMPTY_DATA;
        }
        return indexedData;
    }

    public static final /* synthetic */ IndexedData access$getEMPTY_DATA$p() {
        return EMPTY_DATA;
    }

    public static final /* synthetic */ IndexedData access$createIndexedData(Set generics, Set ownGenerics, boolean unexpandedTypes, boolean hasApplyingGenerics, boolean simpleNested) {
        return JSTypeIndexerKt.createIndexedData(generics, ownGenerics, unexpandedTypes, hasApplyingGenerics, simpleNested);
    }

    public static final /* synthetic */ Set access$unionSets(Set set1, Set set2) {
        return JSTypeIndexerKt.unionSets(set1, set2);
    }

    static {
        Key key = Key.create((String)"nested.index.info");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        INDEXED_TYPE_DATA = key;
        EMPTY_DATA = new IndexedData(null, null, false, false, false, 31, null);
    }
}

