/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSTextReferenceResolver;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSGenericsIndex;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSDocReferenceResolver
extends JSTextReferenceResolver {
    private final boolean myIsMethodRef;

    public JSDocReferenceResolver(@NotNull PsiElement ref2, boolean isPrimary, boolean isMethodRef) {
        if (ref2 == null) {
            JSDocReferenceResolver.$$$reportNull$$$0(0);
        }
        super(ref2, isPrimary);
        this.myIsMethodRef = isMethodRef;
    }

    @Override
    public void processLocalVariants(@NotNull SinkResolveProcessor<?> processor) {
        if (processor == null) {
            JSDocReferenceResolver.$$$reportNull$$$0(1);
        }
        PsiFile file = this.myRef.getContainingFile();
        JSDocComment docComment = (JSDocComment)PsiTreeUtil.getContextOfType((PsiElement)this.myRef, (Class[])new Class[]{JSDocComment.class});
        if (docComment != null) {
            @NotNull List<Pair<@NotNull String, @Nullable String>> currentParameters = docComment.getGenericParameters();
            if (!currentParameters.isEmpty()) {
                JSDocReferenceResolver.processGenericParameters(currentParameters, docComment, processor);
            } else {
                List<Pair<String, String>> parameters2;
                JSDocComment definitionComment;
                JSQualifiedNamedElement element2;
                JSQualifiedName namespace;
                PsiElement psiElement = JSStubBasedPsiTreeUtil.findAssociatedElement(docComment);
                if (psiElement instanceof JSQualifiedNamedElement && (namespace = (element2 = (JSQualifiedNamedElement)psiElement).getNamespace()) != null && (definitionComment = JSGenericsIndex.findGenericParametersComment(namespace.getQualifiedName(), GlobalSearchScope.fileScope((PsiFile)file))) != null && !(parameters2 = definitionComment.getGenericParameters()).isEmpty()) {
                    JSDocReferenceResolver.processGenericParameters(parameters2, definitionComment, processor);
                }
            }
        }
        if (this.myIsMethodRef && docComment != null) {
            PsiElement next = JSDocumentationUtils.findAttachedElementFromComment(docComment);
            if (next instanceof JSProperty) {
                JSResolveUtil.treeWalkUp(processor, this.myRef, this.myRef, next);
            }
        } else {
            this.doProcessLocalVariants(processor, (Condition<? super PsiElement>)((Condition)element -> true));
        }
    }

    private static void processGenericParameters(@NotNull List<Pair<String, String>> parameters2, @NotNull JSDocComment comment, @NotNull SinkResolveProcessor<?> processor) {
        if (parameters2 == null) {
            JSDocReferenceResolver.$$$reportNull$$$0(2);
        }
        if (comment == null) {
            JSDocReferenceResolver.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            JSDocReferenceResolver.$$$reportNull$$$0(4);
        }
        for (Pair<String, String> parameter : parameters2) {
            JSImplicitElementImpl element = new JSImplicitElementImpl.Builder((String)parameter.getFirst(), (PsiElement)comment).setJSType(JSTypeParser.createTypeFromJSDoc(comment.getProject(), (String)parameter.getSecond(), JSTypeSource.EMPTY)).toImplicitElement();
            processor.execute((PsiElement)element, ResolveState.initial());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocReferenceResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processLocalVariants";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processGenericParameters";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

