/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.endpoints;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.EndpointsUrlTargetProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlQueryParameter;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.python.endpoints.CommonKt;
import com.intellij.python.endpoints.HttpRouterProvider;
import com.intellij.python.endpoints.ModuleWebStructure;
import com.intellij.python.endpoints.ProjectWebStructureKt;
import com.intellij.python.endpoints.RenderedEndpoint;
import com.intellij.python.endpoints.WebApplication;
import com.intellij.python.endpoints.WebApplicationEndpointsFilter;
import com.jetbrains.python.PythonLanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u0000 )2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001)B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u00172\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\u001a\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\u0018\u0010'\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0003H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006*"}, d2={"Lcom/intellij/python/endpoints/WebApplicationEndpointsProvider;", "Lcom/intellij/microservices/endpoints/EndpointsUrlTargetProvider;", "Lcom/intellij/python/endpoints/WebApplication;", "Lcom/intellij/python/endpoints/RenderedEndpoint;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "httpRouterProvider", "Lcom/intellij/python/endpoints/HttpRouterProvider;", "<init>", "(Lcom/intellij/microservices/endpoints/FrameworkPresentation;Lcom/intellij/python/endpoints/HttpRouterProvider;)V", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getHttpRouterProvider", "()Lcom/intellij/python/endpoints/HttpRouterProvider;", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "project", "Lcom/intellij/openapi/project/Project;", "getEndpointGroups", "", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getEndpoints", "group", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "endpoint", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getDocumentationElement", "Lcom/intellij/psi/PsiElement;", "getNavigationElement", "getUrlTargetInfo", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "isValidEndpoint", "", "Companion", "intellij.python.endpoints"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nWebApplicationEndpointsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebApplicationEndpointsProvider.kt\ncom/intellij/python/endpoints/WebApplicationEndpointsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n774#2:99\n865#2,2:100\n1755#2,3:102\n1755#2,3:105\n*S KotlinDebug\n*F\n+ 1 WebApplicationEndpointsProvider.kt\ncom/intellij/python/endpoints/WebApplicationEndpointsProvider\n*L\n43#1:99\n43#1:100,2\n54#1:102,3\n55#1:105,3\n*E\n"})
public class WebApplicationEndpointsProvider
implements EndpointsUrlTargetProvider<WebApplication, RenderedEndpoint> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FrameworkPresentation presentation;
    @NotNull
    private final HttpRouterProvider httpRouterProvider;
    @NotNull
    private static final Set<String> READ_METHODS;
    @NotNull
    private static final Set<String> WRITE_METHOD;

    public WebApplicationEndpointsProvider(@NotNull FrameworkPresentation presentation, @NotNull HttpRouterProvider httpRouterProvider) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)httpRouterProvider, (String)"httpRouterProvider");
        this.presentation = presentation;
        this.httpRouterProvider = httpRouterProvider;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    public final HttpRouterProvider getHttpRouterProvider() {
        return this.httpRouterProvider;
    }

    @NotNull
    public EndpointType getEndpointType() {
        return EndpointTypes.HTTP_SERVER_TYPE;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.httpRouterProvider.isActive(project) ? EndpointsProvider.Status.HAS_ENDPOINTS : EndpointsProvider.Status.AVAILABLE;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<WebApplication> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        EndpointsFilter endpointsFilter = filter;
        if (endpointsFilter instanceof WebApplicationEndpointsFilter) {
            WebApplication application = ((WebApplicationEndpointsFilter)filter).getWebApplication();
            list = application.getProvider() == this.httpRouterProvider ? CollectionsKt.listOf((Object)application) : CollectionsKt.emptyList();
        } else if (endpointsFilter instanceof ModuleEndpointsFilter) {
            ModuleWebStructure webStructure = ProjectWebStructureKt.getModuleWebStructure(((ModuleEndpointsFilter)filter).getModule());
            Object object = webStructure;
            if (object != null && (object = ((ModuleWebStructure)object).getWebApplications()) != null) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = (Iterable)object;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    WebApplication it = (WebApplication)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getProvider() == this.httpRouterProvider)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public Iterable<RenderedEndpoint> getEndpoints(@NotNull WebApplication group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        return group.getEndpoints();
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull WebApplication group, @NotNull RenderedEndpoint endpoint) {
        VirtualFile virtualFile;
        boolean bl;
        boolean hasReadAction;
        block7: {
            boolean bl2;
            block6: {
                Intrinsics.checkNotNullParameter((Object)group, (String)"group");
                Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
                Iterable $this$any$iv = endpoint.getMethods();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!READ_METHODS.contains(it)) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
            }
            hasReadAction = bl2;
            Iterable $this$any$iv = endpoint.getMethods();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl4 = false;
                    if (!WRITE_METHOD.contains(it)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        boolean hasWriteAction = bl;
        Icon icon = hasReadAction && hasWriteAction ? AllIcons.Nodes.RwAccess : (hasReadAction ? AllIcons.Nodes.ReadAccess : (hasWriteAction ? AllIcons.Nodes.WriteAccess : AllIcons.Nodes.Unknown));
        Intrinsics.checkNotNull((Object)icon);
        Icon icon2 = icon;
        return (ItemPresentation)new HttpMethodPresentation(CommonKt.toStringWithLeadingSlash(endpoint.getPath()), endpoint.getHttpMethods(), (virtualFile = endpoint.getNavigationPointer()) != null && (virtualFile = virtualFile.getVirtualFile()) != null ? virtualFile.getName() : null, icon2, null, 16, null);
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ModificationTracker modificationTracker = PsiManager.getInstance((Project)project).getModificationTracker().forLanguage((Language)PythonLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)modificationTracker, (String)"forLanguage(...)");
        return modificationTracker;
    }

    @Nullable
    public PsiElement getDocumentationElement(@NotNull WebApplication group, @NotNull RenderedEndpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint.getDocumentationPsiElement();
    }

    @Nullable
    public PsiElement getNavigationElement(@NotNull WebApplication group, @NotNull RenderedEndpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint.resolveToPsiElement();
    }

    @NotNull
    public List<UrlTargetInfo> getUrlTargetInfo(@NotNull WebApplication group, @NotNull RenderedEndpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return CollectionsKt.listOf((Object)new UrlTargetInfo(endpoint){
            private final /* synthetic */ RenderedEndpoint $$delegate_0;
            private final UrlPath path;
            {
                this.$$delegate_0 = $endpoint;
                this.path = new UrlPath($endpoint.getPath().getSegments());
            }

            public UrlPath getPath() {
                return this.path;
            }

            public PsiElement resolveToPsiElement() {
                return this.$$delegate_0.resolveToPsiElement();
            }

            public List<String> getSchemes() {
                return this.$$delegate_0.getSchemes();
            }

            public List<Authority> getAuthorities() {
                return this.$$delegate_0.getAuthorities();
            }

            public Icon getIcon() {
                return this.$$delegate_0.getIcon();
            }

            public boolean isDeprecated() {
                return this.$$delegate_0.isDeprecated();
            }

            public Set<String> getMethods() {
                return this.$$delegate_0.getMethods();
            }

            public String getSource() {
                return this.$$delegate_0.getSource();
            }

            public PsiElement getDocumentationPsiElement() {
                return this.$$delegate_0.getDocumentationPsiElement();
            }

            public Iterable<UrlQueryParameter> getQueryParameters() {
                return this.$$delegate_0.getQueryParameters();
            }

            public Set<String> getContentTypes() {
                return this.$$delegate_0.getContentTypes();
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValidEndpoint(@NotNull WebApplication group, @NotNull RenderedEndpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        PsiElement psiElement = endpoint.getNavigationPointer();
        PsiElement psiElement2 = psiElement;
        if (psiElement == null) return false;
        PsiElement psiElement3 = psiElement2.getElement();
        psiElement2 = psiElement3;
        if (psiElement3 == null) return false;
        if (!psiElement2.isValid()) return false;
        boolean bl = true;
        if (!bl) return false;
        PsiElement psiElement4 = endpoint.getDocumentationPointer();
        PsiElement psiElement5 = psiElement4;
        if (psiElement4 == null) return false;
        PsiElement psiElement6 = psiElement5.getElement();
        psiElement5 = psiElement6;
        if (psiElement6 == null) return false;
        if (!psiElement5.isValid()) return false;
        return true;
    }

    static {
        Object[] objectArray = new String[]{"GET", "HEAD", "OPTIONS", "TRACE"};
        READ_METHODS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"POST", "PATCH", "PUT", "DELETE"};
        WRITE_METHOD = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/python/endpoints/WebApplicationEndpointsProvider$Companion;", "", "<init>", "()V", "READ_METHODS", "", "", "getREAD_METHODS", "()Ljava/util/Set;", "WRITE_METHOD", "getWRITE_METHOD", "intellij.python.endpoints"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getREAD_METHODS() {
            return READ_METHODS;
        }

        @NotNull
        public final Set<String> getWRITE_METHOD() {
            return WRITE_METHOD;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

