/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.gherkin.matchers;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.python.gherkin.PyStepDefinition;
import com.intellij.python.gherkin.matchers.PyBDDProcessor;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ParseProcessor
implements PyBDDProcessor {
    static final ParseProcessor INSTANCE = new ParseProcessor();
    private static final Pattern PARSE_PATTERN = Pattern.compile("\\{([a-zA-Z0-9_.-]*)(?::([a-zA-Z%]+))?\\}");
    @NotNull
    private static final Set<String> SUPPORTED_GROUPS = Set.of("w", "s", "d");
    @NotNull
    private static final Map<String, String> TYPE_TO_REGEXP = new HashMap<String, String>();
    private static final Map<String, String> PARSE_TYPES_TO_PYTHON;

    private ParseProcessor() {
    }

    @Override
    @NotNull
    public Map<String, PyType> getParamTypes(@NotNull PyStepDefinition definition, @NotNull TypeEvalContext context, @NotNull Map<String, ? extends PyType> extraParamTypes) {
        PsiElement element;
        if (definition == null) {
            ParseProcessor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ParseProcessor.$$$reportNull$$$0(1);
        }
        if (extraParamTypes == null) {
            ParseProcessor.$$$reportNull$$$0(2);
        }
        if ((element = definition.getElement()) == null) {
            Map<String, PyType> map = Collections.emptyMap();
            if (map == null) {
                ParseProcessor.$$$reportNull$$$0(3);
            }
            return map;
        }
        String definitionRegex = definition.getAsString(context);
        if (definitionRegex == null) {
            Map<String, PyType> map = Collections.emptyMap();
            if (map == null) {
                ParseProcessor.$$$reportNull$$$0(4);
            }
            return map;
        }
        Map map = (Map)ParseProcessor.getParseResult(element, definitionRegex, extraParamTypes, true).getFirst();
        if (map == null) {
            ParseProcessor.$$$reportNull$$$0(5);
        }
        return map;
    }

    @Override
    @Nullable
    public String getPythonRegexp(@NotNull PyStepDefinition definition, @NotNull TypeEvalContext context) {
        PsiElement element;
        if (definition == null) {
            ParseProcessor.$$$reportNull$$$0(6);
        }
        if (context == null) {
            ParseProcessor.$$$reportNull$$$0(7);
        }
        if ((element = definition.getElement()) == null) {
            return null;
        }
        String definitionRegex = definition.getAsString(context);
        if (definitionRegex == null) {
            return null;
        }
        return (String)ParseProcessor.getParseResult(element, definitionRegex, null, false).getSecond();
    }

    @NotNull
    static Pair<Map<String, PyType>, String> getParseResult(@Nullable PsiElement anchor, @NotNull String definition, @Nullable Map<String, ? extends PyType> typeMap, boolean processTypes) {
        if (definition == null) {
            ParseProcessor.$$$reportNull$$$0(8);
        }
        assert (processTypes == (typeMap != null)) : "Map must be set if processTypes=true, not set otherwise ";
        Matcher matcher = PARSE_PATTERN.matcher(StringUtil.escapeChars((String)definition, (char[])new char[]{'[', '(', ')', ']', '.'}));
        StringBuilder builder = new StringBuilder().append('^');
        HashMap<String, PyType> types = new HashMap<String, PyType>();
        while (matcher.find()) {
            String argumentName = matcher.group(1);
            String argumentType = matcher.group(2);
            PyType type = null;
            if (processTypes) {
                String pythonType;
                if (typeMap.containsKey(argumentType)) {
                    type = typeMap.get(argumentType);
                }
                if (type == null && (pythonType = PARSE_TYPES_TO_PYTHON.get(argumentType)) != null) {
                    type = PyTypeParser.getTypeByName((PsiElement)anchor, (String)pythonType);
                }
            }
            Object argumentTypeRegex = ".";
            if (!StringUtil.isEmpty((String)argumentType)) {
                if (SUPPORTED_GROUPS.contains(argumentType.toLowerCase(Locale.getDefault()))) {
                    argumentTypeRegex = "\\\\" + argumentType;
                } else if (TYPE_TO_REGEXP.containsKey(argumentType)) {
                    argumentTypeRegex = TYPE_TO_REGEXP.get(argumentType);
                }
            }
            if (processTypes && type != null) {
                types.put(argumentName, type);
            }
            String regexp = StringUtil.isEmpty((String)argumentName) ? String.format("(%s+)", argumentTypeRegex) : String.format("(?P<%s>%s+)", argumentName, argumentTypeRegex);
            matcher.appendReplacement(builder, regexp);
        }
        matcher.appendTail(builder);
        Pair pair = Pair.create(types, (Object)builder.append('$').toString());
        if (pair == null) {
            ParseProcessor.$$$reportNull$$$0(9);
        }
        return pair;
    }

    static {
        TYPE_TO_REGEXP.put("b", "[10]");
        TYPE_TO_REGEXP.put("o", "[0-9A-Fa-f]");
        PARSE_TYPES_TO_PYTHON = new HashMap<String, String>((Map<String, String>)ImmutableMap.builder().put((Object)"w", (Object)"str").put((Object)"W", (Object)"str").put((Object)"s", (Object)"str").put((Object)"S", (Object)"str").put((Object)"d", (Object)"int").put((Object)"D", (Object)"str").put((Object)"n", (Object)"int").put((Object)"%", (Object)"float").put((Object)"f", (Object)"float").put((Object)"F", (Object)"Decimal").put((Object)"e", (Object)"float").put((Object)"g", (Object)"float").put((Object)"b", (Object)"int").put((Object)"o", (Object)"int").put((Object)"x", (Object)"int").put((Object)"ti", (Object)"datetime").put((Object)"te", (Object)"datetime").put((Object)"tg", (Object)"datetime").put((Object)"ta", (Object)"datetime").put((Object)"tc", (Object)"datetime").put((Object)"th", (Object)"datetime").put((Object)"ts", (Object)"datetime").put((Object)"tt", (Object)"time").build());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraParamTypes";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/gherkin/matchers/ParseProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/gherkin/matchers/ParseProcessor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamTypes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getParseResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getParamTypes";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPythonRegexp";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParseResult";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 9 -> new IllegalStateException(string);
        };
    }
}

