/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter.add;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.python.remoteInterpreter.PythonRemoteInterpreterBundle;
import com.intellij.python.remoteInterpreter.add.RemoteSdkCreationUtilKt;
import com.intellij.python.remoteInterpreter.add.SshSdkCreationUtilKt;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.VagrantSupport;
import com.intellij.ui.StatusPanel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.Consumer;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.plugins.remotesdk.VagrantCredentialsType;
import com.jetbrains.plugins.remotesdk.ui.RemoteBrowseActionListener;
import com.jetbrains.plugins.remotesdk.ui.VagrantCredentialsEditor;
import com.jetbrains.python.icons.PythonIcons;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import java.awt.BorderLayout;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0019\u001a\u00020\u0006H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/python/remoteInterpreter/add/PyAddVagrantSdkPanel;", "Lcom/jetbrains/python/sdk/add/PyAddSdkPanel;", "project", "Lcom/intellij/openapi/project/Project;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "vagrantSupport", "Lcom/intellij/remote/VagrantSupport;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/remote/VagrantSupport;)V", "panelName", "", "getPanelName", "()Ljava/lang/String;", "statusPanel", "Lcom/intellij/ui/StatusPanel;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "credentialsEditor", "Lcom/jetbrains/plugins/remotesdk/ui/VagrantCredentialsEditor;", "interpreterPathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "getOrCreateSdk", "onSelected", "", "computeRemoteCredentials", "Lcom/intellij/remote/RemoteCredentials;", "intellij.python.remoteInterpreter"})
@SourceDebugExtension(value={"SMAP\nPyAddVagrantSdkPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyAddVagrantSdkPanel.kt\ncom/intellij/python/remoteInterpreter/add/PyAddVagrantSdkPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public final class PyAddVagrantSdkPanel
extends PyAddSdkPanel {
    @Nullable
    private final Project project;
    @NotNull
    private final List<Sdk> existingSdks;
    @NotNull
    private final VagrantSupport vagrantSupport;
    @NotNull
    private final StatusPanel statusPanel;
    @NotNull
    private final Icon icon;
    @NotNull
    private final VagrantCredentialsEditor credentialsEditor;
    @NotNull
    private final TextFieldWithBrowseButton interpreterPathField;

    public PyAddVagrantSdkPanel(@Nullable Project project, @NotNull List<? extends Sdk> existingSdks, @NotNull VagrantSupport vagrantSupport) {
        Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
        Intrinsics.checkNotNullParameter((Object)vagrantSupport, (String)"vagrantSupport");
        this.project = project;
        this.existingSdks = existingSdks;
        this.vagrantSupport = vagrantSupport;
        this.statusPanel = new StatusPanel();
        Icon icon = PythonIcons.Python.Vagrant;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Vagrant");
        this.icon = icon;
        this.credentialsEditor = new VagrantCredentialsEditor(this.vagrantSupport, this.project, this.statusPanel);
        this.interpreterPathField = new TextFieldWithBrowseButton((JTextField)new JBTextField("/usr/bin/python"));
        this.setLayout(new BorderLayout());
        JBLabel interpreterPathLabel = new JBLabel(PythonRemoteInterpreterBundle.message("python.interpreter.path", new Object[0]));
        FormBuilder form = new FormBuilder().addComponent((JComponent)this.credentialsEditor.getPanel()).addLabeledComponent((JComponent)interpreterPathLabel, (JComponent)this.interpreterPathField).addComponent((JComponent)this.statusPanel);
        this.credentialsEditor.setAnchor((JComponent)interpreterPathLabel);
        RemoteBrowseActionListener.addShowBrowseRemoteDialogAction((TextFieldWithBrowseButton)this.interpreterPathField, (String)PythonRemoteInterpreterBundle.message("python.add.sdk.panel.vagrant.select.python.interpreter", new Object[0]), arg_0 -> PyAddVagrantSdkPanel._init_$lambda$1(this, arg_0));
        this.add(form.getPanel(), "North");
    }

    @NotNull
    public String getPanelName() {
        String string = PythonRemoteInterpreterBundle.message("python.add.sdk.panel.name.vagrant", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    public Sdk getOrCreateSdk() {
        PyRemoteSdkAdditionalData sdkAdditionalData = new PyRemoteSdkAdditionalData(this.interpreterPathField.getText(), false);
        VagrantBasedCredentialsHolder credentials = new VagrantBasedCredentialsHolder();
        VagrantBasedCredentialsHolder sourceCredentials = this.credentialsEditor.getVagrantCredentials();
        if (sourceCredentials != null) {
            credentials.setVagrantFolder(sourceCredentials.getVagrantFolder());
            credentials.setMachineName(sourceCredentials.getMachineName());
        }
        sdkAdditionalData.setCredentials(VagrantCredentialsType.Companion.getInstance().getCredentialsKey(), (Object)credentials);
        SshSdkCreationUtilKt.initializeHelpersPath(this.project, sdkAdditionalData);
        return RemoteSdkCreationUtilKt.createAndInitRemoteSdk$default(null, sdkAdditionalData, this.existingSdks, null, 9, null);
    }

    public void onSelected() {
        this.credentialsEditor.onSelected();
    }

    private final RemoteCredentials computeRemoteCredentials() {
        RemoteCredentials remoteCredentials;
        VagrantBasedCredentialsHolder vagrantBasedCredentialsHolder = this.credentialsEditor.getVagrantCredentials();
        if (vagrantBasedCredentialsHolder != null) {
            VagrantBasedCredentialsHolder it = vagrantBasedCredentialsHolder;
            boolean bl = false;
            remoteCredentials = this.vagrantSupport.getCredentials(it.getVagrantFolder(), it.getMachineName());
        } else {
            remoteCredentials = null;
        }
        return remoteCredentials;
    }

    private static final void _init_$lambda$1(PyAddVagrantSdkPanel this$0, Consumer consumer) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
            RemoteCredentials remoteCredentials = this$0.computeRemoteCredentials();
            if (remoteCredentials == null) break block0;
            RemoteCredentials it = remoteCredentials;
            boolean bl = false;
            consumer.consume((Object)it);
        }
    }
}

