/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.partial;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.thrift.TBase;
import org.apache.thrift.TEnum;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.partial.EnumCache;
import org.apache.thrift.partial.ThriftFieldValueProcessor;
import org.apache.thrift.partial.ThriftMetadata;

public class ThriftStructProcessor
implements ThriftFieldValueProcessor<TBase> {
    private static final EnumCache enums = new EnumCache();

    @Override
    public Object createNewStruct(ThriftMetadata.ThriftStruct metadata) {
        return metadata.createNewStruct();
    }

    @Override
    public TBase prepareStruct(Object instance) {
        return (TBase)instance;
    }

    @Override
    public Object createNewList(int expectedSize) {
        return new Object[expectedSize];
    }

    @Override
    public void setListElement(Object instance, int index, Object value2) {
        ((Object[])instance)[index] = value2;
    }

    @Override
    public Object prepareList(Object instance) {
        return Arrays.asList((Object[])instance);
    }

    @Override
    public Object createNewMap(int expectedSize) {
        return new HashMap(expectedSize);
    }

    @Override
    public void setMapElement(Object instance, int index, Object key, Object value2) {
        ((HashMap)instance).put(key, value2);
    }

    @Override
    public Object prepareMap(Object instance) {
        return instance;
    }

    @Override
    public Object createNewSet(int expectedSize) {
        return new HashSet(expectedSize);
    }

    @Override
    public void setSetElement(Object instance, int index, Object value2) {
        ((HashSet)instance).add(value2);
    }

    @Override
    public Object prepareSet(Object instance) {
        return instance;
    }

    @Override
    public Object prepareEnum(Class<? extends TEnum> enumClass, int ordinal) {
        return enums.get(enumClass, ordinal);
    }

    @Override
    public Object prepareString(ByteBuffer buffer) {
        return ThriftStructProcessor.byteBufferToString(buffer);
    }

    @Override
    public Object prepareBinary(ByteBuffer buffer) {
        return buffer;
    }

    @Override
    public void setBool(TBase valueCollection, TFieldIdEnum fieldId, boolean value2) {
        valueCollection.setFieldValue(fieldId, value2);
    }

    @Override
    public void setByte(TBase valueCollection, TFieldIdEnum fieldId, byte value2) {
        valueCollection.setFieldValue(fieldId, value2);
    }

    @Override
    public void setInt16(TBase valueCollection, TFieldIdEnum fieldId, short value2) {
        valueCollection.setFieldValue(fieldId, value2);
    }

    @Override
    public void setInt32(TBase valueCollection, TFieldIdEnum fieldId, int value2) {
        valueCollection.setFieldValue(fieldId, value2);
    }

    @Override
    public void setInt64(TBase valueCollection, TFieldIdEnum fieldId, long value2) {
        valueCollection.setFieldValue(fieldId, value2);
    }

    @Override
    public void setDouble(TBase valueCollection, TFieldIdEnum fieldId, double value2) {
        valueCollection.setFieldValue(fieldId, value2);
    }

    @Override
    public void setBinary(TBase valueCollection, TFieldIdEnum fieldId, ByteBuffer value2) {
        valueCollection.setFieldValue(fieldId, value2);
    }

    @Override
    public void setString(TBase valueCollection, TFieldIdEnum fieldId, ByteBuffer buffer) {
        String value2 = ThriftStructProcessor.byteBufferToString(buffer);
        valueCollection.setFieldValue(fieldId, value2);
    }

    @Override
    public void setEnumField(TBase valueCollection, TFieldIdEnum fieldId, Object value2) {
        valueCollection.setFieldValue(fieldId, value2);
    }

    @Override
    public void setListField(TBase valueCollection, TFieldIdEnum fieldId, Object value2) {
        valueCollection.setFieldValue(fieldId, value2);
    }

    @Override
    public void setMapField(TBase valueCollection, TFieldIdEnum fieldId, Object value2) {
        valueCollection.setFieldValue(fieldId, value2);
    }

    @Override
    public void setSetField(TBase valueCollection, TFieldIdEnum fieldId, Object value2) {
        valueCollection.setFieldValue(fieldId, value2);
    }

    @Override
    public void setStructField(TBase valueCollection, TFieldIdEnum fieldId, Object value2) {
        valueCollection.setFieldValue(fieldId, value2);
    }

    private static String byteBufferToString(ByteBuffer buffer) {
        byte[] bytes = buffer.array();
        int pos = buffer.position();
        return new String(bytes, pos, buffer.limit() - pos, StandardCharsets.UTF_8);
    }
}

