/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbt.run;

import com.intellij.dbt.run.DbtRunConfiguration;
import com.intellij.dbt.run.producer.DbtBaseRunConfigurationProducer;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistryImpl;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\f"}, d2={"Lcom/intellij/dbt/run/DbtBaseRunModelAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getRunConfigurationProducer", "Lcom/intellij/dbt/run/producer/DbtBaseRunConfigurationProducer;", "intellij.dbt"})
public abstract class DbtBaseRunModelAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (file == null) {
            return;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        ConfigurationContext configurationContext = ConfigurationContext.getFromContext((DataContext)e.getDataContext(), (String)e.getPlace());
        Intrinsics.checkNotNullExpressionValue((Object)configurationContext, (String)"getFromContext(...)");
        ConfigurationContext context = configurationContext;
        DbtBaseRunConfigurationProducer configProducer = this.getRunConfigurationProducer();
        RunnerAndConfigurationSettings configurationSettings = configProducer.findExistingConfiguration(context);
        DbtRunConfiguration runConfiguration = null;
        if (configurationSettings == null) {
            ConfigurationFromContext configurationFromContext = configProducer.createConfigurationFromContext(context);
            if (configurationFromContext == null) {
                return;
            }
            ConfigurationFromContext configurationFromContext2 = configurationFromContext;
            configurationSettings = configurationFromContext2.getConfigurationSettings();
            RunConfiguration runConfiguration2 = configurationFromContext2.getConfiguration();
            DbtRunConfiguration dbtRunConfiguration = runConfiguration2 instanceof DbtRunConfiguration ? (DbtRunConfiguration)runConfiguration2 : null;
            if (dbtRunConfiguration == null) {
                return;
            }
            runConfiguration = dbtRunConfiguration;
            runManager = RunManager.Companion.getInstance(project2);
            runManager.addConfiguration(configurationSettings);
            runManager.setSelectedConfiguration(configurationFromContext2.getConfigurationSettings());
        } else {
            runManager = configurationSettings.getConfiguration();
            DbtRunConfiguration dbtRunConfiguration = runManager instanceof DbtRunConfiguration ? (DbtRunConfiguration)runManager : null;
            if (dbtRunConfiguration == null) {
                return;
            }
            runConfiguration = dbtRunConfiguration;
        }
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getRunExecutorInstance(...)");
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.Companion.createOrNull(executor, (RunConfiguration)runConfiguration);
        if (builder != null) {
            Executor executor2 = DefaultRunExecutor.getRunExecutorInstance();
            ExecutorRegistryImpl.RunnerHelper.run((Project)project2, (RunConfiguration)((RunConfiguration)runConfiguration), (RunnerAndConfigurationSettings)configurationSettings, (DataContext)e.getDataContext(), (Executor)executor2);
        }
    }

    @NotNull
    public abstract DbtBaseRunConfigurationProducer getRunConfigurationProducer();
}

