/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.dashboard;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.StopAction;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.dashboard.RunDashboardGroup;
import com.intellij.execution.dashboard.RunDashboardGroupingRule;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardNode;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.actions.ExecutorAction;
import com.intellij.execution.dashboard.actions.RunDashboardGroupNode;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.FakeRerunAction;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewDnDDescriptor;
import com.intellij.execution.services.ServiceViewGroupingContributor;
import com.intellij.execution.services.ServiceViewLocatableDescriptor;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewProvidingContributor;
import com.intellij.execution.services.ServiceViewToolWindowDescriptor;
import com.intellij.execution.services.SimpleServiceViewDescriptor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.execution.dashboard.RunDashboardComponentWrapper;
import com.intellij.platform.execution.dashboard.RunDashboardManagerImpl;
import com.intellij.platform.execution.dashboard.RunDashboardServiceViewDeleteProvider;
import com.intellij.platform.execution.dashboard.RunDashboardTypePanel;
import com.intellij.platform.execution.dashboard.actions.RunDashboardDoubleClickRunAction;
import com.intellij.platform.execution.dashboard.tree.FolderDashboardGroupingRule;
import com.intellij.platform.execution.dashboard.tree.GroupingNode;
import com.intellij.platform.execution.dashboard.tree.RunConfigurationNode;
import com.intellij.platform.execution.dashboard.tree.RunDashboardGroupImpl;
import com.intellij.platform.execution.dashboard.tree.RunDashboardStatusFilter;
import com.intellij.platform.execution.serviceView.ServiceViewManagerImpl;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class RunDashboardServiceViewContributor
implements ServiceViewGroupingContributor<RunConfigurationContributor, GroupingNode>,
RunDashboardGroupNode {
    @NonNls
    static final String RUN_DASHBOARD_CONTENT_TOOLBAR = "RunDashboardContentToolbar";
    private static final DataProvider TREE_EXPANDER_HIDE_PROVIDER = id -> PlatformDataKeys.TREE_EXPANDER_HIDE_ACTIONS_IF_NO_EXPANDER.is(id) ? Boolean.valueOf(true) : null;

    @NotNull
    public ServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
        if (project == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(0);
        }
        return new RunDashboardContributorViewDescriptor(project);
    }

    @NotNull
    public @Unmodifiable List<RunConfigurationContributor> getServices(@NotNull Project project) {
        if (project == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(1);
        }
        RunDashboardManagerImpl runDashboardManager = (RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)project);
        List list = ContainerUtil.map(runDashboardManager.getRunConfigurations(), value -> new RunConfigurationContributor(new RunConfigurationNode(project, (RunDashboardManager.RunDashboardService)value, RunDashboardManagerImpl.getCustomizers(value.getSettings(), value.getDescriptor()))));
        if (list == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public ServiceViewDescriptor getServiceDescriptor(@NotNull Project project, @NotNull RunConfigurationContributor contributor) {
        if (project == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(3);
        }
        if (contributor == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(4);
        }
        ServiceViewDescriptor serviceViewDescriptor = contributor.getViewDescriptor(project);
        if (serviceViewDescriptor == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(5);
        }
        return serviceViewDescriptor;
    }

    @NotNull
    public List<GroupingNode> getGroups(@NotNull RunConfigurationContributor contributor) {
        if (contributor == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(6);
        }
        ArrayList<GroupingNode> result = new ArrayList<GroupingNode>();
        GroupingNode parentGroupNode = null;
        for (RunDashboardGroupingRule groupingRule : (RunDashboardGroupingRule[])RunDashboardManagerImpl.GROUPING_RULE_EP_NAME.getExtensions()) {
            RunDashboardGroup group = groupingRule.getGroup((AbstractTreeNode)contributor.asService());
            if (group == null) continue;
            GroupingNode node = new GroupingNode(contributor.asService().getProject(), parentGroupNode == null ? null : parentGroupNode.getGroup(), group);
            node.setParent(parentGroupNode);
            result.add(node);
            parentGroupNode = node;
        }
        ArrayList<GroupingNode> arrayList = result;
        if (arrayList == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    public ServiceViewDescriptor getGroupDescriptor(@NotNull GroupingNode node) {
        RunDashboardGroupImpl dashboardGroup;
        Object t;
        RunDashboardGroup group;
        if (node == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(8);
        }
        if ((group = node.getGroup()) instanceof FolderDashboardGroupingRule.FolderDashboardGroup) {
            return new RunDashboardFolderGroupViewDescriptor(node);
        }
        if (group instanceof RunDashboardGroupImpl && (t = (dashboardGroup = (RunDashboardGroupImpl)group).getValue()) instanceof ConfigurationType) {
            ConfigurationType type = (ConfigurationType)t;
            return new RunDashboardTypeGroupViewDescriptor(node, type);
        }
        return new RunDashboardGroupViewDescriptor(node);
    }

    @NotNull
    public @NotNull List<@NotNull Object> getChildren(@NotNull Project project, @NotNull AnActionEvent e) {
        if (project == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(9);
        }
        if (e == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(10);
        }
        List list = ((ServiceViewManagerImpl)ServiceViewManager.getInstance((Project)project)).getChildrenSafe(e, List.of(this), RunDashboardServiceViewContributor.class);
        if (list == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static ActionGroup getToolbarActions(@Nullable RunContentDescriptor descriptor) {
        DefaultActionGroup actionGroup = new DefaultActionGroup(){

            @NotNull
            public @NotNull List<? extends @NotNull AnAction> postProcessVisibleChildren(@NotNull AnActionEvent e, @NotNull @NotNull List<? extends @NotNull AnAction> visibleChildren) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (visibleChildren == null) {
                    1.$$$reportNull$$$0(1);
                }
                List<AnAction> list = visibleChildren.stream().filter(o -> !(o instanceof StopAction) && !(o instanceof FakeRerunAction) && !(o instanceof ExecutorAction)).toList();
                if (list == null) {
                    1.$$$reportNull$$$0(2);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "visibleChildren";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "postProcessVisibleChildren";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "postProcessVisibleChildren";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        DefaultActionGroup result = new DefaultActionGroup();
        result.add(ActionManager.getInstance().getAction(RUN_DASHBOARD_CONTENT_TOOLBAR));
        result.add((AnAction)actionGroup);
        RunnerLayoutUiImpl ui = RunDashboardManagerImpl.getRunnerLayoutUi(descriptor);
        if (ui != null) {
            actionGroup.addAll((Collection)ui.getContentUI().getActions(true));
        } else {
            ActionToolbar toolbar = RunDashboardManagerImpl.findActionToolbar(descriptor);
            if (toolbar != null) {
                actionGroup.add((AnAction)toolbar.getActionGroup());
            }
        }
        return result;
    }

    private static ActionGroup getPopupActions() {
        DefaultActionGroup actions = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        actions.add(actionManager.getAction(RUN_DASHBOARD_CONTENT_TOOLBAR));
        actions.addSeparator();
        actions.add(actionManager.getAction("RunDashboardPopup"));
        return actions;
    }

    @Nullable
    private static RunDashboardRunConfigurationNode getRunConfigurationNode(@NotNull DnDEvent event, @NotNull Project project) {
        if (event == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(12);
        }
        if (project == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(13);
        }
        try {
            List items = (List)event.getTransferData(ServiceViewDnDDescriptor.LIST_DATA_FLAVOR);
            Object item = ContainerUtil.getOnlyItem((Collection)items);
            if (item == null) {
                return null;
            }
            RunDashboardRunConfigurationNode node = (RunDashboardRunConfigurationNode)ObjectUtils.tryCast((Object)item, RunDashboardRunConfigurationNode.class);
            if (node != null && !node.getConfigurationSettings().getConfiguration().getProject().equals(project)) {
                return null;
            }
            return node;
        }
        catch (UnsupportedFlavorException | IOException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 7, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getServices";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroups";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getViewDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getServices";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 11: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getServiceDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getGroups";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getGroupDescriptor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRunConfigurationNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 7, 11 -> new IllegalStateException(string);
        };
    }

    private static final class RunDashboardContributorViewDescriptor
    extends SimpleServiceViewDescriptor
    implements ServiceViewToolWindowDescriptor {
        private final Project myProject;

        RunDashboardContributorViewDescriptor(@NotNull Project project) {
            if (project == null) {
                RunDashboardContributorViewDescriptor.$$$reportNull$$$0(0);
            }
            super("Run Dashboard", AllIcons.Actions.Execute);
            this.myProject = project;
        }

        public ActionGroup getToolbarActions() {
            return RunDashboardServiceViewContributor.getToolbarActions(null);
        }

        public ActionGroup getPopupActions() {
            return RunDashboardServiceViewContributor.getPopupActions();
        }

        public DataProvider getDataProvider() {
            return id -> PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(id) ? new RunDashboardServiceViewDeleteProvider() : TREE_EXPANDER_HIDE_PROVIDER.getData(id);
        }

        @Nullable
        public JComponent getContentComponent() {
            return ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)this.myProject)).getEmptyContent();
        }

        @NotNull
        public String getToolWindowId() {
            String string = this.getId();
            if (string == null) {
                RunDashboardContributorViewDescriptor.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public Icon getToolWindowIcon() {
            Icon icon = AllIcons.Toolwindows.ToolWindowRun;
            if (icon == null) {
                RunDashboardContributorViewDescriptor.$$$reportNull$$$0(2);
            }
            return icon;
        }

        @NotNull
        public String getStripeTitle() {
            String title;
            String string = title = this.getToolWindowId();
            if (string == null) {
                RunDashboardContributorViewDescriptor.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean isExclusionAllowed() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunDashboardContributorViewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunDashboardContributorViewDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolWindowId";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolWindowIcon";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStripeTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    static final class RunConfigurationContributor
    implements ServiceViewProvidingContributor<AbstractTreeNode<?>, RunConfigurationNode> {
        private final RunConfigurationNode myNode;

        RunConfigurationContributor(@NotNull RunConfigurationNode node) {
            if (node == null) {
                RunConfigurationContributor.$$$reportNull$$$0(0);
            }
            this.myNode = node;
        }

        @NotNull
        public RunConfigurationNode asService() {
            RunConfigurationNode runConfigurationNode = this.myNode;
            if (runConfigurationNode == null) {
                RunConfigurationContributor.$$$reportNull$$$0(1);
            }
            return runConfigurationNode;
        }

        @NotNull
        public ServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
            if (project == null) {
                RunConfigurationContributor.$$$reportNull$$$0(2);
            }
            return new RunConfigurationServiceViewDescriptor(this.myNode);
        }

        @NotNull
        public List<AbstractTreeNode<?>> getServices(@NotNull Project project) {
            if (project == null) {
                RunConfigurationContributor.$$$reportNull$$$0(3);
            }
            return new ArrayList(this.myNode.getChildren());
        }

        @NotNull
        public ServiceViewDescriptor getServiceDescriptor(@NotNull Project project, final @NotNull AbstractTreeNode service) {
            if (project == null) {
                RunConfigurationContributor.$$$reportNull$$$0(4);
            }
            if (service == null) {
                RunConfigurationContributor.$$$reportNull$$$0(5);
            }
            return new ServiceViewDescriptor(){

                public ActionGroup getToolbarActions() {
                    return RunDashboardServiceViewContributor.getToolbarActions(null);
                }

                public ActionGroup getPopupActions() {
                    return RunDashboardServiceViewContributor.getPopupActions();
                }

                @NotNull
                public ItemPresentation getPresentation() {
                    PresentationData presentationData = service.getPresentation();
                    if (presentationData == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return presentationData;
                }

                @Nullable
                public String getId() {
                    List fragments;
                    ItemPresentation presentation = this.getPresentation();
                    String text = presentation.getPresentableText();
                    if (!StringUtil.isEmpty((String)text)) {
                        return text;
                    }
                    if (presentation instanceof PresentationData && !(fragments = ((PresentationData)presentation).getColoredText()).isEmpty()) {
                        StringBuilder result = new StringBuilder();
                        for (PresentableNodeDescriptor.ColoredFragment fragment : fragments) {
                            result.append(fragment.getText());
                        }
                        return result.toString();
                    }
                    return null;
                }

                @Nullable
                public Runnable getRemover() {
                    return service instanceof RunDashboardNode ? ((RunDashboardNode)service).getRemover() : null;
                }

                @Nullable
                public JComponent getContentComponent() {
                    return ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)myNode.getProject())).getEmptyContent();
                }

                @NotNull
                public DataProvider getDataProvider() {
                    DataProvider dataProvider = TREE_EXPANDER_HIDE_PROVIDER;
                    if (dataProvider == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return dataProvider;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunConfigurationContributor$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getPresentation";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getDataProvider";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunConfigurationContributor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunConfigurationContributor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asService";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getViewDescriptor";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getServices";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getServiceDescriptor";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class RunDashboardFolderGroupViewDescriptor
    extends RunDashboardGroupViewDescriptor
    implements ServiceViewDnDDescriptor {
        RunDashboardFolderGroupViewDescriptor(GroupingNode node) {
            super(node);
        }

        @Override
        public Runnable getRemover() {
            return () -> {
                String groupName = this.myGroup.getName();
                Project project = ((FolderDashboardGroupingRule.FolderDashboardGroup)this.myGroup).getProject();
                List services = RunDashboardManager.getInstance((Project)project).getRunConfigurations();
                RunManagerImpl runManager = RunManagerImpl.getInstanceImpl((Project)project);
                runManager.fireBeginUpdate();
                try {
                    for (RunDashboardManager.RunDashboardService service : services) {
                        RunnerAndConfigurationSettings settings = service.getSettings();
                        if (!groupName.equals(settings.getFolderName())) continue;
                        settings.setFolderName(null);
                    }
                }
                finally {
                    runManager.fireEndUpdate();
                }
            };
        }

        public boolean canDrop(@NotNull DnDEvent event, @NotNull ServiceViewDnDDescriptor.Position position) {
            if (event == null) {
                RunDashboardFolderGroupViewDescriptor.$$$reportNull$$$0(0);
            }
            if (position == null) {
                RunDashboardFolderGroupViewDescriptor.$$$reportNull$$$0(1);
            }
            return position == ServiceViewDnDDescriptor.Position.INTO && RunDashboardServiceViewContributor.getRunConfigurationNode(event, ((FolderDashboardGroupingRule.FolderDashboardGroup)this.myGroup).getProject()) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(@NotNull DnDEvent event, @NotNull ServiceViewDnDDescriptor.Position position) {
            Project project;
            RunDashboardRunConfigurationNode node;
            if (event == null) {
                RunDashboardFolderGroupViewDescriptor.$$$reportNull$$$0(2);
            }
            if (position == null) {
                RunDashboardFolderGroupViewDescriptor.$$$reportNull$$$0(3);
            }
            if ((node = RunDashboardServiceViewContributor.getRunConfigurationNode(event, project = ((FolderDashboardGroupingRule.FolderDashboardGroup)this.myGroup).getProject())) == null) {
                return;
            }
            RunManagerImpl runManager = RunManagerImpl.getInstanceImpl((Project)project);
            runManager.fireBeginUpdate();
            try {
                node.getConfigurationSettings().setFolderName(this.myGroup.getName());
            }
            finally {
                runManager.fireEndUpdate();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunDashboardFolderGroupViewDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDrop";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "drop";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RunDashboardTypeGroupViewDescriptor
    extends RunDashboardGroupViewDescriptor {
        private final ConfigurationType myType;

        RunDashboardTypeGroupViewDescriptor(GroupingNode node, ConfigurationType type) {
            super(node);
            this.myType = type;
        }

        public void onNodeSelected(List<Object> selectedServices) {
            ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)this.myNode.getProject())).getTypeContent().setType(this.myType);
        }

        public void onNodeUnselected() {
            ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)this.myNode.getProject())).getTypeContent().setType(null);
        }

        @Override
        @Nullable
        public JComponent getContentComponent() {
            return ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)this.myNode.getProject())).getTypeContent();
        }

        @Override
        @Nullable
        public DataProvider getDataProvider() {
            return dataId -> {
                if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
                    RunDashboardTypePanel typeContent = ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)this.myNode.getProject())).getTypeContent();
                    return typeContent.getTreeExpander();
                }
                return TREE_EXPANDER_HIDE_PROVIDER.getData(dataId);
            };
        }
    }

    private static class RunDashboardGroupViewDescriptor
    implements ServiceViewDescriptor,
    WeighedItem {
        protected final RunDashboardGroup myGroup;
        protected final GroupingNode myNode;
        private final PresentationData myPresentationData;

        protected RunDashboardGroupViewDescriptor(GroupingNode node) {
            this.myNode = node;
            this.myGroup = node.getGroup();
            this.myPresentationData = new PresentationData();
            this.myPresentationData.setPresentableText(this.myGroup.getName());
            this.myPresentationData.setIcon(this.myGroup.getIcon());
        }

        @Nullable
        public String getId() {
            return RunDashboardGroupViewDescriptor.getId(this.myNode);
        }

        public ActionGroup getToolbarActions() {
            return RunDashboardServiceViewContributor.getToolbarActions(null);
        }

        public ActionGroup getPopupActions() {
            return RunDashboardServiceViewContributor.getPopupActions();
        }

        @NotNull
        public ItemPresentation getPresentation() {
            PresentationData presentationData = this.myPresentationData;
            if (presentationData == null) {
                RunDashboardGroupViewDescriptor.$$$reportNull$$$0(0);
            }
            return presentationData;
        }

        public int getWeight() {
            Object value = ((RunDashboardGroupImpl)this.myGroup).getValue();
            if (value instanceof WeighedItem) {
                return ((WeighedItem)value).getWeight();
            }
            return 0;
        }

        @Nullable
        public Runnable getRemover() {
            ConfigurationType type = (ConfigurationType)ObjectUtils.tryCast(((RunDashboardGroupImpl)this.myGroup).getValue(), ConfigurationType.class);
            if (type != null) {
                return () -> {
                    RunDashboardManager runDashboardManager = RunDashboardManager.getInstance((Project)this.myNode.getProject());
                    HashSet types = new HashSet(runDashboardManager.getTypes());
                    types.remove(type.getId());
                    runDashboardManager.setTypes(types);
                };
            }
            return null;
        }

        @Nullable
        public JComponent getContentComponent() {
            return ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)this.myNode.getProject())).getEmptyContent();
        }

        private static String getId(GroupingNode node) {
            AbstractTreeNode parent = node.getParent();
            if (parent instanceof GroupingNode) {
                return RunDashboardGroupViewDescriptor.getId((GroupingNode)parent) + "/" + RunDashboardGroupViewDescriptor.getId(node.getGroup());
            }
            return RunDashboardGroupViewDescriptor.getId(node.getGroup());
        }

        private static String getId(RunDashboardGroup group) {
            Object value;
            if (group instanceof RunDashboardGroupImpl && (value = ((RunDashboardGroupImpl)group).getValue()) instanceof ConfigurationType) {
                return ((ConfigurationType)value).getId();
            }
            return group.getName();
        }

        @Nullable
        public DataProvider getDataProvider() {
            return TREE_EXPANDER_HIDE_PROVIDER;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunDashboardGroupViewDescriptor", "getPresentation"));
        }
    }

    private static final class RunConfigurationServiceViewDescriptor
    implements ServiceViewDescriptor,
    ServiceViewLocatableDescriptor,
    ServiceViewDnDDescriptor {
        private final RunConfigurationNode myNode;

        RunConfigurationServiceViewDescriptor(RunConfigurationNode node) {
            this.myNode = node;
        }

        public String getId() {
            RunConfiguration configuration = this.myNode.getConfigurationSettings().getConfiguration();
            return configuration.getType().getId() + "/" + configuration.getName();
        }

        public JComponent getContentComponent() {
            RunDashboardManagerImpl manager = (RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)this.myNode.getProject());
            RunDashboardComponentWrapper wrapper = manager.getContentWrapper();
            Content content = this.myNode.getContent();
            if (content == null || content.getManager() != manager.getDashboardContentManager()) {
                wrapper.setContent(manager.getEmptyContent());
                wrapper.setContentId(null);
            } else {
                ContentManager contentManager = content.getManager();
                if (contentManager == null) {
                    return null;
                }
                wrapper.setContent(contentManager.getComponent());
                wrapper.setContentId(this.getContentId());
            }
            return wrapper;
        }

        private Integer getContentId() {
            RunContentDescriptor descriptor = this.myNode.getDescriptor();
            ProcessHandler handler = descriptor == null ? null : descriptor.getProcessHandler();
            return handler == null ? null : Integer.valueOf(handler.hashCode());
        }

        @NotNull
        public ItemPresentation getContentPresentation() {
            Content content = this.myNode.getContent();
            if (content != null) {
                return new PresentationData(content.getDisplayName(), null, content.getIcon(), null);
            }
            RunConfiguration configuration = this.myNode.getConfigurationSettings().getConfiguration();
            return new PresentationData(configuration.getName(), null, configuration.getIcon(), null);
        }

        public ActionGroup getToolbarActions() {
            return RunDashboardServiceViewContributor.getToolbarActions(this.myNode.getDescriptor());
        }

        public ActionGroup getPopupActions() {
            return RunDashboardServiceViewContributor.getPopupActions();
        }

        @NotNull
        public ItemPresentation getPresentation() {
            PresentationData presentationData = this.myNode.getPresentation();
            if (presentationData == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(0);
            }
            return presentationData;
        }

        public DataProvider getDataProvider() {
            Content content = this.myNode.getContent();
            if (content == null) {
                return TREE_EXPANDER_HIDE_PROVIDER;
            }
            DataProvider componentProvider = DataManagerImpl.getDataProviderEx((Object)content.getComponent());
            return id -> {
                Object data = TREE_EXPANDER_HIDE_PROVIDER.getData(id);
                if (data != null) {
                    return data;
                }
                return componentProvider == null ? null : componentProvider.getData(id);
            };
        }

        public void onNodeSelected(List<Object> selectedServices) {
            Content content = this.myNode.getContent();
            if (content == null) {
                return;
            }
            ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)this.myNode.getProject())).setSelectedContent(content);
        }

        public void onNodeUnselected() {
            Content content = this.myNode.getContent();
            if (content == null) {
                return;
            }
            ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)this.myNode.getProject())).removeFromSelection(content);
        }

        public Navigatable getNavigatable() {
            final NullableLazyValue value = NullableLazyValue.lazyNullable(() -> {
                for (RunDashboardCustomizer customizer : this.myNode.getCustomizers()) {
                    PsiElement psiElement = customizer.getPsiElement((RunDashboardRunConfigurationNode)this.myNode);
                    if (psiElement == null) continue;
                    return psiElement;
                }
                return null;
            });
            return new Navigatable(){

                public void navigate(boolean requestFocus) {
                    PsiNavigateUtil.navigate((PsiElement)((PsiElement)value.getValue()), (boolean)requestFocus);
                }

                public boolean canNavigate() {
                    return value.getValue() != null;
                }

                public boolean canNavigateToSource() {
                    return this.canNavigate();
                }
            };
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            return (VirtualFile)ReadAction.compute(() -> {
                for (RunDashboardCustomizer customizer : this.myNode.getCustomizers()) {
                    PsiElement psiElement = customizer.getPsiElement((RunDashboardRunConfigurationNode)this.myNode);
                    if (psiElement == null) continue;
                    return PsiUtilCore.getVirtualFile((PsiElement)psiElement);
                }
                return null;
            });
        }

        @Nullable
        public Object getPresentationTag(Object fragment) {
            Map links = (Map)this.myNode.getUserData(RunDashboardCustomizer.NODE_LINKS);
            return links == null ? null : links.get(fragment);
        }

        @Nullable
        public Runnable getRemover() {
            RunnerAndConfigurationSettings settings = this.myNode.getConfigurationSettings();
            RunManager runManager = RunManager.getInstance((Project)settings.getConfiguration().getProject());
            return runManager.hasSettings(settings) ? () -> runManager.removeConfiguration(settings) : null;
        }

        public boolean canDrop(@NotNull DnDEvent event, @NotNull ServiceViewDnDDescriptor.Position position) {
            if (event == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(1);
            }
            if (position == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(2);
            }
            if (position != ServiceViewDnDDescriptor.Position.INTO) {
                return RunDashboardServiceViewContributor.getRunConfigurationNode(event, this.myNode.getConfigurationSettings().getConfiguration().getProject()) != null;
            }
            for (RunDashboardCustomizer customizer : this.myNode.getCustomizers()) {
                if (!customizer.canDrop((RunDashboardRunConfigurationNode)this.myNode, event)) continue;
                return true;
            }
            return false;
        }

        public void drop(@NotNull DnDEvent event, @NotNull ServiceViewDnDDescriptor.Position position) {
            if (event == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(3);
            }
            if (position == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(4);
            }
            if (position != ServiceViewDnDDescriptor.Position.INTO) {
                Project project = this.myNode.getConfigurationSettings().getConfiguration().getProject();
                RunDashboardRunConfigurationNode node = RunDashboardServiceViewContributor.getRunConfigurationNode(event, project);
                if (node != null) {
                    this.reorderConfigurations(project, node, position);
                }
                return;
            }
            for (RunDashboardCustomizer customizer : this.myNode.getCustomizers()) {
                if (!customizer.canDrop((RunDashboardRunConfigurationNode)this.myNode, event)) continue;
                customizer.drop((RunDashboardRunConfigurationNode)this.myNode, event);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reorderConfigurations(Project project, RunDashboardRunConfigurationNode node, ServiceViewDnDDescriptor.Position position) {
            RunManagerImpl runManager = RunManagerImpl.getInstanceImpl((Project)project);
            runManager.fireBeginUpdate();
            try {
                node.getConfigurationSettings().setFolderName(this.myNode.getConfigurationSettings().getFolderName());
                Object2IntOpenHashMap indices = new Object2IntOpenHashMap();
                int i = 0;
                for (RunnerAndConfigurationSettings each : runManager.getAllSettings()) {
                    if (each.equals(node.getConfigurationSettings())) continue;
                    if (each.equals(this.myNode.getConfigurationSettings())) {
                        if (position == ServiceViewDnDDescriptor.Position.ABOVE) {
                            indices.put((Object)node.getConfigurationSettings(), i++);
                            indices.put((Object)this.myNode.getConfigurationSettings(), i++);
                            continue;
                        }
                        if (position != ServiceViewDnDDescriptor.Position.BELOW) continue;
                        indices.put((Object)this.myNode.getConfigurationSettings(), i++);
                        indices.put((Object)node.getConfigurationSettings(), i++);
                        continue;
                    }
                    indices.put((Object)each, i++);
                }
                runManager.setOrder(Comparator.comparingInt(arg_0 -> ((Object2IntMap)indices).getInt(arg_0)));
            }
            finally {
                runManager.fireEndUpdate();
            }
        }

        public boolean isVisible() {
            RunDashboardStatusFilter statusFilter = ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)this.myNode.getProject())).getStatusFilter();
            return statusFilter.isVisible(this.myNode);
        }

        public boolean handleDoubleClick(@NotNull MouseEvent event) {
            if (event == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(5);
            }
            if (!RunDashboardDoubleClickRunAction.Companion.isDoubleClickRunEnabled$intellij_platform_execution_dashboard()) {
                return super.handleDoubleClick(event);
            }
            final com.intellij.execution.Executor executor = this.getExecutor();
            if (executor == null) {
                return true;
            }
            DataContext dataContext = DataManager.getInstance().getDataContext(event.getComponent());
            ExecutorAction action = new ExecutorAction(){

                protected com.intellij.execution.Executor getExecutor() {
                    return executor;
                }

                protected void update(@NotNull AnActionEvent e, boolean running) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunConfigurationServiceViewDescriptor$2", "update"));
                }
            };
            Project project = this.myNode.getProject();
            Presentation presentation = new Presentation();
            AnActionEvent actionEvent = AnActionEvent.createEvent((DataContext)dataContext, (Presentation)presentation, (String)"ServicesPopup", (ActionUiKind)ActionUiKind.POPUP, (InputEvent)event);
            ReadAction.nonBlocking(() -> RunConfigurationServiceViewDescriptor.lambda$handleDoubleClick$4((AnAction)action, actionEvent, presentation)).coalesceBy(new Object[]{RunDashboardManager.getInstance((Project)project)}).expireWith((Disposable)project).finishOnUiThread(ModalityState.current(), arg_0 -> RunConfigurationServiceViewDescriptor.lambda$handleDoubleClick$5((AnAction)action, actionEvent, arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
            return true;
        }

        private com.intellij.execution.Executor getExecutor() {
            Set executors;
            com.intellij.execution.Executor executor;
            RunContentDescriptor descriptor = this.myNode.getDescriptor();
            if (descriptor != null && (executor = (com.intellij.execution.Executor)ContainerUtil.getFirstItem((Collection)(executors = ExecutionManager.getInstance((Project)this.myNode.getProject()).getExecutors(descriptor)))) != null) {
                return executor;
            }
            RunConfiguration configuration = this.myNode.getConfigurationSettings().getConfiguration();
            com.intellij.execution.Executor runExecutor = DefaultRunExecutor.getRunExecutorInstance();
            ProgramRunner runner = ProgramRunner.getRunner((String)runExecutor.getId(), (RunProfile)configuration);
            if (runner != null) {
                return runExecutor;
            }
            com.intellij.execution.Executor debugExecutor = ExecutorRegistry.getInstance().getExecutorById("Debug");
            if (debugExecutor != null && ProgramRunner.getRunner((String)"Debug", (RunProfile)configuration) != null) {
                return debugExecutor;
            }
            return null;
        }

        private static /* synthetic */ void lambda$handleDoubleClick$5(AnAction action, AnActionEvent actionEvent, Boolean enabled) {
            if (enabled.booleanValue()) {
                action.actionPerformed(actionEvent);
            }
        }

        private static /* synthetic */ Boolean lambda$handleDoubleClick$4(AnAction action, AnActionEvent actionEvent, Presentation presentation) throws Exception {
            action.update(actionEvent);
            return presentation.isEnabled();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunConfigurationServiceViewDescriptor";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunConfigurationServiceViewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "canDrop";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "drop";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "handleDoubleClick";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

