/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.DataGridBundle;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.connection.throwable.info.SimpleErrorInfo;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridAppearance;
import com.intellij.database.datagrid.DataGridWithNestedTables;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridModelWithNestedTables;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridSelection;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.HierarchicalColumnsCollapseManager;
import com.intellij.database.datagrid.HierarchicalColumnsDataGridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.NestedTable;
import com.intellij.database.datagrid.NestedTableGridPagingModel;
import com.intellij.database.datagrid.NestedTablesDataGridModel;
import com.intellij.database.datagrid.NestedTablesGridLoader;
import com.intellij.database.datagrid.NestedTablesSortingModel;
import com.intellij.database.datagrid.StaticNestedTable;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.table.FilterStateControllerForNestedTables;
import com.intellij.database.run.ui.table.LocalFilterState;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.components.breadcrumbs.Breadcrumbs;
import com.intellij.ui.components.breadcrumbs.Crumb;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HierarchicalTableResultPanel
extends TableResultPanel
implements DataGridWithNestedTables {
    private final Breadcrumbs myNestedTablesBreadcrumbs;
    private List<Crumb> myElementsOfBreadcrumbs;
    private final NestedTablesNavigationErrorPanel myNestedTablesNavigationErrorPanel;
    private final FilterStateControllerForNestedTables myLocalFilterStateManager;
    private final HierarchicalColumnsCollapseManager myHierarchicalColumnsCollapseManager;

    public HierarchicalTableResultPanel(@NotNull Project project, @NotNull GridDataHookUp<GridRow, GridColumn> dataHookUp, @NotNull ActionGroup popupActions, @NotNull BiConsumer<DataGrid, DataGridAppearance> configurator) {
        if (project == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(0);
        }
        if (dataHookUp == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(1);
        }
        if (popupActions == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(2);
        }
        if (configurator == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(3);
        }
        this(project, dataHookUp, popupActions, null, GridUtil.getGridColumnHeaderPopupActions(), ActionGroup.EMPTY_GROUP, false, configurator);
    }

    public HierarchicalTableResultPanel(@NotNull Project project, @NotNull GridDataHookUp<GridRow, GridColumn> dataHookUp, @NotNull ActionGroup popupActions, @Nullable ActionGroup gutterPopupActions, @NotNull ActionGroup columnHeaderActions, @NotNull ActionGroup rowHeaderActions, boolean useConsoleFonts, @NotNull BiConsumer<DataGrid, DataGridAppearance> configurator) {
        if (project == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(4);
        }
        if (dataHookUp == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(5);
        }
        if (popupActions == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(6);
        }
        if (columnHeaderActions == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(7);
        }
        if (rowHeaderActions == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(8);
        }
        if (configurator == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(9);
        }
        super(project, dataHookUp, popupActions, gutterPopupActions, columnHeaderActions, rowHeaderActions, useConsoleFonts, configurator);
        this.myNestedTablesNavigationErrorPanel = new NestedTablesNavigationErrorPanel();
        this.myHierarchicalColumnsCollapseManager = new HierarchicalColumnsCollapseManager(this, this.getColumnAttributes());
        DataGridSettings settings = GridUtil.getSettings(this);
        boolean isEnableLocalFilterByDefault = settings == null || settings.isEnableLocalFilterByDefault();
        this.myLocalFilterStateManager = new FilterStateControllerForNestedTables(this);
        this.myLocalFilterStateManager.getActiveFilterState().setEnabled(this.myLocalFilterStateManager.getActiveFilterState().isEnabled() && isEnableLocalFilterByDefault);
        if (HierarchicalTableResultPanel.isNestedTablesSupportEnabled(this.getDataModel())) {
            this.myNestedTablesBreadcrumbs = new Breadcrumbs();
            this.getPanel().setSecondBottomComponent((JComponent)this.myNestedTablesBreadcrumbs);
            this.myNestedTablesBreadcrumbs.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    HierarchicalTableResultPanel.this.onBreadCrumbClick(e.getX(), e.getY());
                }
            });
            this.myElementsOfBreadcrumbs = new ArrayList<Crumb>();
            this.myElementsOfBreadcrumbs.add((Crumb)new Crumb.Impl(AllIcons.Nodes.DataTables, " ", null, new Action[0]));
            this.myNestedTablesBreadcrumbs.setCrumbs(this.myElementsOfBreadcrumbs);
        } else {
            this.myNestedTablesBreadcrumbs = null;
        }
    }

    @Override
    public void rowsRemoved(ModelIndexSet<GridRow> rows) {
        this.recreateUIElementsRelatedToNestedTableIfNeeded();
        super.rowsRemoved(rows);
    }

    @Override
    public void cellsUpdated(ModelIndexSet<GridRow> rows, ModelIndexSet<GridColumn> columns, @Nullable GridRequestSource.RequestPlace place) {
        this.recreateUIElementsRelatedToNestedTableIfNeeded();
        super.cellsUpdated(rows, columns, place);
    }

    private void recreateUIElementsRelatedToNestedTableIfNeeded() {
        if (this.myElementsOfBreadcrumbs == null) {
            return;
        }
        if (!HierarchicalTableResultPanel.isNestedTablesSupportEnabled(this.getDataModel())) {
            return;
        }
        GridModelWithNestedTables modelWithNestedTables = (GridModelWithNestedTables)this.getDataModel();
        List pathToSelectedNestedTable = modelWithNestedTables.getPathToSelectedNestedTable();
        if (pathToSelectedNestedTable.size() == this.myElementsOfBreadcrumbs.size() - 1) {
            return;
        }
        this.updateBreadCrumbs(pathToSelectedNestedTable);
        this.updateNestedPageModels(pathToSelectedNestedTable);
        this.recreateColumns();
    }

    private void recreateColumns() {
        this.columnsAdded((ModelIndexSet<GridColumn>)this.getDataModel().getColumnIndices());
    }

    private void updateBreadCrumbs(@NotNull List<NestedTablesDataGridModel.NestedTableCellCoordinate> pathToSelectedNestedTable) {
        if (pathToSelectedNestedTable == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(10);
        }
        this.myElementsOfBreadcrumbs.subList(1, this.myElementsOfBreadcrumbs.size()).clear();
        for (NestedTablesDataGridModel.NestedTableCellCoordinate cellCoordinate : pathToSelectedNestedTable) {
            GridColumn column = cellCoordinate.getColumn();
            int rowNum = cellCoordinate.getRowNum();
            @NlsSafe String breadCrumbText = String.format("%s[%d]", column.getName(), rowNum);
            this.myElementsOfBreadcrumbs.add((Crumb)new Crumb.Impl(null, breadCrumbText, null, new Action[0]));
        }
        this.myNestedTablesBreadcrumbs.setCrumbs(this.myElementsOfBreadcrumbs);
    }

    private void updateNestedPageModels(@NotNull List<NestedTablesDataGridModel.NestedTableCellCoordinate> pathToSelectedNestedTable) {
        Object object;
        if (pathToSelectedNestedTable == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(11);
        }
        if ((object = this.getDataHookup().getPageModel()) instanceof NestedTableGridPagingModel) {
            NestedTablesDataGridModel.NestedTableCellCoordinate cellCoordinate;
            Object cellValue;
            NestedTableGridPagingModel nestedPaging = (NestedTableGridPagingModel)object;
            nestedPaging.reset();
            object = pathToSelectedNestedTable.iterator();
            while (object.hasNext() && (cellValue = (cellCoordinate = (NestedTablesDataGridModel.NestedTableCellCoordinate)object.next()).getColumn().getValue(cellCoordinate.getRow())) instanceof NestedTable) {
                NestedTable newSelectedNestedTable = (NestedTable)cellValue;
                nestedPaging.enterNestedTable(cellCoordinate, newSelectedNestedTable);
            }
        }
    }

    private void appendNestedTableBreadcrumb(@NlsSafe String colName, int rowNum) {
        @NlsSafe String breadCrumbText = String.format("%s[%d]", colName, rowNum);
        this.myElementsOfBreadcrumbs.add((Crumb)new Crumb.Impl(null, breadCrumbText, null, new Action[0]));
        this.myNestedTablesBreadcrumbs.setCrumbs(this.myElementsOfBreadcrumbs);
    }

    @Override
    public boolean onCellClick(@NotNull ModelIndex<GridRow> rowIdx, @NotNull ModelIndex<GridColumn> colIdx) {
        if (rowIdx == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(12);
        }
        if (colIdx == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(13);
        }
        if (this.tryUpdateGridToShowNestedTable(rowIdx, colIdx)) {
            if (this.getDataModel().getRowCount() != 0) {
                this.getResultView().resetScroll();
            }
            return true;
        }
        return false;
    }

    private boolean tryUpdateGridToShowNestedTable(@NotNull ModelIndex<GridRow> rowIdx, @NotNull ModelIndex<GridColumn> colIdx) {
        if (rowIdx == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(14);
        }
        if (colIdx == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(15);
        }
        if (this.myNestedTablesBreadcrumbs == null) {
            return false;
        }
        if (!this.isNestedTableSupportEnabled()) {
            return false;
        }
        GridRow row = (GridRow)this.getDataModel().getRow(rowIdx);
        GridColumn column = (GridColumn)this.getDataModel().getColumn(colIdx);
        if (column == null || row == null) {
            return false;
        }
        Object cellValue = this.getDataModel().getValueAt(rowIdx, colIdx);
        if (!(cellValue instanceof NestedTable)) {
            return false;
        }
        NestedTable newSelectedNestedTable = (NestedTable)cellValue;
        if (!this.isReady()) {
            this.myNestedTablesNavigationErrorPanel.show(SimpleErrorInfo.create((String)DataGridBundle.message((String)"grid.load.nested.table.error.loading", (Object[])new Object[0])));
            return false;
        }
        this.myNestedTablesNavigationErrorPanel.hideIfShown();
        if (!this.tryLoadNestedTable(newSelectedNestedTable, row, column)) {
            return false;
        }
        this.recreateColumns();
        this.appendNestedTableBreadcrumb(column.getName(), row.getRowNum());
        return true;
    }

    private boolean tryLoadNestedTable(@NotNull NestedTable newSelectedNestedTable, @NotNull GridRow row, @NotNull GridColumn column) {
        if (newSelectedNestedTable == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(16);
        }
        if (row == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(17);
        }
        if (column == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(18);
        }
        GridModelWithNestedTables modelWithNestedTables = (GridModelWithNestedTables)this.getDataModel();
        NestedTablesDataGridModel.NestedTableCellCoordinate coordinate = new NestedTablesDataGridModel.NestedTableCellCoordinate(row, column);
        this.myLocalFilterStateManager.enterNestedTable(coordinate, newSelectedNestedTable);
        GridSortingModel gridSortingModel = this.getDataHookup().getSortingModel();
        if (gridSortingModel instanceof NestedTablesSortingModel) {
            NestedTablesSortingModel sortingModel = (NestedTablesSortingModel)gridSortingModel;
            sortingModel.enterNestedTable(coordinate, newSelectedNestedTable);
        }
        if ((gridSortingModel = this.getDataHookup().getLoader()) instanceof NestedTablesGridLoader) {
            NestedTablesGridLoader nestedTablesAwareGridLoader = (NestedTablesGridLoader)gridSortingModel;
            if (nestedTablesAwareGridLoader.isLoadAllowed()) {
                this.myNestedTablesNavigationErrorPanel.show(SimpleErrorInfo.create((String)DataGridBundle.message((String)"grid.load.nested.table.error", (Object[])new Object[0])));
                return false;
            }
            this.myNestedTablesNavigationErrorPanel.hideIfShown();
            modelWithNestedTables.enterNestedTable(coordinate, newSelectedNestedTable);
            GridPagingModel gridPagingModel = this.getDataHookup().getPageModel();
            if (gridPagingModel instanceof NestedTableGridPagingModel) {
                nestedPaging = (NestedTableGridPagingModel)gridPagingModel;
                nestedPaging.enterNestedTable(coordinate, newSelectedNestedTable);
            }
            if (!(newSelectedNestedTable instanceof StaticNestedTable)) {
                nestedTablesAwareGridLoader.enterNestedTable(coordinate, newSelectedNestedTable);
                this.getDataHookup().getLoader().loadFirstPage(new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)this)));
            }
        } else {
            modelWithNestedTables.enterNestedTable(coordinate, newSelectedNestedTable);
            GridPagingModel gridPagingModel = this.getDataHookup().getPageModel();
            if (gridPagingModel instanceof NestedTableGridPagingModel) {
                nestedPaging = (NestedTableGridPagingModel)gridPagingModel;
                nestedPaging.enterNestedTable(coordinate, newSelectedNestedTable);
            }
        }
        return true;
    }

    @Override
    public void onBreadCrumbClick(int x, int y) {
        int depth;
        if (this.myNestedTablesBreadcrumbs == null) {
            return;
        }
        if (!this.isNestedTableSupportEnabled()) {
            return;
        }
        Crumb clicked = this.myNestedTablesBreadcrumbs.getCrumbAt(x, y);
        if (clicked == null) {
            return;
        }
        int idx = this.myElementsOfBreadcrumbs.indexOf(clicked);
        if (idx == (depth = this.myElementsOfBreadcrumbs.size()) - 1) {
            return;
        }
        if (this.getDataModel().isUpdatingNow()) {
            String text = clicked.getText();
            this.myNestedTablesNavigationErrorPanel.show(SimpleErrorInfo.create((String)DataGridBundle.message((String)"grid.load.prev.nested.table.error.loading", (Object[])new Object[]{text.isBlank() ? "top level" : text})));
            return;
        }
        this.myNestedTablesNavigationErrorPanel.hideIfShown();
        int steps = depth - (idx + 1);
        this.updateGridToShowPreviousNestedTable(steps);
    }

    private void updateGridToShowPreviousNestedTable(int steps) {
        GridModelWithNestedTables modelWithNestedTables = (GridModelWithNestedTables)this.getDataModel();
        NestedTablesDataGridModel.NestedTableCellCoordinate coordinateToRestoreScroll = modelWithNestedTables.exitNestedTable(steps);
        GridPagingModel gridPagingModel = this.getDataHookup().getPageModel();
        if (gridPagingModel instanceof NestedTableGridPagingModel) {
            NestedTableGridPagingModel nestedPaging = (NestedTableGridPagingModel)gridPagingModel;
            nestedPaging.exitNestedTable(steps);
        }
        if ((gridPagingModel = this.getDataHookup().getLoader()) instanceof NestedTablesGridLoader) {
            NestedTablesGridLoader nestedTablesAwareGridLoader = (NestedTablesGridLoader)gridPagingModel;
            nestedTablesAwareGridLoader.exitNestedTable(steps);
        }
        this.myLocalFilterStateManager.exitNestedTable(steps);
        gridPagingModel = this.getDataHookup().getSortingModel();
        if (gridPagingModel instanceof NestedTablesSortingModel) {
            NestedTablesSortingModel sortingModel = (NestedTablesSortingModel)gridPagingModel;
            sortingModel.exitNestedTable(steps);
        }
        this.recreateColumns();
        HierarchicalTableResultPanel.removeTail(this.myElementsOfBreadcrumbs, steps);
        this.myNestedTablesBreadcrumbs.setCrumbs(this.myElementsOfBreadcrumbs);
        if (coordinateToRestoreScroll == null) {
            return;
        }
        this.showCell(coordinateToRestoreScroll.getRowIdx(), (ModelIndex<GridColumn>)coordinateToRestoreScroll.getColumnIdx((CoreGrid)this));
    }

    @Override
    public boolean isNestedTableSupportEnabled() {
        GridModelWithNestedTables modelWithNestedTables;
        GridModel<GridRow, GridColumn> gridModel = this.getDataModel();
        return gridModel instanceof GridModelWithNestedTables && (modelWithNestedTables = (GridModelWithNestedTables)gridModel).isNestedTablesSupportEnabled();
    }

    @Override
    public boolean isNestedTableStatic() {
        return this.isNestedTableSupportEnabled() && ((GridModelWithNestedTables)this.getDataModel()).getSelectedNestedTable() instanceof StaticNestedTable;
    }

    @Override
    public boolean isTopLevelGrid() {
        GridModel<GridRow, GridColumn> model2 = this.getDataModel();
        if (!(model2 instanceof GridModelWithNestedTables)) {
            return true;
        }
        GridModelWithNestedTables modelWithNestedTables = (GridModelWithNestedTables)model2;
        return modelWithNestedTables.isTopLevelGrid();
    }

    @Override
    public void afterLastRowAdded() {
        super.afterLastRowAdded();
        this.myNestedTablesNavigationErrorPanel.hideIfShown();
    }

    @Override
    @NotNull
    public LocalFilterState getLocalFilterState() {
        LocalFilterState localFilterState = this.myLocalFilterStateManager.getActiveFilterState();
        if (localFilterState == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(19);
        }
        return localFilterState;
    }

    private static void removeTail(@NotNull List<?> list, int k) {
        if (list == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(20);
        }
        list.subList(Math.max(0, list.size() - k), list.size()).clear();
    }

    @Override
    public void setColumnEnabled(@NotNull ModelIndex<GridColumn> columnIdx, boolean state) {
        GridColumn column;
        if (columnIdx == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(21);
        }
        if ((column = (GridColumn)this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(columnIdx)) == null || this.isColumnEnabled(column) == state) {
            return;
        }
        if (!(column instanceof HierarchicalColumnsDataGridModel.HierarchicalGridColumn)) {
            this.updateColumnEnableState(column, state);
            return;
        }
        HierarchicalColumnsDataGridModel.HierarchicalGridColumn hierarchicalColumn = (HierarchicalColumnsDataGridModel.HierarchicalGridColumn)column;
        if (state) {
            this.updateEnableStateForColumns(this.getDisabledAncestorColumns(hierarchicalColumn), state);
            this.updateColumnEnableState(column, state);
            return;
        }
        HierarchicalColumnsDataGridModel.HierarchicalGridColumn ancestor = hierarchicalColumn.getParent();
        if (hierarchicalColumn.isLeftMostChildOfDirectAncestor() && ancestor != null) {
            this.updateEnableStateForColumns(ancestor.getLeaves(), state);
        } else {
            this.updateColumnEnableState(column, state);
        }
        this.getResultView().onColumnHierarchyChanged();
    }

    static boolean isNestedTablesSupportEnabled(GridModel<GridRow, GridColumn> model2) {
        return model2 instanceof GridModelWithNestedTables && ((GridModelWithNestedTables)model2).isNestedTablesSupportEnabled();
    }

    @Override
    @Nullable
    public HierarchicalColumnsCollapseManager getHierarchicalColumnsCollapseManager() {
        return this.myHierarchicalColumnsCollapseManager;
    }

    @NotNull
    private List<? extends GridColumn> getDisabledAncestorColumns(@NotNull HierarchicalColumnsDataGridModel.HierarchicalGridColumn gridColumn) {
        if (gridColumn == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(22);
        }
        LinkedList<HierarchicalColumnsDataGridModel.HierarchicalGridColumn> columnsBranchToUpdate = new LinkedList<HierarchicalColumnsDataGridModel.HierarchicalGridColumn>();
        for (HierarchicalColumnsDataGridModel.HierarchicalGridColumn ancestor = gridColumn.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            List leaves = ancestor.getLeaves();
            HierarchicalColumnsDataGridModel.HierarchicalGridColumn leftMostChild = (HierarchicalColumnsDataGridModel.HierarchicalGridColumn)leaves.get(0);
            if (!Boolean.FALSE.equals(this.getColumnAttributes().isEnabled((GridColumn)leftMostChild))) break;
            columnsBranchToUpdate.addFirst(leftMostChild);
        }
        LinkedList<HierarchicalColumnsDataGridModel.HierarchicalGridColumn> linkedList = columnsBranchToUpdate;
        if (linkedList == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(23);
        }
        return linkedList;
    }

    private void updateEnableStateForColumns(@NotNull List<? extends GridColumn> columns, boolean state) {
        if (columns == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(24);
        }
        for (GridColumn gridColumn : columns) {
            this.updateColumnEnableState(gridColumn, state);
        }
    }

    private void updateColumnEnableState(@NotNull GridColumn c, boolean state) {
        if (c == null) {
            HierarchicalTableResultPanel.$$$reportNull$$$0(25);
        }
        this.getColumnAttributes().setEnabled(c, state);
        if (this.myHierarchicalColumnsCollapseManager.isColumnHiddenDueToCollapse(c)) {
            return;
        }
        GridSelection selection = this.getSelectionModel().store();
        ModelIndex colIdx = ModelIndex.forColumn((CoreGrid)this, (int)c.getColumnNumber());
        this.storeOrRestoreSelection((ModelIndex<GridColumn>)colIdx, state, (GridSelection<GridRow, GridColumn>)selection);
        this.getResultView().setColumnEnabled((ModelIndex<GridColumn>)colIdx, state);
        this.fireContentChanged(null);
        this.runWithIgnoreSelectionChanges(() -> this.getSelectionModel().restore(selection));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 19, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHookUp";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupActions";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnHeaderActions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowHeaderActions";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToSelectedNestedTable";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colIdx";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSelectedNestedTable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/HierarchicalTableResultPanel";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gridColumn";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/HierarchicalTableResultPanel";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalFilterState";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledAncestorColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateBreadCrumbs";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateNestedPageModels";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "onCellClick";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryUpdateGridToShowNestedTable";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadNestedTable";
                break;
            }
            case 19: 
            case 23: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeTail";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setColumnEnabled";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDisabledAncestorColumns";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "updateEnableStateForColumns";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "updateColumnEnableState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 19, 23 -> new IllegalStateException(string);
        };
    }

    class NestedTablesNavigationErrorPanel {
        private boolean hasShown = false;

        NestedTablesNavigationErrorPanel() {
        }

        public void show(ErrorInfo errorInfo) {
            HierarchicalTableResultPanel.this.showError(errorInfo, null);
            this.hasShown = true;
        }

        public void hideIfShown() {
            if (this.hasShown) {
                HierarchicalTableResultPanel.this.hideErrorPanel();
                this.hasShown = false;
            }
        }
    }
}

