/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeParameter;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.KVariance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataFrameKt;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.aggregation.AggregateGroupedDsl;
import org.jetbrains.kotlinx.dataframe.api.CastKt;
import org.jetbrains.kotlinx.dataframe.api.ColumnsSelectionDsl;
import org.jetbrains.kotlinx.dataframe.api.Convert;
import org.jetbrains.kotlinx.dataframe.api.GroupBy;
import org.jetbrains.kotlinx.dataframe.api.GroupedDataRow;
import org.jetbrains.kotlinx.dataframe.api.Infer;
import org.jetbrains.kotlinx.dataframe.api.RemoveKt;
import org.jetbrains.kotlinx.dataframe.api.RenameClause;
import org.jetbrains.kotlinx.dataframe.api.RenameKt;
import org.jetbrains.kotlinx.dataframe.api.TypeConversionsKt;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReference;
import org.jetbrains.kotlinx.dataframe.columns.ColumnSet;
import org.jetbrains.kotlinx.dataframe.columns.ColumnsResolver;
import org.jetbrains.kotlinx.dataframe.columns.FrameColumn;
import org.jetbrains.kotlinx.dataframe.columns.SingleColumn;
import org.jetbrains.kotlinx.dataframe.impl.GroupByImplKt;
import org.jetbrains.kotlinx.dataframe.impl.aggregation.AggregatableInternal;
import org.jetbrains.kotlinx.dataframe.impl.api.ConvertKt;
import org.jetbrains.kotlinx.dataframe.impl.api.GroupedDataRowImpl;
import org.jetbrains.kotlinx.dataframe.impl.columns.ConstructorsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00020\u0004Bm\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u0012J\u0010\t\u001aF\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u000b\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00010\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\nj\f\u0012\u0004\u0012\u00028\u0001\u0012\u0002\b\u0003`\u0010\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\u0010\u0012J^\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\"\u0004\b\u0002\u0010\u001e2H\u0010\u001f\u001aD\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010 \u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00010 \u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u0002H\u001e0\nj\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u0002H\u001e`!\u00a2\u0006\u0002\b\u0011H\u0016J[\u0010\"\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00032E\u0010#\u001aA\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010$\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010$\u0012\u0004\u0012\u00020%0\nj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`&\u00a2\u0006\u0002\b\u0011H\u0016JF\u0010'\u001a@\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0017\u0012\u0015\u0012\u0002\b\u00030\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\nj\n\u0012\u0002\b\u0003\u0012\u0002\b\u0003`\u0010\u00a2\u0006\u0002\b\u0011H\u0016J\u0018\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\b\u0010+\u001a\u00020*H\u0016Jv\u0010,\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u001e0\u0003\"\u0004\b\u0002\u0010\u001e2Z\u0010-\u001aV\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001e0\u00060\nj\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001e0\u0006`.\u00a2\u0006\u0002\b\u0011H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016RX\u0010\t\u001aF\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u000b\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00010\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\nj\f\u0012\u0004\u0012\u00028\u0001\u0012\u0002\b\u0003`\u0010\u00a2\u0006\u0002\b\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00068VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001a\u0010\u0014\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/GroupByImpl;", "T", "G", "Lorg/jetbrains/kotlinx/dataframe/api/GroupBy;", "Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/AggregatableInternal;", "df", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "groups", "Lorg/jetbrains/kotlinx/dataframe/columns/FrameColumn;", "keyColumnsInGroups", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/dataframe/api/ColumnsSelectionDsl;", "Lkotlin/ParameterName;", "name", "it", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnsResolver;", "Lorg/jetbrains/kotlinx/dataframe/ColumnsSelector;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame;Lorg/jetbrains/kotlinx/dataframe/columns/FrameColumn;Lkotlin/jvm/functions/Function2;)V", "getDf", "()Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "getGroups", "()Lorg/jetbrains/kotlinx/dataframe/columns/FrameColumn;", "getKeyColumnsInGroups$core", "()Lkotlin/jvm/functions/Function2;", "keys", "getKeys", "keys$delegate", "Lkotlin/Lazy;", "aggregate", "R", "body", "Lorg/jetbrains/kotlinx/dataframe/aggregation/AggregateGroupedDsl;", "Lorg/jetbrains/kotlinx/dataframe/aggregation/AggregateGroupedBody;", "filter", "predicate", "Lorg/jetbrains/kotlinx/dataframe/api/GroupedDataRow;", "", "Lorg/jetbrains/kotlinx/dataframe/api/GroupedRowFilter;", "remainingColumnsSelector", "toDataFrame", "groupedColumnName", "", "toString", "updateGroups", "transform", "Lorg/jetbrains/kotlinx/dataframe/Selector;", "core"})
@SourceDebugExtension(value={"SMAP\nGroupByImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroupByImpl.kt\norg/jetbrains/kotlinx/dataframe/impl/GroupByImpl\n+ 2 convert.kt\norg/jetbrains/kotlinx/dataframe/api/ConvertKt\n+ 3 Utils.kt\norg/jetbrains/kotlinx/dataframe/impl/UtilsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n54#2,7:109\n96#2:119\n289#3:116\n37#4,2:117\n1#5:120\n766#6:121\n857#6,2:122\n*S KotlinDebug\n*F\n+ 1 GroupByImpl.kt\norg/jetbrains/kotlinx/dataframe/impl/GroupByImpl\n*L\n49#1:109,7\n49#1:119\n49#1:116\n49#1:117,2\n61#1:121\n61#1:122,2\n*E\n"})
public final class GroupByImpl<T, G>
implements GroupBy<T, G>,
AggregatableInternal<G> {
    @NotNull
    private final DataFrame<T> df;
    @NotNull
    private final FrameColumn<G> groups;
    @NotNull
    private final Function2<ColumnsSelectionDsl<? extends G>, ColumnsSelectionDsl<? extends G>, ColumnsResolver<?>> keyColumnsInGroups;
    @NotNull
    private final Lazy keys$delegate;

    public GroupByImpl(@NotNull DataFrame<? extends T> df2, @NotNull FrameColumn<? extends G> groups2, @NotNull Function2<? super ColumnsSelectionDsl<? extends G>, ? super ColumnsSelectionDsl<? extends G>, ? extends ColumnsResolver<?>> keyColumnsInGroups) {
        Intrinsics.checkNotNullParameter(df2, (String)"df");
        Intrinsics.checkNotNullParameter(groups2, (String)"groups");
        Intrinsics.checkNotNullParameter(keyColumnsInGroups, (String)"keyColumnsInGroups");
        this.df = df2;
        this.groups = groups2;
        this.keyColumnsInGroups = keyColumnsInGroups;
        this.keys$delegate = LazyKt.lazy((Function0)new Function0<DataFrame<? extends T>>(this){
            final /* synthetic */ GroupByImpl<T, G> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DataFrame<T> invoke() {
                return RemoveKt.minus(this.this$0.getDf(), (ColumnReference)this.this$0.getGroups());
            }
        });
    }

    @NotNull
    public final DataFrame<T> getDf() {
        return this.df;
    }

    @Override
    @NotNull
    public FrameColumn<G> getGroups() {
        return this.groups;
    }

    @NotNull
    public final Function2<ColumnsSelectionDsl<? extends G>, ColumnsSelectionDsl<? extends G>, ColumnsResolver<?>> getKeyColumnsInGroups$core() {
        return this.keyColumnsInGroups;
    }

    @Override
    @NotNull
    public DataFrame<T> getKeys() {
        Lazy lazy = this.keys$delegate;
        return (DataFrame)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <R> GroupBy<T, R> updateGroups(@NotNull Function2<? super DataFrame<? extends G>, ? super DataFrame<? extends G>, ? extends DataFrame<? extends R>> transform2) {
        void $this$convert_u24default$iv;
        void cols$iv;
        void firstCol$iv;
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        DataFrame<T> dataFrame = this.df;
        ColumnReference columnReference = this.getGroups();
        ColumnReference[] columnReferenceArray = new ColumnReference[]{};
        Function2 expression$iv = new Function2<DataRow<? extends T>, DataFrame<? extends G>, DataFrame<? extends R>>(transform2){
            final /* synthetic */ Function2<DataFrame<? extends G>, DataFrame<? extends G>, DataFrame<R>> $transform;
            {
                this.$transform = $transform;
                super(2);
            }

            @NotNull
            public final DataFrame<R> invoke(@NotNull DataRow<? extends T> $this$convert, @NotNull DataFrame<? extends G> it) {
                Intrinsics.checkNotNullParameter($this$convert, (String)"$this$convert");
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return (DataFrame)this.$transform.invoke(it, it);
            }
        };
        Infer infer$iv = Infer.Nulls;
        boolean $i$f$convert = false;
        boolean $i$f$headPlusArray = false;
        Collection $this$toTypedArray$iv$iv$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)firstCol$iv), (Iterable)ArraysKt.toList((Object[])cols$iv));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv$iv$iv = $this$toTypedArray$iv$iv$iv;
        ColumnReference[] columnReferenceArray2 = thisCollection$iv$iv$iv.toArray(new ColumnReference[0]);
        Convert $this$with$iv$iv = org.jetbrains.kotlinx.dataframe.api.ConvertKt.convert($this$convert_u24default$iv, Arrays.copyOf(columnReferenceArray2, columnReferenceArray2.length));
        boolean $i$f$with = false;
        KTypeParameter kTypeParameter = Reflection.typeParameter((Object)new FunctionReferenceImpl(2, GroupByImpl.class, "updateGroups", "updateGroups(Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlinx/dataframe/api/GroupBy;", 0), (String)"R", (KVariance)KVariance.INVARIANT, (boolean)false);
        Reflection.setUpperBounds((KTypeParameter)kTypeParameter, (KType)Reflection.nullableTypeOf(Object.class));
        GroupBy groupBy2 = TypeConversionsKt.asGroupBy(ConvertKt.withRowCellImpl($this$with$iv$iv, Reflection.typeOf(DataFrame.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf((KClassifier)kTypeParameter))), infer$iv, expression$iv), this.getGroups().name());
        Intrinsics.checkNotNull(groupBy2, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dataframe.api.GroupBy<T of org.jetbrains.kotlinx.dataframe.impl.GroupByImpl, R of org.jetbrains.kotlinx.dataframe.impl.GroupByImpl.updateGroups>");
        return groupBy2;
    }

    @Override
    @NotNull
    public DataFrame<T> toDataFrame(@Nullable String groupedColumnName) {
        DataFrame<T> dataFrame;
        if (groupedColumnName == null || Intrinsics.areEqual((Object)groupedColumnName, (Object)this.getGroups().name())) {
            dataFrame = this.df;
        } else {
            Object[] objectArray = new ColumnReference[]{this.getGroups()};
            RenameClause renameClause = RenameKt.rename(this.df, objectArray);
            objectArray = new String[]{groupedColumnName};
            dataFrame = RenameKt.into(renameClause, (String[])objectArray);
        }
        return dataFrame;
    }

    @NotNull
    public String toString() {
        return this.df.toString();
    }

    @Override
    @NotNull
    public Function2<ColumnsSelectionDsl<?>, ColumnsSelectionDsl<?>, ColumnsResolver<?>> remainingColumnsSelector() {
        ColumnSet<?> groupCols = ConstructorsKt.toColumnSet(this.keyColumnsInGroups);
        boolean bl = false;
        return new Function2<ColumnsSelectionDsl<?>, ColumnsSelectionDsl<?>, ColumnSet<? extends Object>>(groupCols){
            final /* synthetic */ ColumnSet<Object> $groupCols;
            {
                this.$groupCols = $groupCols;
                super(2);
            }

            @NotNull
            public final ColumnSet<Object> invoke(@NotNull ColumnsSelectionDsl<?> $this$null, @NotNull ColumnsSelectionDsl<?> it) {
                Intrinsics.checkNotNullParameter($this$null, (String)"$this$null");
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return $this$null.except((ColumnSet)$this$null.all($this$null), (ColumnsResolver<?>)this.$groupCols);
            }
        };
    }

    @Override
    @NotNull
    public <R> DataFrame<G> aggregate(@NotNull Function2<? super AggregateGroupedDsl<? extends G>, ? super AggregateGroupedDsl<? extends G>, ? extends R> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return CastKt.cast(GroupByImplKt.aggregateGroupBy(GroupBy.DefaultImpls.toDataFrame$default(this, null, 1, null), (Function2)new Function2<ColumnsSelectionDsl<? extends T>, ColumnsSelectionDsl<? extends T>, SingleColumn<? extends DataFrame<? extends G>>>(this){
            final /* synthetic */ GroupByImpl<T, G> this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final SingleColumn<DataFrame<G>> invoke(@NotNull ColumnsSelectionDsl<? extends T> $this$aggregateGroupBy, @NotNull ColumnsSelectionDsl<? extends T> it) {
                Intrinsics.checkNotNullParameter($this$aggregateGroupBy, (String)"$this$aggregateGroupBy");
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.this$0.getGroups();
            }
        }, true, body));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public GroupBy<T, G> filter(@NotNull Function2<? super GroupedDataRow<? extends T, ? extends G>, ? super GroupedDataRow<? extends T, ? extends G>, Boolean> predicate2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(predicate2, (String)"predicate");
        Iterable $this$filter$iv = (Iterable)RangesKt.until((int)0, (int)DataFrameKt.getNrow(this.df));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            GroupedDataRowImpl<T, G> row = new GroupedDataRowImpl<T, G>(this.df.get(it), this.getGroups());
            if (!((Boolean)predicate2.invoke(row, row)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List indices = (List)destination$iv$iv;
        return TypeConversionsKt.asGroupBy(this.df.get(indices), (ColumnReference)this.getGroups());
    }
}

