/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.columns;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.ColumnsContainer;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.CastKt;
import org.jetbrains.kotlinx.dataframe.api.DataColumnTypeKt;
import org.jetbrains.kotlinx.dataframe.api.TypeConversionsKt;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.ColumnAccessor;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReference;
import org.jetbrains.kotlinx.dataframe.columns.ColumnResolutionContext;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\b\u0016\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ#\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\f0\u0000\"\u0004\b\u0001\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eH\u0096\u0002J\u001d\u0010\u000f\u001a\u00028\u00002\u000e\u0010\u0010\u001a\n\u0012\u0002\b\u00030\u0011j\u0002`\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0014\u001a\u00028\u00002\u000e\u0010\u0010\u001a\n\u0012\u0002\b\u00030\u0011j\u0002`\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\b\u0010\u0003\u001a\u00020\u0007H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u0018\u0010\u0018\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/columns/ColumnAccessorImpl;", "T", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnAccessor;", "path", "", "", "([Ljava/lang/String;)V", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "(Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;)V", "getPath", "()Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "get", "C", "column", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;", "getValue", "row", "Lorg/jetbrains/kotlinx/dataframe/DataRow;", "Lorg/jetbrains/kotlinx/dataframe/AnyRow;", "(Lorg/jetbrains/kotlinx/dataframe/DataRow;)Ljava/lang/Object;", "getValueOrNull", "name", "rename", "newName", "resolveSingle", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnWithPath;", "context", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnResolutionContext;", "core"})
@SourceDebugExtension(value={"SMAP\nColumnAccessorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColumnAccessorImpl.kt\norg/jetbrains/kotlinx/dataframe/impl/columns/ColumnAccessorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1804#2,4:49\n*S KotlinDebug\n*F\n+ 1 ColumnAccessorImpl.kt\norg/jetbrains/kotlinx/dataframe/impl/columns/ColumnAccessorImpl\n*L\n24#1:49,4\n*E\n"})
public final class ColumnAccessorImpl<T>
implements ColumnAccessor<T> {
    @NotNull
    private final ColumnPath path;

    public ColumnAccessorImpl(@NotNull ColumnPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
    }

    @NotNull
    public final ColumnPath getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public String name() {
        return (String)CollectionsKt.last((List)this.path);
    }

    @Override
    @NotNull
    public ColumnPath path() {
        return this.path;
    }

    public ColumnAccessorImpl(String ... path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this(TypeConversionsKt.toPath(path));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ColumnWithPath<T> resolveSingle(@NotNull ColumnResolutionContext context) {
        void $this$foldIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = ColumnPath.dropLast$default(this.path, 0, 1, null);
        DataFrame initial$iv = context.getDf$core();
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        DataFrame accumulator$iv = initial$iv;
        for (Object element$iv : $this$foldIndexed$iv) {
            DataColumn col2;
            void colName;
            void df2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)element$iv;
            DataFrame dataFrame = accumulator$iv;
            int i = n;
            boolean bl = false;
            if (UtilsKt.getColumn((ColumnsContainer)df2, (String)colName, context.getUnresolvedColumnsPolicy$core()) == null) {
                return null;
            }
            if (!DataColumnTypeKt.isColumnGroup(col2)) {
                throw new IllegalStateException(("Cannot resolve column '" + CollectionsKt.joinToString$default((Iterable)this.path.subList(0, i + 2), (CharSequence)".", null, null, (int)0, null, null, (int)62, null) + "': Column '" + CollectionsKt.joinToString$default((Iterable)this.path.subList(0, i + 1), (CharSequence)".", null, null, (int)0, null, null, (int)62, null) + "' is not a column group.").toString());
            }
            accumulator$iv = TypeConversionsKt.asColumnGroupUntyped(col2);
        }
        DataColumn dataColumn = UtilsKt.getColumn((ColumnsContainer)accumulator$iv, (String)CollectionsKt.last((List)this.path), context.getUnresolvedColumnsPolicy$core());
        return dataColumn != null && (object = CastKt.cast(dataColumn)) != null ? UtilsKt.addPath((BaseColumn)object, this.path) : null;
    }

    @Override
    @NotNull
    public ColumnAccessorImpl<T> rename(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        return new ColumnAccessorImpl<T>(this.path.dropLast(1).plus(newName));
    }

    @Override
    @NotNull
    public <C> ColumnAccessorImpl<C> get(@NotNull ColumnReference<? extends C> column2) {
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        return new ColumnAccessorImpl<T>(this.path.plus(column2.path()));
    }

    @Override
    public T getValue(@NotNull DataRow<?> row) {
        Intrinsics.checkNotNullParameter(row, (String)"row");
        return (T)this.path.getValue(row);
    }

    @Override
    public T getValueOrNull(@NotNull DataRow<?> row) {
        Intrinsics.checkNotNullParameter(row, (String)"row");
        return (T)this.path.getValueOrNull(row);
    }

    @Override
    @NotNull
    public ColumnAccessor<T> getValue(@Nullable Object thisRef, @NotNull KProperty<?> property) {
        return ColumnAccessor.DefaultImpls.getValue(this, thisRef, property);
    }

    @Override
    @NotNull
    public List<ColumnWithPath<T>> resolve(@NotNull ColumnResolutionContext context) {
        return ColumnAccessor.DefaultImpls.resolve(this, context);
    }
}

